
package com.flagsmith.flagengine;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * FeatureContext
 * <p>
 * Represents a feature context for feature flag evaluation.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "key",
    "name",
    "enabled",
    "value",
    "variants",
    "priority",
    "metadata"
})
@Generated("jsonschema2pojo")
public class FeatureContext {

    /**
     * Key
     * <p>
     * Unique feature key used when selecting a variant if the feature is multivariate. Set to an internal identifier or a UUID, depending on Flagsmith implementation.
     * (Required)
     * 
     */
    @JsonProperty("key")
    @JsonPropertyDescription("Unique feature key used when selecting a variant if the feature is multivariate. Set to an internal identifier or a UUID, depending on Flagsmith implementation.")
    private java.lang.String key;
    /**
     * Name
     * <p>
     * Feature name.
     * (Required)
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("Feature name.")
    private java.lang.String name;
    /**
     * Enabled
     * <p>
     * Indicates whether the feature is enabled in the environment.
     * (Required)
     * 
     */
    @JsonProperty("enabled")
    @JsonPropertyDescription("Indicates whether the feature is enabled in the environment.")
    private Boolean enabled;
    /**
     * Value
     * <p>
     * A default environment value for the feature. If the feature is multivariate, this will be the control value.
     * (Required)
     * 
     */
    @JsonProperty("value")
    @JsonPropertyDescription("A default environment value for the feature. If the feature is multivariate, this will be the control value.")
    private java.lang.Object value;
    /**
     * Variants
     * <p>
     * An array of environment default values associated with the feature. Empty for standard features, or contains multiple values for multivariate features.
     * 
     */
    @JsonProperty("variants")
    @JsonPropertyDescription("An array of environment default values associated with the feature. Empty for standard features, or contains multiple values for multivariate features.")
    private List<FeatureValue> variants = new ArrayList<FeatureValue>();
    /**
     * FeaturePriority
     * <p>
     * Priority of the feature context. Lower values indicate a higher priority when multiple contexts apply to the same feature.
     * 
     */
    @JsonProperty("priority")
    @JsonPropertyDescription("Priority of the feature context. Lower values indicate a higher priority when multiple contexts apply to the same feature.")
    private Double priority;
    /**
     * FeatureMetadata
     * <p>
     * Additional metadata associated with the feature.
     * 
     */
    @JsonProperty("metadata")
    @JsonPropertyDescription("Additional metadata associated with the feature.")
    private Map<String, Object> metadata;
    @JsonIgnore
    private Map<java.lang.String, java.lang.Object> additionalProperties = new LinkedHashMap<java.lang.String, java.lang.Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public FeatureContext() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public FeatureContext(FeatureContext source) {
        super();
        this.key = source.key;
        this.name = source.name;
        this.enabled = source.enabled;
        this.value = source.value;
        this.variants = source.variants;
        this.priority = source.priority;
        this.metadata = source.metadata;
    }

    /**
     * 
     * @param metadata
     *     FeatureMetadata. Additional metadata associated with the feature.
     * @param name
     *     Name. Feature name.
     * @param variants
     *     Variants. An array of environment default values associated with the feature. Empty for standard features, or contains multiple values for multivariate features.
     * @param priority
     *     FeaturePriority. Priority of the feature context. Lower values indicate a higher priority when multiple contexts apply to the same feature.
     * @param value
     *     Value. A default environment value for the feature. If the feature is multivariate, this will be the control value.
     * @param key
     *     Key. Unique feature key used when selecting a variant if the feature is multivariate. Set to an internal identifier or a UUID, depending on Flagsmith implementation.
     * @param enabled
     *     Enabled. Indicates whether the feature is enabled in the environment.
     */
    public FeatureContext(java.lang.String key, java.lang.String name, Boolean enabled, java.lang.Object value, List<FeatureValue> variants, Double priority, Map<String, Object> metadata) {
        super();
        this.key = key;
        this.name = name;
        this.enabled = enabled;
        this.value = value;
        this.variants = variants;
        this.priority = priority;
        this.metadata = metadata;
    }

    /**
     * Key
     * <p>
     * Unique feature key used when selecting a variant if the feature is multivariate. Set to an internal identifier or a UUID, depending on Flagsmith implementation.
     * (Required)
     * 
     */
    @JsonProperty("key")
    public java.lang.String getKey() {
        return key;
    }

    /**
     * Key
     * <p>
     * Unique feature key used when selecting a variant if the feature is multivariate. Set to an internal identifier or a UUID, depending on Flagsmith implementation.
     * (Required)
     * 
     */
    @JsonProperty("key")
    public void setKey(java.lang.String key) {
        this.key = key;
    }

    public FeatureContext withKey(java.lang.String key) {
        this.key = key;
        return this;
    }

    /**
     * Name
     * <p>
     * Feature name.
     * (Required)
     * 
     */
    @JsonProperty("name")
    public java.lang.String getName() {
        return name;
    }

    /**
     * Name
     * <p>
     * Feature name.
     * (Required)
     * 
     */
    @JsonProperty("name")
    public void setName(java.lang.String name) {
        this.name = name;
    }

    public FeatureContext withName(java.lang.String name) {
        this.name = name;
        return this;
    }

    /**
     * Enabled
     * <p>
     * Indicates whether the feature is enabled in the environment.
     * (Required)
     * 
     */
    @JsonProperty("enabled")
    public Boolean getEnabled() {
        return enabled;
    }

    /**
     * Enabled
     * <p>
     * Indicates whether the feature is enabled in the environment.
     * (Required)
     * 
     */
    @JsonProperty("enabled")
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public FeatureContext withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Value
     * <p>
     * A default environment value for the feature. If the feature is multivariate, this will be the control value.
     * (Required)
     * 
     */
    @JsonProperty("value")
    public java.lang.Object getValue() {
        return value;
    }

    /**
     * Value
     * <p>
     * A default environment value for the feature. If the feature is multivariate, this will be the control value.
     * (Required)
     * 
     */
    @JsonProperty("value")
    public void setValue(java.lang.Object value) {
        this.value = value;
    }

    public FeatureContext withValue(java.lang.Object value) {
        this.value = value;
        return this;
    }

    /**
     * Variants
     * <p>
     * An array of environment default values associated with the feature. Empty for standard features, or contains multiple values for multivariate features.
     * 
     */
    @JsonProperty("variants")
    public List<FeatureValue> getVariants() {
        return variants;
    }

    /**
     * Variants
     * <p>
     * An array of environment default values associated with the feature. Empty for standard features, or contains multiple values for multivariate features.
     * 
     */
    @JsonProperty("variants")
    public void setVariants(List<FeatureValue> variants) {
        this.variants = variants;
    }

    public FeatureContext withVariants(List<FeatureValue> variants) {
        this.variants = variants;
        return this;
    }

    /**
     * FeaturePriority
     * <p>
     * Priority of the feature context. Lower values indicate a higher priority when multiple contexts apply to the same feature.
     * 
     */
    @JsonProperty("priority")
    public Double getPriority() {
        return priority;
    }

    /**
     * FeaturePriority
     * <p>
     * Priority of the feature context. Lower values indicate a higher priority when multiple contexts apply to the same feature.
     * 
     */
    @JsonProperty("priority")
    public void setPriority(Double priority) {
        this.priority = priority;
    }

    public FeatureContext withPriority(Double priority) {
        this.priority = priority;
        return this;
    }

    /**
     * FeatureMetadata
     * <p>
     * Additional metadata associated with the feature.
     * 
     */
    @JsonProperty("metadata")
    public Map<String, Object> getMetadata() {
        return metadata;
    }

    /**
     * FeatureMetadata
     * <p>
     * Additional metadata associated with the feature.
     * 
     */
    @JsonProperty("metadata")
    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public FeatureContext withMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
        return this;
    }

    @JsonAnyGetter
    public Map<java.lang.String, java.lang.Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, java.lang.Object value) {
        this.additionalProperties.put(name, value);
    }

    public FeatureContext withAdditionalProperty(java.lang.String name, java.lang.Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    @Override
    public java.lang.String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(FeatureContext.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("key");
        sb.append('=');
        sb.append(((this.key == null)?"<null>":this.key));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("enabled");
        sb.append('=');
        sb.append(((this.enabled == null)?"<null>":this.enabled));
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(((this.value == null)?"<null>":this.value));
        sb.append(',');
        sb.append("variants");
        sb.append('=');
        sb.append(((this.variants == null)?"<null>":this.variants));
        sb.append(',');
        sb.append("priority");
        sb.append('=');
        sb.append(((this.priority == null)?"<null>":this.priority));
        sb.append(',');
        sb.append("metadata");
        sb.append('=');
        sb.append(((this.metadata == null)?"<null>":this.metadata));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.metadata == null)? 0 :this.metadata.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.variants == null)? 0 :this.variants.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.priority == null)? 0 :this.priority.hashCode()));
        result = ((result* 31)+((this.value == null)? 0 :this.value.hashCode()));
        result = ((result* 31)+((this.key == null)? 0 :this.key.hashCode()));
        result = ((result* 31)+((this.enabled == null)? 0 :this.enabled.hashCode()));
        return result;
    }

    @Override
    public boolean equals(java.lang.Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof FeatureContext) == false) {
            return false;
        }
        FeatureContext rhs = ((FeatureContext) other);
        return (((((((((this.metadata == rhs.metadata)||((this.metadata!= null)&&this.metadata.equals(rhs.metadata)))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.variants == rhs.variants)||((this.variants!= null)&&this.variants.equals(rhs.variants))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.priority == rhs.priority)||((this.priority!= null)&&this.priority.equals(rhs.priority))))&&((this.value == rhs.value)||((this.value!= null)&&this.value.equals(rhs.value))))&&((this.key == rhs.key)||((this.key!= null)&&this.key.equals(rhs.key))))&&((this.enabled == rhs.enabled)||((this.enabled!= null)&&this.enabled.equals(rhs.enabled))));
    }

}
