
package com.flagsmith.flagengine;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.processing.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * FeatureValue
 * <p>
 * Represents a multivariate value for a feature flag.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "value",
    "weight",
    "priority"
})
@Generated("jsonschema2pojo")
public class FeatureValue {

    /**
     * Value
     * <p>
     * The value of the feature.
     * (Required)
     * 
     */
    @JsonProperty("value")
    @JsonPropertyDescription("The value of the feature.")
    private Object value;
    /**
     * Weight
     * <p>
     * The weight of the feature value variant, as a percentage number (i.e. 100.0).
     * (Required)
     * 
     */
    @JsonProperty("weight")
    @JsonPropertyDescription("The weight of the feature value variant, as a percentage number (i.e. 100.0).")
    private Double weight;
    /**
     * VariantPriority
     * <p>
     * Priority of the feature flag variant. Lower values indicate a higher priority when multiple variants apply to the same context key.
     * (Required)
     * 
     */
    @JsonProperty("priority")
    @JsonPropertyDescription("Priority of the feature flag variant. Lower values indicate a higher priority when multiple variants apply to the same context key.")
    private Double priority;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public FeatureValue() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public FeatureValue(FeatureValue source) {
        super();
        this.value = source.value;
        this.weight = source.weight;
        this.priority = source.priority;
    }

    /**
     * 
     * @param weight
     *     Weight. The weight of the feature value variant, as a percentage number (i.e. 100.0).
     * @param priority
     *     VariantPriority. Priority of the feature flag variant. Lower values indicate a higher priority when multiple variants apply to the same context key.
     * @param value
     *     Value. The value of the feature.
     */
    public FeatureValue(Object value, Double weight, Double priority) {
        super();
        this.value = value;
        this.weight = weight;
        this.priority = priority;
    }

    /**
     * Value
     * <p>
     * The value of the feature.
     * (Required)
     * 
     */
    @JsonProperty("value")
    public Object getValue() {
        return value;
    }

    /**
     * Value
     * <p>
     * The value of the feature.
     * (Required)
     * 
     */
    @JsonProperty("value")
    public void setValue(Object value) {
        this.value = value;
    }

    public FeatureValue withValue(Object value) {
        this.value = value;
        return this;
    }

    /**
     * Weight
     * <p>
     * The weight of the feature value variant, as a percentage number (i.e. 100.0).
     * (Required)
     * 
     */
    @JsonProperty("weight")
    public Double getWeight() {
        return weight;
    }

    /**
     * Weight
     * <p>
     * The weight of the feature value variant, as a percentage number (i.e. 100.0).
     * (Required)
     * 
     */
    @JsonProperty("weight")
    public void setWeight(Double weight) {
        this.weight = weight;
    }

    public FeatureValue withWeight(Double weight) {
        this.weight = weight;
        return this;
    }

    /**
     * VariantPriority
     * <p>
     * Priority of the feature flag variant. Lower values indicate a higher priority when multiple variants apply to the same context key.
     * (Required)
     * 
     */
    @JsonProperty("priority")
    public Double getPriority() {
        return priority;
    }

    /**
     * VariantPriority
     * <p>
     * Priority of the feature flag variant. Lower values indicate a higher priority when multiple variants apply to the same context key.
     * (Required)
     * 
     */
    @JsonProperty("priority")
    public void setPriority(Double priority) {
        this.priority = priority;
    }

    public FeatureValue withPriority(Double priority) {
        this.priority = priority;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public FeatureValue withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(FeatureValue.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("value");
        sb.append('=');
        sb.append(((this.value == null)?"<null>":this.value));
        sb.append(',');
        sb.append("weight");
        sb.append('=');
        sb.append(((this.weight == null)?"<null>":this.weight));
        sb.append(',');
        sb.append("priority");
        sb.append('=');
        sb.append(((this.priority == null)?"<null>":this.priority));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.weight == null)? 0 :this.weight.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.priority == null)? 0 :this.priority.hashCode()));
        result = ((result* 31)+((this.value == null)? 0 :this.value.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof FeatureValue) == false) {
            return false;
        }
        FeatureValue rhs = ((FeatureValue) other);
        return (((((this.weight == rhs.weight)||((this.weight!= null)&&this.weight.equals(rhs.weight)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.priority == rhs.priority)||((this.priority!= null)&&this.priority.equals(rhs.priority))))&&((this.value == rhs.value)||((this.value!= null)&&this.value.equals(rhs.value))));
    }

}
