
package com.flagsmith.flagengine;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.processing.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * FlagResult
 * <p>
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "name",
    "enabled",
    "value",
    "reason",
    "metadata"
})
@Generated("jsonschema2pojo")
public class FlagResult {

    /**
     * Name
     * <p>
     * Feature name.
     * (Required)
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("Feature name.")
    private java.lang.String name;
    /**
     * Enabled
     * <p>
     * Indicates if the feature flag is enabled.
     * (Required)
     * 
     */
    @JsonProperty("enabled")
    @JsonPropertyDescription("Indicates if the feature flag is enabled.")
    private Boolean enabled;
    /**
     * Value
     * <p>
     * Feature flag value.
     * (Required)
     * 
     */
    @JsonProperty("value")
    @JsonPropertyDescription("Feature flag value.")
    private java.lang.Object value;
    /**
     * Reason
     * <p>
     * Reason for the feature flag evaluation.
     * (Required)
     * 
     */
    @JsonProperty("reason")
    @JsonPropertyDescription("Reason for the feature flag evaluation.")
    private java.lang.String reason;
    /**
     * FeatureMetadata
     * <p>
     * Additional metadata associated with the feature.
     * 
     */
    @JsonProperty("metadata")
    @JsonPropertyDescription("Additional metadata associated with the feature.")
    private Map<String, Object> metadata;
    @JsonIgnore
    private Map<java.lang.String, java.lang.Object> additionalProperties = new LinkedHashMap<java.lang.String, java.lang.Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public FlagResult() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public FlagResult(FlagResult source) {
        super();
        this.name = source.name;
        this.enabled = source.enabled;
        this.value = source.value;
        this.reason = source.reason;
        this.metadata = source.metadata;
    }

    /**
     * 
     * @param reason
     *     Reason. Reason for the feature flag evaluation.
     * @param metadata
     *     FeatureMetadata. Additional metadata associated with the feature.
     * @param name
     *     Name. Feature name.
     * @param value
     *     Value. Feature flag value.
     * @param enabled
     *     Enabled. Indicates if the feature flag is enabled.
     */
    public FlagResult(java.lang.String name, Boolean enabled, java.lang.Object value, java.lang.String reason, Map<String, Object> metadata) {
        super();
        this.name = name;
        this.enabled = enabled;
        this.value = value;
        this.reason = reason;
        this.metadata = metadata;
    }

    /**
     * Name
     * <p>
     * Feature name.
     * (Required)
     * 
     */
    @JsonProperty("name")
    public java.lang.String getName() {
        return name;
    }

    /**
     * Name
     * <p>
     * Feature name.
     * (Required)
     * 
     */
    @JsonProperty("name")
    public void setName(java.lang.String name) {
        this.name = name;
    }

    public FlagResult withName(java.lang.String name) {
        this.name = name;
        return this;
    }

    /**
     * Enabled
     * <p>
     * Indicates if the feature flag is enabled.
     * (Required)
     * 
     */
    @JsonProperty("enabled")
    public Boolean getEnabled() {
        return enabled;
    }

    /**
     * Enabled
     * <p>
     * Indicates if the feature flag is enabled.
     * (Required)
     * 
     */
    @JsonProperty("enabled")
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public FlagResult withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Value
     * <p>
     * Feature flag value.
     * (Required)
     * 
     */
    @JsonProperty("value")
    public java.lang.Object getValue() {
        return value;
    }

    /**
     * Value
     * <p>
     * Feature flag value.
     * (Required)
     * 
     */
    @JsonProperty("value")
    public void setValue(java.lang.Object value) {
        this.value = value;
    }

    public FlagResult withValue(java.lang.Object value) {
        this.value = value;
        return this;
    }

    /**
     * Reason
     * <p>
     * Reason for the feature flag evaluation.
     * (Required)
     * 
     */
    @JsonProperty("reason")
    public java.lang.String getReason() {
        return reason;
    }

    /**
     * Reason
     * <p>
     * Reason for the feature flag evaluation.
     * (Required)
     * 
     */
    @JsonProperty("reason")
    public void setReason(java.lang.String reason) {
        this.reason = reason;
    }

    public FlagResult withReason(java.lang.String reason) {
        this.reason = reason;
        return this;
    }

    /**
     * FeatureMetadata
     * <p>
     * Additional metadata associated with the feature.
     * 
     */
    @JsonProperty("metadata")
    public Map<String, Object> getMetadata() {
        return metadata;
    }

    /**
     * FeatureMetadata
     * <p>
     * Additional metadata associated with the feature.
     * 
     */
    @JsonProperty("metadata")
    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public FlagResult withMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
        return this;
    }

    @JsonAnyGetter
    public Map<java.lang.String, java.lang.Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, java.lang.Object value) {
        this.additionalProperties.put(name, value);
    }

    public FlagResult withAdditionalProperty(java.lang.String name, java.lang.Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    @Override
    public java.lang.String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(FlagResult.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("enabled");
        sb.append('=');
        sb.append(((this.enabled == null)?"<null>":this.enabled));
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(((this.value == null)?"<null>":this.value));
        sb.append(',');
        sb.append("reason");
        sb.append('=');
        sb.append(((this.reason == null)?"<null>":this.reason));
        sb.append(',');
        sb.append("metadata");
        sb.append('=');
        sb.append(((this.metadata == null)?"<null>":this.metadata));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.reason == null)? 0 :this.reason.hashCode()));
        result = ((result* 31)+((this.metadata == null)? 0 :this.metadata.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.value == null)? 0 :this.value.hashCode()));
        result = ((result* 31)+((this.enabled == null)? 0 :this.enabled.hashCode()));
        return result;
    }

    @Override
    public boolean equals(java.lang.Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof FlagResult) == false) {
            return false;
        }
        FlagResult rhs = ((FlagResult) other);
        return (((((((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name)))&&((this.reason == rhs.reason)||((this.reason!= null)&&this.reason.equals(rhs.reason))))&&((this.metadata == rhs.metadata)||((this.metadata!= null)&&this.metadata.equals(rhs.metadata))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.value == rhs.value)||((this.value!= null)&&this.value.equals(rhs.value))))&&((this.enabled == rhs.enabled)||((this.enabled!= null)&&this.enabled.equals(rhs.enabled))));
    }

}
