
package com.flagsmith.flagengine;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * SegmentContext
 * <p>
 * Represents a segment context for feature flag evaluation.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "key",
    "name",
    "rules",
    "overrides",
    "metadata"
})
@Generated("jsonschema2pojo")
public class SegmentContext {

    /**
     * Key
     * <p>
     * Unique segment key used for % split segmentation.
     * (Required)
     * 
     */
    @JsonProperty("key")
    @JsonPropertyDescription("Unique segment key used for % split segmentation.")
    private java.lang.String key;
    /**
     * Name
     * <p>
     * The name of the segment.
     * (Required)
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("The name of the segment.")
    private java.lang.String name;
    /**
     * Rules
     * <p>
     * Rules that define the segment.
     * (Required)
     * 
     */
    @JsonProperty("rules")
    @JsonPropertyDescription("Rules that define the segment.")
    private List<SegmentRule> rules = new ArrayList<SegmentRule>();
    /**
     * Overrides
     * <p>
     * Feature overrides for the segment.
     * 
     */
    @JsonProperty("overrides")
    @JsonPropertyDescription("Feature overrides for the segment.")
    private List<FeatureContext> overrides = new ArrayList<FeatureContext>();
    /**
     * SegmentMetadata
     * <p>
     * Additional metadata associated with the segment.
     * 
     */
    @JsonProperty("metadata")
    @JsonPropertyDescription("Additional metadata associated with the segment.")
    private Map<String, Object> metadata;
    @JsonIgnore
    private Map<java.lang.String, java.lang.Object> additionalProperties = new LinkedHashMap<java.lang.String, java.lang.Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public SegmentContext() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public SegmentContext(SegmentContext source) {
        super();
        this.key = source.key;
        this.name = source.name;
        this.rules = source.rules;
        this.overrides = source.overrides;
        this.metadata = source.metadata;
    }

    /**
     * 
     * @param metadata
     *     SegmentMetadata. Additional metadata associated with the segment.
     * @param name
     *     Name. The name of the segment.
     * @param rules
     *     Rules. Rules that define the segment.
     * @param overrides
     *     Overrides. Feature overrides for the segment.
     * @param key
     *     Key. Unique segment key used for % split segmentation.
     */
    public SegmentContext(java.lang.String key, java.lang.String name, List<SegmentRule> rules, List<FeatureContext> overrides, Map<String, Object> metadata) {
        super();
        this.key = key;
        this.name = name;
        this.rules = rules;
        this.overrides = overrides;
        this.metadata = metadata;
    }

    /**
     * Key
     * <p>
     * Unique segment key used for % split segmentation.
     * (Required)
     * 
     */
    @JsonProperty("key")
    public java.lang.String getKey() {
        return key;
    }

    /**
     * Key
     * <p>
     * Unique segment key used for % split segmentation.
     * (Required)
     * 
     */
    @JsonProperty("key")
    public void setKey(java.lang.String key) {
        this.key = key;
    }

    public SegmentContext withKey(java.lang.String key) {
        this.key = key;
        return this;
    }

    /**
     * Name
     * <p>
     * The name of the segment.
     * (Required)
     * 
     */
    @JsonProperty("name")
    public java.lang.String getName() {
        return name;
    }

    /**
     * Name
     * <p>
     * The name of the segment.
     * (Required)
     * 
     */
    @JsonProperty("name")
    public void setName(java.lang.String name) {
        this.name = name;
    }

    public SegmentContext withName(java.lang.String name) {
        this.name = name;
        return this;
    }

    /**
     * Rules
     * <p>
     * Rules that define the segment.
     * (Required)
     * 
     */
    @JsonProperty("rules")
    public List<SegmentRule> getRules() {
        return rules;
    }

    /**
     * Rules
     * <p>
     * Rules that define the segment.
     * (Required)
     * 
     */
    @JsonProperty("rules")
    public void setRules(List<SegmentRule> rules) {
        this.rules = rules;
    }

    public SegmentContext withRules(List<SegmentRule> rules) {
        this.rules = rules;
        return this;
    }

    /**
     * Overrides
     * <p>
     * Feature overrides for the segment.
     * 
     */
    @JsonProperty("overrides")
    public List<FeatureContext> getOverrides() {
        return overrides;
    }

    /**
     * Overrides
     * <p>
     * Feature overrides for the segment.
     * 
     */
    @JsonProperty("overrides")
    public void setOverrides(List<FeatureContext> overrides) {
        this.overrides = overrides;
    }

    public SegmentContext withOverrides(List<FeatureContext> overrides) {
        this.overrides = overrides;
        return this;
    }

    /**
     * SegmentMetadata
     * <p>
     * Additional metadata associated with the segment.
     * 
     */
    @JsonProperty("metadata")
    public Map<String, Object> getMetadata() {
        return metadata;
    }

    /**
     * SegmentMetadata
     * <p>
     * Additional metadata associated with the segment.
     * 
     */
    @JsonProperty("metadata")
    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public SegmentContext withMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
        return this;
    }

    @JsonAnyGetter
    public Map<java.lang.String, java.lang.Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, java.lang.Object value) {
        this.additionalProperties.put(name, value);
    }

    public SegmentContext withAdditionalProperty(java.lang.String name, java.lang.Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    @Override
    public java.lang.String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SegmentContext.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("key");
        sb.append('=');
        sb.append(((this.key == null)?"<null>":this.key));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("rules");
        sb.append('=');
        sb.append(((this.rules == null)?"<null>":this.rules));
        sb.append(',');
        sb.append("overrides");
        sb.append('=');
        sb.append(((this.overrides == null)?"<null>":this.overrides));
        sb.append(',');
        sb.append("metadata");
        sb.append('=');
        sb.append(((this.metadata == null)?"<null>":this.metadata));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.rules == null)? 0 :this.rules.hashCode()));
        result = ((result* 31)+((this.metadata == null)? 0 :this.metadata.hashCode()));
        result = ((result* 31)+((this.overrides == null)? 0 :this.overrides.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.key == null)? 0 :this.key.hashCode()));
        return result;
    }

    @Override
    public boolean equals(java.lang.Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof SegmentContext) == false) {
            return false;
        }
        SegmentContext rhs = ((SegmentContext) other);
        return (((((((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name)))&&((this.rules == rhs.rules)||((this.rules!= null)&&this.rules.equals(rhs.rules))))&&((this.metadata == rhs.metadata)||((this.metadata!= null)&&this.metadata.equals(rhs.metadata))))&&((this.overrides == rhs.overrides)||((this.overrides!= null)&&this.overrides.equals(rhs.overrides))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.key == rhs.key)||((this.key!= null)&&this.key.equals(rhs.key))));
    }

}
