
package com.flagsmith.flagengine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;


/**
 * SegmentRule
 * <p>
 * Represents a rule within a segment for feature flag evaluation.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "type",
    "conditions",
    "rules"
})
@Generated("jsonschema2pojo")
public class SegmentRule {

    /**
     * Type
     * <p>
     * Segment rule type. Represents a logical quantifier for the conditions and sub-rules.
     * (Required)
     * 
     */
    @JsonProperty("type")
    @JsonPropertyDescription("Segment rule type. Represents a logical quantifier for the conditions and sub-rules.")
    private SegmentRule.Type type;
    /**
     * Conditions
     * <p>
     * Conditions that must be met for the rule to apply.
     * 
     */
    @JsonProperty("conditions")
    @JsonPropertyDescription("Conditions that must be met for the rule to apply.")
    private List<SegmentCondition> conditions = new ArrayList<SegmentCondition>();
    /**
     * Sub-rules
     * <p>
     * Sub-rules nested within the segment rule.
     * 
     */
    @JsonProperty("rules")
    @JsonPropertyDescription("Sub-rules nested within the segment rule.")
    private List<SegmentRule> rules = new ArrayList<SegmentRule>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public SegmentRule() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public SegmentRule(SegmentRule source) {
        super();
        this.type = source.type;
        this.conditions = source.conditions;
        this.rules = source.rules;
    }

    /**
     * 
     * @param rules
     *     Sub-rules. Sub-rules nested within the segment rule.
     * @param type
     *     Type. Segment rule type. Represents a logical quantifier for the conditions and sub-rules.
     * @param conditions
     *     Conditions. Conditions that must be met for the rule to apply.
     */
    public SegmentRule(SegmentRule.Type type, List<SegmentCondition> conditions, List<SegmentRule> rules) {
        super();
        this.type = type;
        this.conditions = conditions;
        this.rules = rules;
    }

    /**
     * Type
     * <p>
     * Segment rule type. Represents a logical quantifier for the conditions and sub-rules.
     * (Required)
     * 
     */
    @JsonProperty("type")
    public SegmentRule.Type getType() {
        return type;
    }

    /**
     * Type
     * <p>
     * Segment rule type. Represents a logical quantifier for the conditions and sub-rules.
     * (Required)
     * 
     */
    @JsonProperty("type")
    public void setType(SegmentRule.Type type) {
        this.type = type;
    }

    public SegmentRule withType(SegmentRule.Type type) {
        this.type = type;
        return this;
    }

    /**
     * Conditions
     * <p>
     * Conditions that must be met for the rule to apply.
     * 
     */
    @JsonProperty("conditions")
    public List<SegmentCondition> getConditions() {
        return conditions;
    }

    /**
     * Conditions
     * <p>
     * Conditions that must be met for the rule to apply.
     * 
     */
    @JsonProperty("conditions")
    public void setConditions(List<SegmentCondition> conditions) {
        this.conditions = conditions;
    }

    public SegmentRule withConditions(List<SegmentCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    /**
     * Sub-rules
     * <p>
     * Sub-rules nested within the segment rule.
     * 
     */
    @JsonProperty("rules")
    public List<SegmentRule> getRules() {
        return rules;
    }

    /**
     * Sub-rules
     * <p>
     * Sub-rules nested within the segment rule.
     * 
     */
    @JsonProperty("rules")
    public void setRules(List<SegmentRule> rules) {
        this.rules = rules;
    }

    public SegmentRule withRules(List<SegmentRule> rules) {
        this.rules = rules;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public SegmentRule withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SegmentRule.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(((this.type == null)?"<null>":this.type));
        sb.append(',');
        sb.append("conditions");
        sb.append('=');
        sb.append(((this.conditions == null)?"<null>":this.conditions));
        sb.append(',');
        sb.append("rules");
        sb.append('=');
        sb.append(((this.rules == null)?"<null>":this.rules));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.rules == null)? 0 :this.rules.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.type == null)? 0 :this.type.hashCode()));
        result = ((result* 31)+((this.conditions == null)? 0 :this.conditions.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof SegmentRule) == false) {
            return false;
        }
        SegmentRule rhs = ((SegmentRule) other);
        return (((((this.rules == rhs.rules)||((this.rules!= null)&&this.rules.equals(rhs.rules)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.type == rhs.type)||((this.type!= null)&&this.type.equals(rhs.type))))&&((this.conditions == rhs.conditions)||((this.conditions!= null)&&this.conditions.equals(rhs.conditions))));
    }


    /**
     * Type
     * <p>
     * Segment rule type. Represents a logical quantifier for the conditions and sub-rules.
     * 
     */
    @Generated("jsonschema2pojo")
    public enum Type {

        ALL("ALL"),
        ANY("ANY"),
        NONE("NONE");
        private final String value;
        private final static Map<String, SegmentRule.Type> CONSTANTS = new HashMap<String, SegmentRule.Type>();

        static {
            for (SegmentRule.Type c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Type(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static SegmentRule.Type fromValue(String value) {
            SegmentRule.Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
