package com.flagsmith.models.environments;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.flagsmith.models.features.FeatureStateModel;
import com.flagsmith.models.identities.IdentityModel;
import com.flagsmith.models.projects.ProjectModel;
import com.flagsmith.utils.models.BaseModel;
import java.util.List;
import lombok.Data;

@Data
public class EnvironmentModel extends BaseModel {
  private Integer id;

  @JsonProperty("api_key")
  private String apiKey;

  @JsonProperty("name")
  private String name;

  private ProjectModel project;

  @JsonProperty("feature_states")
  private List<FeatureStateModel> featureStates;

  @JsonProperty("identity_overrides")
  private List<IdentityModel> identityOverrides;
}