/*
 * Decompiled with CFR 0.152.
 */
package com.flutterwave.rave.java.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.log4j.Logger;

public class transferServices {
    private static final Logger LOG = Logger.getLogger(transferServices.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String dotransfer(String params) {
        StringBuilder result = new StringBuilder();
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            String line;
            HttpPost post = new HttpPost("https://ravesandboxapi.flutterwave.com/v2/gpx/transfers/create");
            StringEntity input = new StringEntity(params);
            input.setContentType("application/json");
            post.setEntity((HttpEntity)input);
            CloseableHttpResponse response = client.execute((HttpUriRequest)post);
            LOG.info((Object)("dotransfer response code ::: " + response.getStatusLine().getStatusCode()));
            BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
            LOG.info((Object)("dotransfer request" + result.toString()));
            if (!String.valueOf(response.getStatusLine().getStatusCode()).startsWith("2") && !response.getEntity().getContentType().getValue().contains("json")) {
                String string = null;
                return string;
            }
            if (response.getStatusLine().getStatusCode() == 500) {
                String string = "there is an error with the data";
                return string;
            }
            String string = result.toString();
            return string;
        }
        catch (UnsupportedEncodingException ex) {
            LOG.error((Object)Arrays.toString(ex.getStackTrace()));
            return null;
        }
        catch (IOException ex) {
            LOG.error((Object)Arrays.toString(ex.getStackTrace()));
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String dobulktransfer(String params) {
        StringBuilder result = new StringBuilder();
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            String line;
            HttpPost post = new HttpPost("https://ravesandboxapi.flutterwave.com/v2/gpx/transfers/create_bulk");
            StringEntity input = new StringEntity(params);
            input.setContentType("application/json");
            post.setEntity((HttpEntity)input);
            CloseableHttpResponse response = client.execute((HttpUriRequest)post);
            LOG.info((Object)("dobulktransfer response code ::: " + response.getStatusLine().getStatusCode()));
            BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
            LOG.info((Object)("dobulktransfer request" + result.toString()));
            if (!String.valueOf(response.getStatusLine().getStatusCode()).startsWith("2") && !response.getEntity().getContentType().getValue().contains("json")) {
                String string = null;
                return string;
            }
            if (response.getStatusLine().getStatusCode() == 500) {
                String string = "there is an error with the data";
                return string;
            }
            String string = result.toString();
            return string;
        }
        catch (UnsupportedEncodingException ex) {
            LOG.error((Object)Arrays.toString(ex.getStackTrace()));
            return null;
        }
        catch (IOException ex) {
            LOG.error((Object)Arrays.toString(ex.getStackTrace()));
        }
        return null;
    }
}

