package com.flutterwave.services.misc;

import com.flutterwave.bean.Response;
import com.flutterwave.client.Client;

import java.util.Optional;

import static com.flutterwave.bean.ChargeTypes.RESOLVE_BVN;
import static com.flutterwave.bean.Verb.GET;
import static com.flutterwave.utility.Properties.getProperty;

/**
 * Bank Verification Number or BVN is a biometric identification widely used by Banks in Nigeria.
 * This endpoint allows you to fetch a user's information from their BVN.
 * It supports only BVNs generated by Nigerian Banks.
 * @author cleopatradouglas
 */
public class ResolveBVN {

    private String ERROR = "Error processing request, please check logs";

    /**
     * Handles resolve requests
     * @param bvn String This is a valid BVN you want to resolve.
     * @return Response
     */
    public Response runTransaction(String bvn){
        return Optional.ofNullable(Client.runTransaction(
                        getProperty("BVN_RESOLVE_ENDPOINT")+bvn,
                        null,
                        GET,
                        RESOLVE_BVN,
                        null))
                .map(Response::toResponse).orElseThrow(() -> new RuntimeException(ERROR));
    }
}
