/*
 * Decompiled with CFR 0.152.
 */
package com.flutterwave.services;

import com.flutterwave.bean.ChargeTypes;
import com.flutterwave.bean.CollectionsSubAccountRequest;
import com.flutterwave.bean.ListResponse;
import com.flutterwave.bean.PayoutSubAccountRequest;
import com.flutterwave.bean.Response;
import com.flutterwave.bean.SubAccountTypes;
import com.flutterwave.bean.UpdateCollectionSubAccountRequest;
import com.flutterwave.bean.UpdatePayoutSubAccountRequest;
import com.flutterwave.client.Utility;
import com.flutterwave.utility.Properties;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class SubAccounts {
    private String ERROR = "Error processing request, please check logs";

    public Response runCreateSubAccounts(CollectionsSubAccountRequest collectionsSubAccountRequest, Optional<PayoutSubAccountRequest> payoutSubAccountRequest, SubAccountTypes type) {
        return type.equals((Object)SubAccountTypes.COLLECTION) ? Optional.of(Utility.post(Properties.getProperty("COLLECTIONS_SUBACCOUNT_BASE"), collectionsSubAccountRequest.toString(), ChargeTypes.SUBACCOUNT, null)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR)) : Optional.of(Utility.post(Properties.getProperty("PAYOUT_SUBACCOUNT_BASE"), payoutSubAccountRequest.toString(), ChargeTypes.SUBACCOUNT, null)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public ListResponse runGetSubAccounts(Optional<String> account_bank, Optional<String> account_number, Optional<String> bank_name, Optional<Integer> page, SubAccountTypes type) {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        account_bank.ifPresent(s -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("account_bank", s)));
        account_number.ifPresent(s -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("account_number", s)));
        bank_name.ifPresent(s -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("bank_name", s)));
        page.ifPresent(s -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("page", s.toString())));
        return type.equals((Object)SubAccountTypes.COLLECTION) ? Optional.of(Utility.get(Properties.getProperty("COLLECTIONS_SUBACCOUNT_BASE"), ChargeTypes.SUBACCOUNT, nameValuePairs)).map(ListResponse::toListResponse).orElseThrow(() -> new RuntimeException(this.ERROR)) : Optional.of(Utility.get(Properties.getProperty("PAYOUT_SUBACCOUNT_BASE"), ChargeTypes.SUBACCOUNT, null)).map(ListResponse::toListResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public Response runGetSubAccount(int id, Optional<String> account_reference, Optional<String> include_limit, SubAccountTypes type) {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        include_limit.ifPresent(s -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("include_limit", s)));
        return type.equals((Object)SubAccountTypes.COLLECTION) ? Optional.of(Utility.get(Properties.getProperty("COLLECTIONS_SUBACCOUNT_BASE") + "/" + id, ChargeTypes.SUBACCOUNT, null)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR)) : Optional.of(Utility.get(Properties.getProperty("PAYOUT_SUBACCOUNT_BASE") + "/" + String.valueOf(account_reference), ChargeTypes.SUBACCOUNT, nameValuePairs)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public Response updateSubAccount(int id, UpdateCollectionSubAccountRequest updateCollectionSubAccountRequest, Optional<UpdatePayoutSubAccountRequest> updatePayoutSubAccountRequest, Optional<String> account_reference, SubAccountTypes type) {
        return type.equals((Object)SubAccountTypes.COLLECTION) ? Optional.of(Utility.put(Properties.getProperty("SUBSCRIPTION_BASE") + "/" + id, updateCollectionSubAccountRequest.toString(), ChargeTypes.SUBACCOUNT, null)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR)) : Optional.of(Utility.put(Properties.getProperty("PAYOUT_SUBACCOUNT_BASE") + "/" + String.valueOf(account_reference), updatePayoutSubAccountRequest.toString(), ChargeTypes.SUBACCOUNT, null)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public Response runDeleteCollectionSubAccounts(int id) {
        return Optional.of(Utility.delete(Properties.getProperty("COLLECTIONS_SUBACCOUNT_BASE") + "/" + id, ChargeTypes.SUBACCOUNT, null)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public Response runGetPayoutSubAccountTransactions(String account_reference, String from, String to, String currency) {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("from", from));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("to", to));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("currency", currency));
        return Optional.of(Utility.get(Properties.getProperty("PAYOUT_SUBACCOUNT_BASE") + "/" + account_reference, ChargeTypes.SUBACCOUNT, nameValuePairs)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public Response runGetPayoutSubAccountBalance(String account_reference, String currency) {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("currency", currency));
        return Optional.of(Utility.get(Properties.getProperty("PAYOUT_SUBACCOUNT_BASE") + "/" + account_reference + "/balances", ChargeTypes.SUBACCOUNT, nameValuePairs)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public Response runGetPayoutSubAccountStaticVirtualAccount(String account_reference, String currency) {
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        nameValuePairs.add(new BasicNameValuePair("currency", currency));
        return Optional.of(Utility.get(Properties.getProperty("PAYOUT_SUBACCOUNT_BASE") + "/" + account_reference + "/static-account", ChargeTypes.SUBACCOUNT, null)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }
}

