/*
 * Decompiled with CFR 0.152.
 */
package com.flutterwave.services;

import com.flutterwave.bean.ChargeTypes;
import com.flutterwave.bean.ListResponse;
import com.flutterwave.bean.Response;
import com.flutterwave.client.Utility;
import com.flutterwave.utility.Properties;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONObject;

public class Transactions {
    private String ERROR = "Error processing request, please check logs";

    public Response runVerifyTransaction(int id) {
        return Optional.of(Utility.get(Properties.getProperty("VERIFY_TRANSACTION_ENDPOINT") + id + "/verify", ChargeTypes.VERIFY_TRANSACTION, null)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public ListResponse runGetTransactions() {
        return Optional.of(Utility.get(Properties.getProperty("VERIFY_TRANSACTION_ENDPOINT"), ChargeTypes.GET_TRANSACTION, null)).map(ListResponse::toListResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public Response runGetTransactionsFees(BigDecimal amount, String currency) {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("amount", amount.toString()));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("currency", currency));
        return Optional.of(Utility.get(Properties.getProperty("VERIFY_TRANSACTION_ENDPOINT") + "/fee", ChargeTypes.GET_TRANSACTION, nameValuePairs)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public Response runResendWebhook(int id, Optional<Integer> wait) {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        wait.ifPresent(s -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("wait", wait.toString())));
        return Optional.of(Utility.post(Properties.getProperty("VERIFY_TRANSACTION_ENDPOINT") + id + "/resend-hook", null, ChargeTypes.GET_TRANSACTION, nameValuePairs)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public ListResponse runViewTimeline(int id) {
        return Optional.of(Utility.get(Properties.getProperty("VERIFY_TRANSACTION_ENDPOINT") + id + "/events", ChargeTypes.GET_TRANSACTION, null)).map(ListResponse::toListResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public class Refunds {
        public ListResponse runGet() {
            return Optional.of(Utility.get(Properties.getProperty("REFUND_ENDPOINT"), ChargeTypes.REFUND, null)).map(ListResponse::toListResponse).orElseThrow(() -> new RuntimeException(Transactions.this.ERROR));
        }

        public Response runRefund(int id, Optional<BigDecimal> amount) {
            return Optional.of(Utility.post(Properties.getProperty("VERIFY_TRANSACTION_ENDPOINT") + id + "/refund", new JSONObject().put("amount", amount).toString(), ChargeTypes.REFUND, null)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(Transactions.this.ERROR));
        }

        public Response runGetDetails(int id) {
            return Optional.of(Utility.get(Properties.getProperty("VERIFY_TRANSACTION_ENDPOINT") + id + "/refund", ChargeTypes.REFUND, null)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(Transactions.this.ERROR));
        }
    }
}

