/*
 * Decompiled with CFR 0.152.
 */
package com.flutterwave.services;

import com.flutterwave.bean.ChargeTypes;
import com.flutterwave.bean.ListResponse;
import com.flutterwave.bean.Response;
import com.flutterwave.bean.Verb;
import com.flutterwave.bean.VirtualAccountRequest;
import com.flutterwave.client.Client;
import com.flutterwave.client.Utility;
import com.flutterwave.utility.Properties;
import java.util.List;
import java.util.Optional;
import org.json.JSONObject;

public class VirtualAccount {
    private String ERROR = "Error processing request, please check logs";

    public Response runTransaction(VirtualAccountRequest virtualAccountRequest) {
        return Optional.of(Utility.post(Properties.getProperty("VIRTUAL_ACCOUNT_BASE"), virtualAccountRequest.toString(), ChargeTypes.VIRTUAL_ACCOUNT, null)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public Response runBulkTransaction(List<VirtualAccountRequest> virtualAccountRequests) {
        return Optional.of(Utility.post(Properties.getProperty("BULK_VIRTUAL_ACCOUNT_ENDPOINT"), virtualAccountRequests.toString(), ChargeTypes.VIRTUAL_ACCOUNT, null)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public ListResponse getBulkVirtualAccounts(String batch_id) {
        return Optional.of(Utility.get(Properties.getProperty("BULK_VIRTUAL_ACCOUNT_ENDPOINT") + "/" + batch_id, ChargeTypes.VIRTUAL_ACCOUNT, null)).map(ListResponse::toListResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public Response getVirtualAccount(String order_ref) {
        return Optional.of(Utility.get(Properties.getProperty("VIRTUAL_ACCOUNT_BASE") + "/" + order_ref, ChargeTypes.VIRTUAL_ACCOUNT, null)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public Response updateBVN(String order_ref, String bvn) {
        return Optional.ofNullable(Client.runTransaction(Properties.getProperty("VIRTUAL_ACCOUNT_BASE") + "/" + order_ref, new JSONObject().put("bvn", (Object)bvn).toString(), Verb.PUT, ChargeTypes.VIRTUAL_ACCOUNT, null)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public Response deleteVirtualAccount(String order_ref) {
        return Optional.of(Utility.post(Properties.getProperty("VIRTUAL_ACCOUNT_BASE") + "/" + order_ref, new JSONObject().put("status", (Object)"inactive").toString(), ChargeTypes.VIRTUAL_ACCOUNT, null)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }
}

