/*
 * Decompiled with CFR 0.152.
 */
package com.foundationdb;

import com.foundationdb.ConflictRangeType;
import com.foundationdb.Database;
import com.foundationdb.DefaultDisposableImpl;
import com.foundationdb.Disposable;
import com.foundationdb.FDBException;
import com.foundationdb.FutureKey;
import com.foundationdb.FutureResult;
import com.foundationdb.FutureResults;
import com.foundationdb.FutureStrings;
import com.foundationdb.FutureVersion;
import com.foundationdb.FutureVoid;
import com.foundationdb.KeySelector;
import com.foundationdb.KeyValue;
import com.foundationdb.MutationType;
import com.foundationdb.OptionConsumer;
import com.foundationdb.Range;
import com.foundationdb.RangeQuery;
import com.foundationdb.ReadTransaction;
import com.foundationdb.StreamingMode;
import com.foundationdb.Transaction;
import com.foundationdb.TransactionOptions;
import com.foundationdb.async.AsyncIterable;
import com.foundationdb.async.AsyncUtil;
import com.foundationdb.async.Function;
import com.foundationdb.async.Future;
import com.foundationdb.async.PartialFunction;
import com.foundationdb.async.PartialFuture;
import com.foundationdb.async.ReadyFuture;
import com.foundationdb.async.ReadyPartialFuture;
import com.foundationdb.tuple.ByteArrayUtil;
import java.util.concurrent.Executor;

class FDBTransaction
extends DefaultDisposableImpl
implements Disposable,
Transaction,
OptionConsumer {
    private final Executor executor;
    private final Database database;
    private final TransactionOptions options;
    public final ReadTransaction snapshot;

    protected FDBTransaction(long l, Database database, Executor executor) {
        super(l);
        this.database = database;
        this.executor = executor;
        this.snapshot = new ReadSnapshot();
        this.options = new TransactionOptions(this);
    }

    @Override
    public ReadTransaction snapshot() {
        return this.snapshot;
    }

    @Override
    public TransactionOptions options() {
        return this.options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReadVersion(long l) {
        this.pointerReadLock.lock();
        try {
            this.Transaction_setVersion(this.getPtr(), l);
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Long> getReadVersion() {
        this.pointerReadLock.lock();
        try {
            FutureVersion futureVersion = new FutureVersion(this.Transaction_getReadVersion(this.getPtr()), this.executor);
            return futureVersion;
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    @Override
    public Future<byte[]> get(byte[] byArray) {
        return this.get_internal(byArray, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<byte[]> get_internal(byte[] byArray, boolean bl) {
        this.pointerReadLock.lock();
        try {
            FutureResult futureResult = new FutureResult(this.Transaction_get(this.getPtr(), byArray, bl), this.executor);
            return futureResult;
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    @Override
    public Future<byte[]> getKey(KeySelector keySelector) {
        return this.getKey_internal(keySelector, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<byte[]> getKey_internal(KeySelector keySelector, boolean bl) {
        this.pointerReadLock.lock();
        try {
            FutureKey futureKey = new FutureKey(this.Transaction_getKey(this.getPtr(), keySelector.getKey(), keySelector.orEqual(), keySelector.getOffset(), bl), this.executor);
            return futureKey;
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    @Override
    public AsyncIterable<KeyValue> getRange(KeySelector keySelector, KeySelector keySelector2, int n, boolean bl, StreamingMode streamingMode) {
        return new RangeQuery(this, false, keySelector, keySelector2, n, bl, streamingMode);
    }

    @Override
    public AsyncIterable<KeyValue> getRange(KeySelector keySelector, KeySelector keySelector2, int n, boolean bl) {
        return this.getRange(keySelector, keySelector2, n, bl, StreamingMode.ITERATOR);
    }

    @Override
    public AsyncIterable<KeyValue> getRange(KeySelector keySelector, KeySelector keySelector2, int n) {
        return this.getRange(keySelector, keySelector2, n, false);
    }

    @Override
    public AsyncIterable<KeyValue> getRange(KeySelector keySelector, KeySelector keySelector2) {
        return this.getRange(keySelector, keySelector2, 0);
    }

    @Override
    public AsyncIterable<KeyValue> getRange(byte[] byArray, byte[] byArray2, int n, boolean bl, StreamingMode streamingMode) {
        return this.getRange(KeySelector.firstGreaterOrEqual(byArray), KeySelector.firstGreaterOrEqual(byArray2), n, bl, streamingMode);
    }

    @Override
    public AsyncIterable<KeyValue> getRange(byte[] byArray, byte[] byArray2, int n, boolean bl) {
        return this.getRange(byArray, byArray2, n, bl, StreamingMode.ITERATOR);
    }

    @Override
    public AsyncIterable<KeyValue> getRange(byte[] byArray, byte[] byArray2, int n) {
        return this.getRange(byArray, byArray2, n, false);
    }

    @Override
    public AsyncIterable<KeyValue> getRange(byte[] byArray, byte[] byArray2) {
        return this.getRange(byArray, byArray2, 0);
    }

    @Override
    public AsyncIterable<KeyValue> getRange(Range range, int n, boolean bl, StreamingMode streamingMode) {
        return this.getRange(range.begin, range.end, n, bl, streamingMode);
    }

    @Override
    public AsyncIterable<KeyValue> getRange(Range range, int n, boolean bl) {
        return this.getRange(range, n, bl, StreamingMode.ITERATOR);
    }

    @Override
    public AsyncIterable<KeyValue> getRange(Range range, int n) {
        return this.getRange(range, n, false);
    }

    @Override
    public AsyncIterable<KeyValue> getRange(Range range) {
        return this.getRange(range, 0);
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FutureResults getRange_internal(KeySelector keySelector, KeySelector keySelector2, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        this.pointerReadLock.lock();
        try {
            FutureResults futureResults = new FutureResults(this.Transaction_getRange(this.getPtr(), keySelector.getKey(), keySelector.orEqual(), keySelector.getOffset(), keySelector2.getKey(), keySelector2.orEqual(), keySelector2.getOffset(), n, n2, n3, n4, bl, bl2), this.executor);
            return futureResults;
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    @Override
    public void addReadConflictRange(byte[] byArray, byte[] byArray2) {
        this.addConflictRange(byArray, byArray2, ConflictRangeType.READ);
    }

    @Override
    public void addReadConflictKey(byte[] byArray) {
        this.addConflictRange(byArray, ByteArrayUtil.join(byArray, {0}), ConflictRangeType.READ);
    }

    @Override
    public void addWriteConflictRange(byte[] byArray, byte[] byArray2) {
        this.addConflictRange(byArray, byArray2, ConflictRangeType.WRITE);
    }

    @Override
    public void addWriteConflictKey(byte[] byArray) {
        this.addConflictRange(byArray, ByteArrayUtil.join(byArray, {0}), ConflictRangeType.WRITE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConflictRange(byte[] byArray, byte[] byArray2, ConflictRangeType conflictRangeType) {
        this.pointerReadLock.lock();
        try {
            this.Transaction_addConflictRange(this.getPtr(), byArray, byArray2, conflictRangeType.code());
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    @Override
    public <T> T run(Function<? super Transaction, T> function) {
        return function.apply(this);
    }

    @Override
    public <T> T run(PartialFunction<? super Transaction, T> partialFunction) throws Exception {
        return partialFunction.apply(this);
    }

    @Override
    public <T> Future<T> runAsync(Function<? super Transaction, Future<T>> function) {
        return AsyncUtil.applySafely(function, this);
    }

    @Override
    public <T> PartialFuture<T> runAsync(PartialFunction<? super Transaction, ? extends PartialFuture<T>> partialFunction) {
        return AsyncUtil.applySafely(partialFunction, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray2 == null) {
            throw new IllegalArgumentException("Keys/Values must be non-null");
        }
        this.pointerReadLock.lock();
        try {
            this.Transaction_set(this.getPtr(), byArray, byArray2);
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        this.pointerReadLock.lock();
        try {
            this.Transaction_clear(this.getPtr(), byArray);
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray2 == null) {
            throw new IllegalArgumentException("Keys cannot be null");
        }
        this.pointerReadLock.lock();
        try {
            this.Transaction_clear(this.getPtr(), byArray, byArray2);
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    @Override
    @Deprecated
    public void clearRangeStartsWith(byte[] byArray) {
        this.clear(Range.startsWith(byArray));
    }

    @Override
    public void clear(Range range) {
        this.clear(range.begin, range.end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mutate(MutationType mutationType, byte[] byArray, byte[] byArray2) {
        this.pointerReadLock.lock();
        try {
            this.Transaction_mutate(this.getPtr(), mutationType.code(), byArray, byArray2);
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOption(int n, byte[] byArray) {
        this.pointerReadLock.lock();
        try {
            this.Transaction_setOption(this.getPtr(), n, byArray);
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> commit() {
        this.pointerReadLock.lock();
        try {
            FutureVoid futureVoid = new FutureVoid(this.Transaction_commit(this.getPtr()), this.executor);
            return futureVoid;
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getCommittedVersion() {
        this.pointerReadLock.lock();
        try {
            Long l = this.Transaction_getCommittedVersion(this.getPtr());
            return l;
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> watch(byte[] byArray) throws FDBException {
        this.pointerReadLock.lock();
        try {
            FutureVoid futureVoid = new FutureVoid(this.Transaction_watch(this.getPtr(), byArray), this.executor);
            return futureVoid;
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> onError(RuntimeException runtimeException) {
        if (!(runtimeException instanceof FDBException)) {
            return new ReadyFuture<Void>(runtimeException, this.getExecutor());
        }
        this.pointerReadLock.lock();
        try {
            FutureVoid futureVoid = new FutureVoid(this.Transaction_onError(this.getPtr(), ((FDBException)runtimeException).getCode()), this.executor);
            return futureVoid;
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    @Override
    public PartialFuture<Void> onError(Exception exception) {
        if (!(exception instanceof RuntimeException)) {
            return new ReadyPartialFuture<Void>(exception, this.getExecutor());
        }
        return this.onError((RuntimeException)exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        this.pointerReadLock.lock();
        try {
            this.Transaction_reset(this.getPtr());
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        this.pointerReadLock.lock();
        try {
            this.Transaction_cancel(this.getPtr());
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<String[]> getAddressesForKey(byte[] byArray) {
        this.pointerReadLock.lock();
        try {
            FutureStrings futureStrings = new FutureStrings(this.Transaction_getKeyLocations(this.getPtr(), byArray), this.executor);
            return futureStrings;
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    Executor getExecutor() {
        return this.executor;
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    @Override
    protected void disposeInternal(long l) {
        this.Transaction_dispose(l);
    }

    private native long Transaction_getReadVersion(long var1);

    private native void Transaction_setVersion(long var1, long var3);

    private native long Transaction_get(long var1, byte[] var3, boolean var4);

    private native long Transaction_getKey(long var1, byte[] var3, boolean var4, int var5, boolean var6);

    private native long Transaction_getRange(long var1, byte[] var3, boolean var4, int var5, byte[] var6, boolean var7, int var8, int var9, int var10, int var11, int var12, boolean var13, boolean var14);

    private native void Transaction_addConflictRange(long var1, byte[] var3, byte[] var4, int var5);

    private native void Transaction_set(long var1, byte[] var3, byte[] var4);

    private native void Transaction_clear(long var1, byte[] var3);

    private native void Transaction_clear(long var1, byte[] var3, byte[] var4);

    private native void Transaction_mutate(long var1, int var3, byte[] var4, byte[] var5);

    private native void Transaction_setOption(long var1, int var3, byte[] var4) throws FDBException;

    private native long Transaction_commit(long var1);

    private native long Transaction_getCommittedVersion(long var1);

    private native long Transaction_onError(long var1, int var3);

    private native void Transaction_dispose(long var1);

    private native void Transaction_reset(long var1);

    private native long Transaction_watch(long var1, byte[] var3) throws FDBException;

    private native void Transaction_cancel(long var1);

    private native long Transaction_getKeyLocations(long var1, byte[] var3);

    class ReadSnapshot
    implements ReadTransaction {
        ReadSnapshot() {
        }

        @Override
        public Future<Long> getReadVersion() {
            return FDBTransaction.this.getReadVersion();
        }

        @Override
        public Future<byte[]> get(byte[] byArray) {
            return FDBTransaction.this.get_internal(byArray, true);
        }

        @Override
        public Future<byte[]> getKey(KeySelector keySelector) {
            return FDBTransaction.this.getKey_internal(keySelector, true);
        }

        @Override
        public AsyncIterable<KeyValue> getRange(KeySelector keySelector, KeySelector keySelector2, int n, boolean bl, StreamingMode streamingMode) {
            return new RangeQuery(FDBTransaction.this, true, keySelector, keySelector2, n, bl, streamingMode);
        }

        @Override
        public AsyncIterable<KeyValue> getRange(KeySelector keySelector, KeySelector keySelector2, int n, boolean bl) {
            return this.getRange(keySelector, keySelector2, n, bl, StreamingMode.ITERATOR);
        }

        @Override
        public AsyncIterable<KeyValue> getRange(KeySelector keySelector, KeySelector keySelector2, int n) {
            return this.getRange(keySelector, keySelector2, n, false);
        }

        @Override
        public AsyncIterable<KeyValue> getRange(KeySelector keySelector, KeySelector keySelector2) {
            return this.getRange(keySelector, keySelector2, 0);
        }

        @Override
        public AsyncIterable<KeyValue> getRange(byte[] byArray, byte[] byArray2, int n, boolean bl, StreamingMode streamingMode) {
            return this.getRange(KeySelector.firstGreaterOrEqual(byArray), KeySelector.firstGreaterOrEqual(byArray2), n, bl, streamingMode);
        }

        @Override
        public AsyncIterable<KeyValue> getRange(byte[] byArray, byte[] byArray2, int n, boolean bl) {
            return this.getRange(byArray, byArray2, n, bl, StreamingMode.ITERATOR);
        }

        @Override
        public AsyncIterable<KeyValue> getRange(byte[] byArray, byte[] byArray2, int n) {
            return this.getRange(byArray, byArray2, n, false);
        }

        @Override
        public AsyncIterable<KeyValue> getRange(byte[] byArray, byte[] byArray2) {
            return this.getRange(byArray, byArray2, 0);
        }

        @Override
        public AsyncIterable<KeyValue> getRange(Range range, int n, boolean bl, StreamingMode streamingMode) {
            return this.getRange(range.begin, range.end, n, bl, streamingMode);
        }

        @Override
        public AsyncIterable<KeyValue> getRange(Range range, int n, boolean bl) {
            return this.getRange(range, n, bl, StreamingMode.ITERATOR);
        }

        @Override
        public AsyncIterable<KeyValue> getRange(Range range, int n) {
            return this.getRange(range, n, false);
        }

        @Override
        public AsyncIterable<KeyValue> getRange(Range range) {
            return this.getRange(range, 0);
        }
    }
}

