/*
 * Decompiled with CFR 0.152.
 */
package com.foundationdb;

import com.foundationdb.Database;
import com.foundationdb.FDBException;
import com.foundationdb.FDBTransaction;
import com.foundationdb.KeyValue;
import com.foundationdb.Transaction;
import com.foundationdb.async.AsyncIterable;
import com.foundationdb.async.AsyncIterator;
import com.foundationdb.async.AsyncUtil;
import com.foundationdb.async.Function;
import com.foundationdb.async.Future;
import com.foundationdb.async.ReadyFuture;
import com.foundationdb.tuple.ByteArrayUtil;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;

public class LocalityUtil {
    static Charset ASCII = Charset.forName("US-ASCII");

    public static AsyncIterable<byte[]> getBoundaryKeys(Database database, byte[] byArray, byte[] byArray2) {
        return LocalityUtil.getBoundaryKeys_internal(database.createTransaction(), byArray, byArray2);
    }

    public static AsyncIterable<byte[]> getBoundaryKeys(Transaction transaction, byte[] byArray, byte[] byArray2) {
        Transaction transaction2 = transaction.getDatabase().createTransaction();
        Future<Long> future = transaction.getReadVersion();
        if (future.isDone() && !future.isError()) {
            transaction2.setReadVersion(future.get());
        }
        return new BoundaryIterable(transaction2, byArray, byArray2);
    }

    public static Future<String[]> getAddressesForKey(Transaction transaction, byte[] byArray) {
        if (!(transaction instanceof FDBTransaction)) {
            return new ReadyFuture<String[]>(new FDBException("locality_information_unavailable", 1033));
        }
        return ((FDBTransaction)transaction).getAddressesForKey(byArray);
    }

    private static AsyncIterable<byte[]> getBoundaryKeys_internal(Transaction transaction, byte[] byArray, byte[] byArray2) {
        return new BoundaryIterable(transaction, byArray, byArray2);
    }

    static byte[] keyServersForKey(byte[] byArray) {
        return ByteArrayUtil.join({-1}, "/keyServers/".getBytes(ASCII), byArray);
    }

    private LocalityUtil() {
    }

    static class BoundaryIterable
    implements AsyncIterable<byte[]> {
        final Transaction tr;
        final byte[] begin;
        final byte[] end;
        final AsyncIterable<KeyValue> firstGet;

        public BoundaryIterable(Transaction transaction, byte[] byArray, byte[] byArray2) {
            this.tr = transaction;
            this.begin = Arrays.copyOf(byArray, byArray.length);
            this.end = Arrays.copyOf(byArray2, byArray2.length);
            transaction.options().setAccessSystemKeys();
            this.firstGet = transaction.getRange(LocalityUtil.keyServersForKey(byArray), LocalityUtil.keyServersForKey(byArray2));
        }

        @Override
        public AsyncIterator<byte[]> iterator() {
            return new BoundaryIterator();
        }

        @Override
        public Future<List<byte[]>> asList() {
            return AsyncUtil.collect(this);
        }

        class BoundaryIterator
        implements AsyncIterator<byte[]> {
            AsyncIterator<KeyValue> block;
            Transaction tr;
            byte[] begin;
            byte[] lastBegin;
            private Future<Boolean> nextFuture;
            Function<RuntimeException, Future<Boolean>> handler;

            public BoundaryIterator() {
                this.block = BoundaryIterable.this.firstGet.iterator();
                this.tr = BoundaryIterable.this.tr;
                this.handler = new Function<RuntimeException, Future<Boolean>>(){

                    @Override
                    public Future<Boolean> apply(RuntimeException runtimeException) {
                        Object object;
                        if (runtimeException instanceof FDBException && ((FDBException)(object = (FDBException)runtimeException)).getCode() == 1007 && !Arrays.equals(BoundaryIterator.this.begin, BoundaryIterator.this.lastBegin)) {
                            BoundaryIterator.this.tr = BoundaryIterator.this.tr.getDatabase().createTransaction();
                            return BoundaryIterator.this.restartGet();
                        }
                        object = BoundaryIterator.this.tr.onError(runtimeException);
                        return object.flatMap(new Function<Void, Future<Boolean>>(){

                            @Override
                            public Future<Boolean> apply(Void void_) {
                                return BoundaryIterator.this.restartGet();
                            }
                        });
                    }
                };
                this.nextFuture = this.block.onHasNext().rescueRuntime(this.handler);
            }

            @Override
            public Future<Boolean> onHasNext() {
                return this.nextFuture;
            }

            @Override
            public boolean hasNext() {
                return this.nextFuture.get();
            }

            Future<Boolean> restartGet() {
                if (ByteArrayUtil.compareUnsigned(this.begin, BoundaryIterable.this.end) >= 0) {
                    return new ReadyFuture<Boolean>(Boolean.FALSE);
                }
                this.lastBegin = this.begin;
                this.tr.options().setAccessSystemKeys();
                this.block = this.tr.getRange(LocalityUtil.keyServersForKey(this.begin), LocalityUtil.keyServersForKey(BoundaryIterable.this.end)).iterator();
                this.nextFuture = this.block.onHasNext().rescueRuntime(this.handler);
                return this.nextFuture;
            }

            @Override
            public byte[] next() {
                if (!this.nextFuture.isDone()) {
                    throw new IllegalStateException("Call to next without hasNext()=true");
                }
                KeyValue keyValue = this.block.next();
                byte[] byArray = keyValue.getKey();
                byte[] byArray2 = Arrays.copyOfRange(byArray, 13, byArray.length);
                this.begin = ByteArrayUtil.join(byArray2, {0});
                this.nextFuture = this.block.onHasNext().rescueRuntime(this.handler);
                return byArray2;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Boundary keys are read-only");
            }

            @Override
            public void cancel() {
            }

            @Override
            public void dispose() {
            }
        }
    }
}

