/*
 * Decompiled with CFR 0.152.
 */
package com.foundationdb;

import com.foundationdb.FDBTransaction;
import com.foundationdb.FutureResults;
import com.foundationdb.KeySelector;
import com.foundationdb.KeyValue;
import com.foundationdb.RangeResult;
import com.foundationdb.RangeResultSummary;
import com.foundationdb.StreamingMode;
import com.foundationdb.async.AsyncIterable;
import com.foundationdb.async.AsyncIterator;
import com.foundationdb.async.AsyncUtil;
import com.foundationdb.async.Function;
import com.foundationdb.async.Future;
import com.foundationdb.async.ReadyFuture;
import com.foundationdb.async.Settable;
import com.foundationdb.async.SettableFuture;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;

class RangeQuery
implements AsyncIterable<KeyValue>,
Iterable<KeyValue> {
    private final FDBTransaction tr;
    private final KeySelector begin;
    private final KeySelector end;
    private final boolean snapshot;
    private final int rowLimit;
    private final boolean reverse;
    private final StreamingMode streamingMode;
    private final FutureResults firstChunk;

    RangeQuery(FDBTransaction fDBTransaction, boolean bl, KeySelector keySelector, KeySelector keySelector2, int n, boolean bl2, StreamingMode streamingMode) {
        this.tr = fDBTransaction;
        this.begin = keySelector;
        this.end = keySelector2;
        this.snapshot = bl;
        this.rowLimit = n;
        this.reverse = bl2;
        this.streamingMode = streamingMode;
        this.firstChunk = this.tr.getRange_internal(keySelector, keySelector2, n, 0, streamingMode.code(), 1, this.snapshot, bl2);
    }

    @Override
    public Future<List<KeyValue>> asList() {
        StreamingMode streamingMode = this.streamingMode;
        if (streamingMode == StreamingMode.ITERATOR) {
            StreamingMode streamingMode2 = streamingMode = this.rowLimit == 0 ? StreamingMode.WANT_ALL : StreamingMode.EXACT;
        }
        if (streamingMode == StreamingMode.EXACT) {
            FutureResults futureResults = this.tr.getRange_internal(this.begin, this.end, this.rowLimit, 0, StreamingMode.EXACT.code(), 1, this.snapshot, this.reverse);
            return futureResults.map(new Function<RangeResult, List<KeyValue>>(){

                @Override
                public List<KeyValue> apply(RangeResult rangeResult) {
                    return rangeResult.values;
                }
            });
        }
        return AsyncUtil.collect(new RangeQuery(this.tr, this.snapshot, this.begin, this.end, this.rowLimit, this.reverse, streamingMode));
    }

    public AsyncRangeIterator iterator() {
        return new AsyncRangeIterator(this.rowLimit, this.reverse, this.streamingMode);
    }

    private class AsyncRangeIterator
    implements AsyncIterator<KeyValue> {
        private final boolean rowsLimited;
        private final boolean reverse;
        private final StreamingMode streamingMode;
        private RangeResult chunk = null;
        private RangeResult nextChunk = null;
        private boolean fetchOutstanding = true;
        private byte[] prevKey = null;
        private int index = 0;
        private int iteration = 1;
        private KeySelector begin;
        private KeySelector end;
        private int rowsRemaining;
        private Future<Boolean> nextFuture;
        private boolean isCancelled = false;
        private final Function<Boolean, KeyValue> NEXT_MAPPER = new Function<Boolean, KeyValue>(){

            @Override
            public KeyValue apply(Boolean bl) {
                if (bl.booleanValue()) {
                    return AsyncRangeIterator.this.next();
                }
                throw new NoSuchElementException();
            }
        };

        private AsyncRangeIterator(int n, boolean bl, StreamingMode streamingMode) {
            this.begin = RangeQuery.this.begin;
            this.end = RangeQuery.this.end;
            this.rowsLimited = n != 0;
            this.rowsRemaining = n;
            this.reverse = bl;
            this.streamingMode = streamingMode;
            SettableFuture<Boolean> settableFuture = new SettableFuture<Boolean>(RangeQuery.this.tr.getExecutor());
            this.nextFuture = settableFuture;
            RangeQuery.this.firstChunk.onReady(new FetchComplete(RangeQuery.this.firstChunk, settableFuture));
        }

        private synchronized boolean mainChunkIsTheLast() {
            return !this.chunk.more || this.rowsLimited && this.rowsRemaining < 1;
        }

        private synchronized void startNextFetch() {
            if (this.fetchOutstanding) {
                throw new IllegalStateException("Reentrant call not allowed");
            }
            if (this.isCancelled) {
                return;
            }
            if (this.mainChunkIsTheLast()) {
                return;
            }
            this.fetchOutstanding = true;
            this.nextChunk = null;
            FutureResults futureResults = RangeQuery.this.tr.getRange_internal(this.begin, this.end, this.rowsLimited ? this.rowsRemaining : 0, 0, this.streamingMode.code(), ++this.iteration, RangeQuery.this.snapshot, this.reverse);
            SettableFuture<Boolean> settableFuture = new SettableFuture<Boolean>(RangeQuery.this.tr.getExecutor());
            this.nextFuture = settableFuture;
            settableFuture.onCancelledCancel(futureResults);
            futureResults.onReady(new FetchComplete(futureResults, settableFuture));
        }

        @Override
        public synchronized Future<Boolean> onHasNext() {
            if (this.isCancelled) {
                throw new CancellationException();
            }
            if (this.chunk == null) {
                return this.nextFuture;
            }
            if (this.index < this.chunk.values.size()) {
                return new ReadyFuture<Boolean>(true, RangeQuery.this.tr.getExecutor());
            }
            return this.mainChunkIsTheLast() ? new ReadyFuture<Boolean>(false, RangeQuery.this.tr.getExecutor()) : this.nextFuture;
        }

        @Override
        public boolean hasNext() {
            return this.onHasNext().get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public KeyValue next() {
            Future<Boolean> future;
            AsyncRangeIterator asyncRangeIterator = this;
            synchronized (asyncRangeIterator) {
                if (this.isCancelled) {
                    throw new CancellationException();
                }
                if (this.chunk != null && this.index < this.chunk.values.size()) {
                    boolean bl = this.index == 0;
                    KeyValue keyValue = this.chunk.values.get(this.index);
                    this.prevKey = keyValue.getKey();
                    ++this.index;
                    assert (!bl || this.nextChunk == null);
                    if (this.index == this.chunk.values.size() && this.nextChunk != null) {
                        this.index = 0;
                        this.chunk = this.nextChunk;
                        this.nextChunk = null;
                    }
                    if (bl) {
                        this.startNextFetch();
                    }
                    return keyValue;
                }
                future = this.onHasNext();
            }
            return future.map(this.NEXT_MAPPER).get();
        }

        @Override
        public synchronized void remove() {
            if (this.prevKey == null) {
                throw new IllegalStateException("No value has been fetched from database");
            }
            RangeQuery.this.tr.clear(this.prevKey);
        }

        @Override
        public synchronized void cancel() {
            this.isCancelled = true;
            this.nextFuture.cancel();
        }

        @Override
        public void dispose() {
            this.cancel();
        }

        class FetchComplete
        implements Runnable {
            final FutureResults fetchingChunk;
            final Settable<Boolean> promise;

            public FetchComplete(FutureResults futureResults, Settable<Boolean> settable) {
                this.fetchingChunk = futureResults;
                this.promise = settable;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    RangeResultSummary rangeResultSummary = this.fetchingChunk.getSummaryIfDone();
                    if (rangeResultSummary.lastKey == null) {
                        this.promise.set(Boolean.FALSE);
                        return;
                    }
                    AsyncRangeIterator asyncRangeIterator = AsyncRangeIterator.this;
                    synchronized (asyncRangeIterator) {
                        AsyncRangeIterator.this.fetchOutstanding = false;
                        AsyncRangeIterator.this.rowsRemaining -= rangeResultSummary.keyCount;
                        if (AsyncRangeIterator.this.reverse) {
                            AsyncRangeIterator.this.end = KeySelector.firstGreaterOrEqual(rangeResultSummary.lastKey);
                        } else {
                            AsyncRangeIterator.this.begin = KeySelector.firstGreaterThan(rangeResultSummary.lastKey);
                        }
                        RangeResult rangeResult = this.fetchingChunk.getIfDone_internal();
                        if (AsyncRangeIterator.this.chunk == null || AsyncRangeIterator.this.index == ((AsyncRangeIterator)AsyncRangeIterator.this).chunk.values.size()) {
                            AsyncRangeIterator.this.nextChunk = null;
                            AsyncRangeIterator.this.chunk = rangeResult;
                            AsyncRangeIterator.this.index = 0;
                        } else {
                            AsyncRangeIterator.this.nextChunk = rangeResult;
                        }
                    }
                    this.promise.set(Boolean.TRUE);
                }
                catch (RuntimeException runtimeException) {
                    this.promise.setError(runtimeException);
                }
                catch (Error error) {
                    this.promise.setError(error);
                }
            }
        }
    }
}

