/*
 * Decompiled with CFR 0.152.
 */
package com.foundationdb.async;

import com.foundationdb.async.AbstractPartialFuture;
import com.foundationdb.async.Function;
import com.foundationdb.async.Future;
import com.foundationdb.async.SettableFuture;
import java.util.concurrent.Executor;

public abstract class AbstractFuture<T>
extends AbstractPartialFuture<T>
implements Future<T> {
    public AbstractFuture(Executor executor) {
        super(executor);
    }

    @Deprecated
    public AbstractFuture(long l, Executor executor) {
        super(l, executor);
    }

    @Override
    protected abstract T getIfDone();

    @Override
    public T get() {
        this.blockUntilReady();
        return this.getIfDone();
    }

    @Override
    public <V> Future<V> flatMap(final Function<? super T, Future<V>> function) {
        final SettableFuture settableFuture = new SettableFuture(this.getExecutor());
        this.onReady(new Runnable(){

            @Override
            public void run() {
                try {
                    final Future future = (Future)function.apply(AbstractFuture.this.get());
                    future.onReady(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                settableFuture.set(future.get());
                            }
                            catch (RuntimeException runtimeException) {
                                settableFuture.setError(runtimeException);
                            }
                            catch (Error error) {
                                settableFuture.setError(error);
                            }
                        }
                    });
                    settableFuture.onCancelledCancel(future);
                }
                catch (RuntimeException runtimeException) {
                    settableFuture.setError(runtimeException);
                }
                catch (Error error) {
                    settableFuture.setError(error);
                }
            }
        });
        settableFuture.onCancelledCancel(this);
        return settableFuture;
    }

    @Override
    public <V> Future<V> map(final Function<? super T, V> function) {
        final SettableFuture settableFuture = new SettableFuture(this.getExecutor());
        this.onReady(new Runnable(){

            @Override
            public void run() {
                try {
                    Object v = function.apply(AbstractFuture.this.get());
                    settableFuture.set(v);
                }
                catch (RuntimeException runtimeException) {
                    settableFuture.setError(runtimeException);
                }
                catch (Error error) {
                    settableFuture.setError(error);
                }
            }
        });
        settableFuture.onCancelledCancel(this);
        return settableFuture;
    }

    @Override
    public Future<T> rescueRuntime(final Function<? super RuntimeException, Future<T>> function) {
        final SettableFuture settableFuture = new SettableFuture(this.getExecutor());
        this.onReady(new Runnable(){

            @Override
            public void run() {
                try {
                    settableFuture.set(AbstractFuture.this.get());
                }
                catch (Error error) {
                    settableFuture.setError(error);
                }
                catch (RuntimeException runtimeException) {
                    try {
                        final Future future = (Future)function.apply(runtimeException);
                        future.onReady(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    settableFuture.set(future.get());
                                }
                                catch (RuntimeException runtimeException) {
                                    settableFuture.setError(runtimeException);
                                }
                                catch (Error error) {
                                    settableFuture.setError(error);
                                }
                            }
                        });
                        settableFuture.onCancelledCancel(future);
                    }
                    catch (RuntimeException runtimeException2) {
                        settableFuture.setError(runtimeException2);
                    }
                    catch (Error error) {
                        settableFuture.setError(error);
                    }
                }
            }
        });
        settableFuture.onCancelledCancel(this);
        return settableFuture;
    }
}

