/*
 * Decompiled with CFR 0.152.
 */
package com.foundationdb.async;

import com.foundationdb.async.AsyncIterable;
import com.foundationdb.async.AsyncIterator;
import com.foundationdb.async.Function;
import com.foundationdb.async.Future;
import com.foundationdb.async.PartialFunction;
import com.foundationdb.async.PartialFuture;
import com.foundationdb.async.ReadyFuture;
import com.foundationdb.async.ReadyPartialFuture;
import com.foundationdb.async.SettableFuture;
import com.foundationdb.async.SettablePartialFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class AsyncUtil {
    private static Function<Exception, Future<Void>> makeTotal = new Function<Exception, Future<Void>>(){

        @Override
        public Future<Void> apply(Exception exception) {
            throw (RuntimeException)exception;
        }
    };

    public static <I, O> Future<O> applySafely(Function<I, Future<O>> function, I i) {
        try {
            return function.apply(i);
        }
        catch (RuntimeException runtimeException) {
            return new ReadyFuture(runtimeException);
        }
        catch (Error error) {
            return new ReadyFuture(error);
        }
    }

    public static <I, O> PartialFuture<O> applySafely(PartialFunction<I, ? extends PartialFuture<O>> partialFunction, I i) {
        try {
            return partialFunction.apply(i);
        }
        catch (Exception exception) {
            return new ReadyPartialFuture(exception);
        }
        catch (Error error) {
            return new ReadyPartialFuture(error);
        }
    }

    public static <V> Future<List<V>> collect(AsyncIterable<V> asyncIterable) {
        final AsyncIterator<V> asyncIterator = asyncIterable.iterator();
        final LinkedList linkedList = new LinkedList();
        Function<Void, Future<Boolean>> function = new Function<Void, Future<Boolean>>(){

            @Override
            public Future<Boolean> apply(Void void_) {
                return asyncIterator.onHasNext().map(new Function<Boolean, Boolean>(){

                    @Override
                    public Boolean apply(Boolean bl) {
                        if (bl.booleanValue()) {
                            linkedList.add(asyncIterator.next());
                        }
                        return bl;
                    }
                });
            }
        };
        Future<Void> future = AsyncUtil.whileTrue(function);
        Future<List<V>> future2 = AsyncUtil.tag(future, linkedList);
        return future2;
    }

    public static <V, T> AsyncIterable<T> mapIterable(final AsyncIterable<V> asyncIterable, final Function<V, T> function) {
        return new AsyncIterable<T>(){

            @Override
            public AsyncIterator<T> iterator() {
                final AsyncIterator asyncIterator = asyncIterable.iterator();
                return new AsyncIterator<T>(){

                    @Override
                    public void remove() {
                        asyncIterator.remove();
                    }

                    @Override
                    public Future<Boolean> onHasNext() {
                        return asyncIterator.onHasNext();
                    }

                    @Override
                    public boolean hasNext() {
                        return asyncIterator.hasNext();
                    }

                    @Override
                    public T next() {
                        return function.apply(asyncIterator.next());
                    }

                    @Override
                    public void cancel() {
                        asyncIterator.cancel();
                    }

                    @Override
                    public void dispose() {
                        asyncIterator.dispose();
                    }
                };
            }

            @Override
            public Future<List<T>> asList() {
                return asyncIterable.asList().map(new Function<List<V>, List<T>>(){

                    @Override
                    public List<T> apply(List<V> list) {
                        ArrayList arrayList = new ArrayList(list.size());
                        for (Object v : list) {
                            arrayList.add(function.apply(v));
                        }
                        return arrayList;
                    }
                });
            }
        };
    }

    public static PartialFuture<Void> whileTrue(PartialFunction<Void, ? extends PartialFuture<Boolean>> partialFunction) {
        return new LoopPartial(partialFunction).done;
    }

    public static Future<Void> whileTrue(Function<Void, Future<Boolean>> function) {
        return new LoopPartial(function).done.rescue(makeTotal);
    }

    public static <V> Future<Void> success(Future<V> future) {
        return future.map(new Function<V, Void>(){

            @Override
            public Void apply(V v) {
                return null;
            }
        });
    }

    public static <V> PartialFuture<Void> success(PartialFuture<V> partialFuture) {
        return partialFuture.map(new Function<V, Void>(){

            @Override
            public Void apply(V v) {
                return null;
            }
        });
    }

    public static <V> Future<Void> whenReady(PartialFuture<V> partialFuture) {
        return partialFuture.map(new PartialFunction<V, Void>(){

            @Override
            public Void apply(V v) throws Exception {
                return null;
            }
        }).rescue(new Function<Exception, Future<Void>>(){

            @Override
            public Future<Void> apply(Exception exception) {
                return ReadyFuture.DONE;
            }
        });
    }

    public static <V> Future<List<V>> getAll(final Collection<Future<V>> collection) {
        return AsyncUtil.whenAll(collection).map(new Function<Void, List<V>>(){

            @Override
            public List<V> apply(Void void_) {
                ArrayList arrayList = new ArrayList();
                for (Future future : collection) {
                    arrayList.add(future.get());
                }
                return arrayList;
            }
        });
    }

    public static <V> PartialFuture<List<V>> getAllPartial(final Collection<PartialFuture<V>> collection) {
        return AsyncUtil.whenAll(collection).map(new PartialFunction<Void, List<V>>(){

            @Override
            public List<V> apply(Void void_) throws Exception {
                ArrayList arrayList = new ArrayList();
                for (PartialFuture partialFuture : collection) {
                    arrayList.add(partialFuture.get());
                }
                return arrayList;
            }
        });
    }

    public static <V, T> Future<V> tag(Future<T> future, final V v) {
        return future.map(new Function<T, V>(){

            @Override
            public V apply(T t) {
                return v;
            }
        });
    }

    public static <V, T> PartialFuture<V> tag(PartialFuture<T> partialFuture, final V v) {
        return partialFuture.map(new Function<T, V>(){

            @Override
            public V apply(T t) {
                return v;
            }
        });
    }

    public static <V> Future<Void> whenAny(Collection<? extends PartialFuture<V>> collection) {
        for (PartialFuture<V> partialFuture : collection) {
            if (!partialFuture.isDone()) continue;
            return ReadyFuture.DONE;
        }
        final SettableFuture settableFuture = new SettableFuture();
        for (PartialFuture partialFuture : collection) {
            settableFuture.onCancelledCancel(partialFuture);
            partialFuture.onReady(new Runnable(){

                @Override
                public void run() {
                    if (settableFuture.isSet()) {
                        return;
                    }
                    try {
                        settableFuture.set(null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        return settableFuture;
    }

    public static <V> Future<Void> whenAll(Collection<? extends PartialFuture<V>> collection) {
        int n = collection.size();
        if (n == 0) {
            return ReadyFuture.DONE;
        }
        final AtomicInteger atomicInteger = new AtomicInteger(n);
        final SettableFuture<Void> settableFuture = new SettableFuture<Void>();
        for (PartialFuture<V> partialFuture : collection) {
            settableFuture.onCancelledCancel(partialFuture);
            partialFuture.onReady(new Runnable(){

                @Override
                public void run() {
                    if (atomicInteger.decrementAndGet() == 0) {
                        settableFuture.set(null);
                    }
                }
            });
        }
        return settableFuture;
    }

    private AsyncUtil() {
    }

    private static class LoopPartial {
        final PartialFunction<Void, ? extends PartialFuture<Boolean>> body;
        final SettablePartialFuture<Void> done;
        PartialFuture<Boolean> process;
        boolean m_cancelled = false;

        public LoopPartial(PartialFunction<Void, ? extends PartialFuture<Boolean>> partialFunction) {
            this.body = partialFunction;
            this.done = new SettablePartialFuture();
            this.done.onCancelled(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    LoopPartial loopPartial = LoopPartial.this;
                    synchronized (loopPartial) {
                        LoopPartial.this.m_cancelled = true;
                        LoopPartial.this.process.cancel();
                    }
                }
            });
            this.run();
        }

        private boolean shouldContinue(PartialFuture<Boolean> partialFuture) {
            try {
                if (partialFuture.get().booleanValue()) {
                    return true;
                }
                this.done.set(null);
            }
            catch (Exception exception) {
                this.done.setError(exception);
            }
            catch (Error error) {
                this.done.setError(error);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void run() {
            try {
                while (true) {
                    final PartialFuture<Boolean> partialFuture = this.body.apply(null);
                    LoopPartial loopPartial = this;
                    synchronized (loopPartial) {
                        if (this.m_cancelled) {
                            partialFuture.cancel();
                        }
                        this.process = partialFuture;
                    }
                    if (partialFuture.onReadyAlready(new Runnable(){

                        @Override
                        public void run() {
                            if (LoopPartial.this.shouldContinue(partialFuture)) {
                                LoopPartial.this.run();
                            }
                        }
                    }) && this.shouldContinue(partialFuture)) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                this.done.setError(exception);
            }
            catch (Error error) {
                this.done.setError(error);
            }
        }
    }
}

