/*
 * Decompiled with CFR 0.152.
 */
package com.foundationdb.async;

import com.foundationdb.async.Function;
import com.foundationdb.async.Future;
import com.foundationdb.async.PartialFunction;
import com.foundationdb.async.PartialFuture;
import com.foundationdb.async.ReadyFuture;
import java.util.concurrent.Executor;

public class ReadyPartialFuture<T>
implements PartialFuture<T> {
    private static final Executor DEFAULT_ES = new Executor(){

        @Override
        public void execute(Runnable runnable) {
            runnable.run();
        }
    };
    protected final Executor executor;
    private final boolean isError;
    private final T value;
    private final Throwable error;

    public ReadyPartialFuture(T t) {
        this(t, DEFAULT_ES);
    }

    public ReadyPartialFuture(Error error) {
        this(error, DEFAULT_ES);
    }

    public ReadyPartialFuture(Exception exception) {
        this(exception, DEFAULT_ES);
    }

    public ReadyPartialFuture(T t, Executor executor) {
        this.isError = false;
        this.value = t;
        this.error = null;
        this.executor = executor;
    }

    public ReadyPartialFuture(Error error, Executor executor) {
        this((Throwable)error, executor);
    }

    public ReadyPartialFuture(Exception exception, Executor executor) {
        this((Throwable)exception, executor);
    }

    private ReadyPartialFuture(Throwable throwable, Executor executor) {
        this.isError = throwable != null;
        this.error = throwable;
        this.value = null;
        this.executor = executor;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void onReady(Runnable runnable) {
        this.executor.execute(runnable);
    }

    @Override
    public boolean onReadyAlready(Runnable runnable) {
        return true;
    }

    @Override
    public <V> PartialFuture<V> flatMap(PartialFunction<? super T, ? extends PartialFuture<V>> partialFunction) {
        try {
            return partialFunction.apply(this.get());
        }
        catch (Exception exception) {
            return new ReadyPartialFuture<T>(exception, this.executor);
        }
        catch (Error error) {
            return new ReadyPartialFuture<T>(error, this.executor);
        }
    }

    @Override
    public <V> PartialFuture<V> map(PartialFunction<? super T, V> partialFunction) {
        try {
            V v = partialFunction.apply(this.get());
            return new ReadyPartialFuture<V>(v, this.executor);
        }
        catch (Exception exception) {
            return new ReadyPartialFuture<T>(exception, this.executor);
        }
        catch (Error error) {
            return new ReadyPartialFuture<T>(error, this.executor);
        }
    }

    @Override
    public Future<T> rescue(Function<? super Exception, Future<T>> function) {
        if (!this.isError()) {
            return new ReadyFuture<T>(this.value, this.executor);
        }
        try {
            if (this.error instanceof Error) {
                throw (Error)this.error;
            }
            return function.apply((Exception)this.error);
        }
        catch (RuntimeException runtimeException) {
            return new ReadyFuture(runtimeException, this.executor);
        }
        catch (Error error) {
            return new ReadyFuture(error, this.executor);
        }
    }

    @Override
    public PartialFuture<T> rescue(PartialFunction<? super Exception, ? extends PartialFuture<T>> partialFunction) {
        if (!this.isError()) {
            return this;
        }
        try {
            if (this.error instanceof Error) {
                throw (Error)this.error;
            }
            return partialFunction.apply((Exception)this.error);
        }
        catch (Exception exception) {
            return new ReadyPartialFuture<T>(exception, this.executor);
        }
        catch (Error error) {
            return new ReadyPartialFuture<T>(error, this.executor);
        }
    }

    @Override
    public void blockUntilReady() {
    }

    @Override
    public T get() throws Exception {
        if (this.isError()) {
            if (this.error instanceof Error) {
                throw (Error)this.error;
            }
            throw (Exception)this.error;
        }
        return this.value;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public boolean isError() {
        return this.isError;
    }

    @Override
    public Throwable getError() {
        if (!this.isError()) {
            throw new IllegalStateException("Future is set to value, not error");
        }
        return this.error;
    }

    @Override
    public void dispose() {
        this.cancel();
    }
}

