/*
 * Decompiled with CFR 0.152.
 */
package com.foundationdb.async;

import com.foundationdb.FDBException;
import com.foundationdb.async.AbstractFuture;
import com.foundationdb.async.Cancellable;
import com.foundationdb.async.CloneableException;
import com.foundationdb.async.Settable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;

public class SettableFuture<T>
extends AbstractFuture<T>
implements Settable<T> {
    private static final Executor DEFAULT_ES = new Executor(){

        @Override
        public void execute(Runnable runnable) {
            runnable.run();
        }
    };
    private List<Runnable> cancelCallbacks = null;
    private List<Cancellable> chainedCancels = null;
    private volatile boolean isSet = false;
    private volatile boolean isError = false;
    private volatile boolean isCancelled = false;
    private T value = null;
    private Throwable error = null;
    private Runnable callback = null;

    public SettableFuture() {
        this(DEFAULT_ES);
    }

    public SettableFuture(Executor executor) {
        super(executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(T t) {
        Runnable runnable = null;
        SettableFuture settableFuture = this;
        synchronized (settableFuture) {
            if (this.isCancelled) {
                return;
            }
            if (this.isSet()) {
                throw new IllegalStateException("Settable already set");
            }
            this.isSet = true;
            this.isError = false;
            this.value = t;
            runnable = this.callback;
            this.callback = null;
            this.cancelCallbacks = null;
            this.chainedCancels = null;
        }
        if (runnable != null) {
            runnable.run();
        }
    }

    @Override
    public void setError(Error error) {
        this.setErrorInternal(error);
    }

    @Override
    public void setError(RuntimeException runtimeException) {
        this.setErrorInternal(runtimeException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setErrorInternal(Throwable throwable) {
        Runnable runnable = null;
        SettableFuture settableFuture = this;
        synchronized (settableFuture) {
            if (this.isCancelled) {
                return;
            }
            if (this.isSet()) {
                throw new IllegalStateException("Settable already set");
            }
            this.isSet = true;
            this.isError = true;
            this.error = throwable;
            runnable = this.callback;
            this.callback = null;
            this.cancelCallbacks = null;
            this.chainedCancels = null;
        }
        if (runnable != null) {
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Runnable runnable = null;
        List<Runnable> list = null;
        List<Cancellable> list2 = null;
        Iterator<Cancellable> iterator = this;
        synchronized (iterator) {
            if (this.isSet()) {
                return;
            }
            this.isSet = true;
            this.isError = true;
            this.isCancelled = true;
            this.error = new FDBException("operation_cancelled", 1101);
            runnable = this.callback;
            list = this.cancelCallbacks;
            list2 = this.chainedCancels;
            this.callback = null;
            this.cancelCallbacks = null;
            this.chainedCancels = null;
        }
        if (list != null) {
            for (Runnable object : list) {
                this.getExecutor().execute(object);
            }
        }
        if (list2 != null) {
            for (Cancellable cancellable : list2) {
                cancellable.cancel();
            }
        }
        if (runnable != null) {
            runnable.run();
        }
    }

    @Override
    public synchronized boolean isSet() {
        return this.isSet;
    }

    @Override
    public synchronized boolean onCancelled(Runnable runnable) {
        if (this.isCancelled) {
            runnable.run();
            return true;
        }
        if (this.isSet()) {
            return false;
        }
        if (this.cancelCallbacks == null) {
            this.cancelCallbacks = new LinkedList<Runnable>();
        }
        this.cancelCallbacks.add(runnable);
        return true;
    }

    @Override
    public synchronized void onCancelledCancel(Cancellable cancellable) {
        if (this.isCancelled) {
            cancellable.cancel();
            return;
        }
        if (this.isSet()) {
            return;
        }
        if (this.chainedCancels == null) {
            this.chainedCancels = new LinkedList<Cancellable>();
        }
        this.chainedCancels.add(cancellable);
    }

    @Override
    public T getIfDone() {
        if (!this.isDone()) {
            throw new IllegalStateException("Future has not been set");
        }
        if (this.isError()) {
            if (this.error instanceof Error) {
                throw (Error)this.error;
            }
            if (this.error instanceof CloneableException) {
                throw (RuntimeException)((CloneableException)((Object)this.error)).retargetClone();
            }
            throw (RuntimeException)this.error;
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void blockUntilReady() {
        if (this.isDone()) {
            return;
        }
        final Object object = new Object();
        this.onReady(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object2 = object;
                synchronized (object2) {
                    object.notify();
                }
            }
        });
        Object object2 = object;
        synchronized (object2) {
            while (!this.isDone()) {
                try {
                    object.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    @Override
    public boolean isDone() {
        return this.isSet();
    }

    @Override
    public synchronized boolean isError() {
        if (!this.isDone()) {
            throw new IllegalStateException("Not yet set");
        }
        return this.isError;
    }

    @Override
    public synchronized Throwable getError() {
        if (!this.isError()) {
            throw new IllegalStateException("Not in an error state");
        }
        return this.error;
    }

    @Override
    protected synchronized void registerSingleCallback(Runnable runnable) {
        if (this.isDone()) {
            runnable.run();
            return;
        }
        if (this.callback != null) {
            throw new IllegalStateException("Callback already registered");
        }
        this.callback = runnable;
    }
}

