/*
 * Decompiled with CFR 0.152.
 */
package com.foundationdb.directory;

import com.foundationdb.KeyValue;
import com.foundationdb.MutationType;
import com.foundationdb.Range;
import com.foundationdb.ReadTransaction;
import com.foundationdb.Transaction;
import com.foundationdb.TransactionContext;
import com.foundationdb.async.AsyncIterator;
import com.foundationdb.async.AsyncUtil;
import com.foundationdb.async.Function;
import com.foundationdb.async.Future;
import com.foundationdb.async.ReadyFuture;
import com.foundationdb.directory.Directory;
import com.foundationdb.directory.DirectoryAlreadyExistsException;
import com.foundationdb.directory.DirectoryException;
import com.foundationdb.directory.DirectoryMoveException;
import com.foundationdb.directory.DirectoryPartition;
import com.foundationdb.directory.DirectorySubspace;
import com.foundationdb.directory.DirectoryVersionException;
import com.foundationdb.directory.MismatchedLayerException;
import com.foundationdb.directory.NoSuchDirectoryException;
import com.foundationdb.directory.PathUtil;
import com.foundationdb.subspace.Subspace;
import com.foundationdb.tuple.ByteArrayUtil;
import com.foundationdb.tuple.Tuple;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class DirectoryLayer
implements Directory {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final byte[] LITTLE_ENDIAN_LONG_ONE = new byte[]{1, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] HIGH_CONTENTION_KEY = "hca".getBytes(UTF_8);
    private static final byte[] LAYER_KEY = "layer".getBytes(UTF_8);
    private static final byte[] VERSION_KEY = "version".getBytes(UTF_8);
    private static final long SUB_DIR_KEY = 0L;
    private static final Integer[] VERSION = new Integer[]{1, 0, 0};
    static final byte[] EMPTY_BYTES = new byte[0];
    static final List<String> EMPTY_PATH = Collections.emptyList();
    static final byte[] DEFAULT_NODE_SUBSPACE_PREFIX = new byte[]{-2};
    public static final Subspace DEFAULT_NODE_SUBSPACE = new Subspace(DEFAULT_NODE_SUBSPACE_PREFIX);
    public static final Subspace DEFAULT_CONTENT_SUBSPACE = new Subspace();
    private final Subspace rootNode;
    private final Subspace nodeSubspace;
    private final Subspace contentSubspace;
    private final HighContentionAllocator allocator;
    private final boolean allowManualPrefixes;
    private List<String> path = EMPTY_PATH;
    public static final byte[] PARTITION_LAYER = "partition".getBytes(Charset.forName("UTF-8"));
    private static DirectoryLayer defaultDirectoryLayer = new DirectoryLayer();

    public DirectoryLayer() {
        this(DEFAULT_NODE_SUBSPACE, DEFAULT_CONTENT_SUBSPACE, false);
    }

    public DirectoryLayer(boolean bl) {
        this(DEFAULT_NODE_SUBSPACE, DEFAULT_CONTENT_SUBSPACE, bl);
    }

    public DirectoryLayer(Subspace subspace, Subspace subspace2) {
        this(subspace, subspace2, false);
    }

    public DirectoryLayer(Subspace subspace, Subspace subspace2, boolean bl) {
        this.nodeSubspace = subspace;
        this.contentSubspace = subspace2;
        this.rootNode = subspace.get(subspace.getKey());
        this.allocator = new HighContentionAllocator(this.rootNode.get(HIGH_CONTENTION_KEY));
        this.allowManualPrefixes = bl;
    }

    public static Directory createWithNodeSubspace(Subspace subspace) {
        return new DirectoryLayer(subspace, DEFAULT_CONTENT_SUBSPACE);
    }

    public static Directory createWithContentSubspace(Subspace subspace) {
        return new DirectoryLayer(DEFAULT_NODE_SUBSPACE, subspace);
    }

    public static DirectoryLayer getDefault() {
        return defaultDirectoryLayer;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DirectoryLayer directoryLayer = (DirectoryLayer)object;
        return (this.path == directoryLayer.path || ((Object)this.path).equals(directoryLayer.path)) && this.nodeSubspace.equals(directoryLayer.nodeSubspace) && this.contentSubspace.equals(directoryLayer.contentSubspace);
    }

    void setPath(List<String> list) {
        this.path = list;
    }

    @Override
    public List<String> getPath() {
        return Collections.unmodifiableList(this.path);
    }

    @Override
    public byte[] getLayer() {
        return EMPTY_BYTES;
    }

    @Override
    public DirectoryLayer getDirectoryLayer() {
        return this;
    }

    @Override
    public Future<DirectorySubspace> createOrOpen(TransactionContext transactionContext, List<String> list) {
        return this.createOrOpen(transactionContext, list, EMPTY_BYTES);
    }

    @Override
    public Future<DirectorySubspace> createOrOpen(TransactionContext transactionContext, List<String> list, byte[] byArray) {
        return this.createOrOpenInternal(transactionContext, list, byArray, null, true, true);
    }

    @Override
    public Future<DirectorySubspace> open(TransactionContext transactionContext, List<String> list) {
        return this.open(transactionContext, list, EMPTY_BYTES);
    }

    @Override
    public Future<DirectorySubspace> open(TransactionContext transactionContext, List<String> list, byte[] byArray) {
        return this.createOrOpenInternal(transactionContext, list, byArray, null, false, true);
    }

    @Override
    public Future<DirectorySubspace> create(TransactionContext transactionContext, List<String> list) {
        return this.create(transactionContext, list, EMPTY_BYTES, null);
    }

    @Override
    public Future<DirectorySubspace> create(TransactionContext transactionContext, List<String> list, byte[] byArray) {
        return this.create(transactionContext, list, byArray, null);
    }

    @Override
    public Future<DirectorySubspace> create(TransactionContext transactionContext, List<String> list, byte[] byArray, byte[] byArray2) {
        return this.createOrOpenInternal(transactionContext, list, byArray, byArray2, true, false);
    }

    @Override
    public Future<DirectorySubspace> moveTo(TransactionContext transactionContext, List<String> list) {
        return new ReadyFuture<DirectorySubspace>(new DirectoryMoveException("The root directory cannot be moved.", this.path, list));
    }

    @Override
    public Future<DirectorySubspace> move(TransactionContext transactionContext, List<String> list, List<String> list2) {
        final ArrayList<String> arrayList = new ArrayList<String>(list);
        final ArrayList<String> arrayList2 = new ArrayList<String>(list2);
        return transactionContext.runAsync(new Function<Transaction, Future<DirectorySubspace>>(){

            @Override
            public Future<DirectorySubspace> apply(final Transaction transaction) {
                return DirectoryLayer.this.checkVersion(transaction, true).flatMap(new Function<Void, Future<List<Node>>>(){

                    @Override
                    public Future<List<Node>> apply(Void void_) {
                        if (arrayList.size() <= arrayList2.size() && ((Object)arrayList).equals(arrayList2.subList(0, arrayList.size()))) {
                            throw new DirectoryMoveException("The destination directory cannot be a subdirectory of the source directory.", DirectoryLayer.this.toAbsolutePath(arrayList), DirectoryLayer.this.toAbsolutePath(arrayList2));
                        }
                        ArrayList arrayList = new ArrayList();
                        arrayList.add(new NodeFinder(arrayList).find(transaction).flatMap(new NodeMetadataLoader(transaction)));
                        arrayList.add(new NodeFinder(arrayList2).find(transaction).flatMap(new NodeMetadataLoader(transaction)));
                        return AsyncUtil.getAll(arrayList);
                    }
                }).flatMap(new Function<List<Node>, Future<DirectorySubspace>>(){

                    @Override
                    public Future<DirectorySubspace> apply(List<Node> list) {
                        final Node node = list.get(0);
                        Node node2 = list.get(1);
                        if (!node.exists()) {
                            throw new NoSuchDirectoryException(DirectoryLayer.this.toAbsolutePath(arrayList));
                        }
                        if (node.isInPartition(false) || node2.isInPartition(false)) {
                            if (!(node.isInPartition(false) && node2.isInPartition(false) && ((Object)node.path).equals(node2.path))) {
                                throw new DirectoryMoveException("Cannot move between partitions.", DirectoryLayer.this.toAbsolutePath(arrayList), DirectoryLayer.this.toAbsolutePath(arrayList2));
                            }
                            return node2.getContents().move(transaction, node.getPartitionSubpath(), node2.getPartitionSubpath());
                        }
                        if (node2.exists()) {
                            throw new DirectoryAlreadyExistsException(DirectoryLayer.this.toAbsolutePath(arrayList2));
                        }
                        final List<String> list2 = PathUtil.popBack(arrayList2);
                        return new NodeFinder(list2).find(transaction).flatMap(new Function<Node, Future<DirectorySubspace>>(){

                            @Override
                            public Future<DirectorySubspace> apply(Node node2) {
                                if (!node2.exists()) {
                                    throw new NoSuchDirectoryException(DirectoryLayer.this.toAbsolutePath(list2));
                                }
                                transaction.set(node2.subspace.get(0L).get(DirectoryLayer.getLast(arrayList2)).getKey(), DirectoryLayer.this.contentsOfNode(node.subspace, EMPTY_PATH, EMPTY_BYTES).getKey());
                                return DirectoryLayer.this.removeFromParent(transaction, arrayList).map(new Function<Void, DirectorySubspace>(){

                                    @Override
                                    public DirectorySubspace apply(Void void_) {
                                        return DirectoryLayer.this.contentsOfNode(node.subspace, arrayList2, node.layer);
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    public Future<Void> remove(TransactionContext transactionContext) {
        return this.remove(transactionContext, EMPTY_PATH);
    }

    @Override
    public Future<Void> remove(TransactionContext transactionContext, List<String> list) {
        return AsyncUtil.success(this.removeInternal(transactionContext, list, true));
    }

    @Override
    public Future<Boolean> removeIfExists(TransactionContext transactionContext) {
        return this.removeIfExists(transactionContext, EMPTY_PATH);
    }

    @Override
    public Future<Boolean> removeIfExists(TransactionContext transactionContext, List<String> list) {
        return this.removeInternal(transactionContext, list, false);
    }

    @Override
    public Future<List<String>> list(TransactionContext transactionContext) {
        return this.list(transactionContext, EMPTY_PATH);
    }

    @Override
    public Future<List<String>> list(TransactionContext transactionContext, List<String> list) {
        final ArrayList<String> arrayList = new ArrayList<String>(list);
        return transactionContext.runAsync(new Function<Transaction, Future<List<String>>>(){

            @Override
            public Future<List<String>> apply(final Transaction transaction) {
                return DirectoryLayer.this.checkVersion(transaction, false).flatMap(new Function<Void, Future<Node>>(){

                    @Override
                    public Future<Node> apply(Void void_) {
                        return new NodeFinder(arrayList).find(transaction).flatMap(new NodeMetadataLoader(transaction));
                    }
                }).flatMap(new Function<Node, Future<List<String>>>(){

                    @Override
                    public Future<List<String>> apply(Node node) {
                        if (!node.exists()) {
                            throw new NoSuchDirectoryException(DirectoryLayer.this.toAbsolutePath(arrayList));
                        }
                        if (node.isInPartition(true)) {
                            return node.getContents().list(transaction, node.getPartitionSubpath());
                        }
                        final Subspace subspace = node.subspace.get(0L);
                        return AsyncUtil.collect(AsyncUtil.mapIterable(transaction.getRange(subspace.range()), new Function<KeyValue, String>(){

                            @Override
                            public String apply(KeyValue keyValue) {
                                return subspace.unpack(keyValue.getKey()).getString(0);
                            }
                        }));
                    }
                });
            }
        });
    }

    @Override
    public Future<Boolean> exists(TransactionContext transactionContext) {
        return new ReadyFuture<Boolean>(true);
    }

    @Override
    public Future<Boolean> exists(TransactionContext transactionContext, List<String> list) {
        final ArrayList<String> arrayList = new ArrayList<String>(list);
        return transactionContext.runAsync(new Function<Transaction, Future<Boolean>>(){

            @Override
            public Future<Boolean> apply(final Transaction transaction) {
                return DirectoryLayer.this.checkVersion(transaction, false).flatMap(new Function<Void, Future<Node>>(){

                    @Override
                    public Future<Node> apply(Void void_) {
                        return new NodeFinder(arrayList).find(transaction).flatMap(new NodeMetadataLoader(transaction));
                    }
                }).flatMap(new Function<Node, Future<Boolean>>(){

                    @Override
                    public Future<Boolean> apply(Node node) {
                        if (!node.exists()) {
                            return new ReadyFuture<Boolean>(false);
                        }
                        if (node.isInPartition(false)) {
                            return node.getContents().exists(transaction, node.getPartitionSubpath());
                        }
                        return new ReadyFuture<Boolean>(true);
                    }
                });
            }
        });
    }

    private Subspace nodeWithPrefix(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return this.nodeSubspace.get(byArray);
    }

    private Future<Subspace> nodeContainingKey(ReadTransaction readTransaction, final byte[] byArray) {
        if (ByteArrayUtil.startsWith(byArray, this.nodeSubspace.getKey())) {
            return new ReadyFuture<Subspace>(this.rootNode);
        }
        return readTransaction.getRange(this.nodeSubspace.range().begin, ByteArrayUtil.join(this.nodeSubspace.pack(byArray), {0}), 1, true).asList().map(new Function<List<KeyValue>, Subspace>(){

            @Override
            public Subspace apply(List<KeyValue> list) {
                if (list.size() > 0) {
                    byte[] byArray3 = list.get(0).getKey();
                    byte[] byArray2 = DirectoryLayer.this.nodeSubspace.unpack(byArray3).getBytes(0);
                    if (ByteArrayUtil.startsWith(byArray, byArray2)) {
                        return new Subspace(byArray);
                    }
                }
                return null;
            }
        });
    }

    private List<String> toAbsolutePath(List<String> list) {
        return PathUtil.join(this.path, list);
    }

    private DirectorySubspace contentsOfNode(Subspace subspace, List<String> list, byte[] byArray) {
        byte[] byArray2 = this.nodeSubspace.unpack(subspace.getKey()).getBytes(0);
        if (Arrays.equals(byArray, PARTITION_LAYER)) {
            return new DirectoryPartition(this.toAbsolutePath(list), byArray2, this);
        }
        return new DirectorySubspace(this.toAbsolutePath(list), byArray2, this, byArray);
    }

    private Future<Boolean> removeInternal(TransactionContext transactionContext, List<String> list, final boolean bl) {
        final ArrayList<String> arrayList = new ArrayList<String>(list);
        return transactionContext.runAsync(new Function<Transaction, Future<Boolean>>(){

            @Override
            public Future<Boolean> apply(final Transaction transaction) {
                return DirectoryLayer.this.checkVersion(transaction, true).flatMap(new Function<Void, Future<Node>>(){

                    @Override
                    public Future<Node> apply(Void void_) {
                        if (arrayList.size() == 0) {
                            throw new DirectoryException("The root directory cannot be removed.", DirectoryLayer.this.toAbsolutePath(arrayList));
                        }
                        return new NodeFinder(arrayList).find(transaction).flatMap(new NodeMetadataLoader(transaction));
                    }
                }).flatMap(new Function<Node, Future<Boolean>>(){

                    @Override
                    public Future<Boolean> apply(Node node) {
                        if (!node.exists()) {
                            if (bl) {
                                throw new NoSuchDirectoryException(DirectoryLayer.this.toAbsolutePath(arrayList));
                            }
                            return new ReadyFuture<Boolean>(false);
                        }
                        if (node.isInPartition(false)) {
                            return node.getContents().getDirectoryLayer().removeInternal(transaction, node.getPartitionSubpath(), bl);
                        }
                        ArrayList<Future> arrayList = new ArrayList<Future>();
                        arrayList.add(DirectoryLayer.this.removeRecursive(transaction, node.subspace));
                        arrayList.add(DirectoryLayer.this.removeFromParent(transaction, arrayList));
                        return AsyncUtil.tag(AsyncUtil.whenAll(arrayList), Boolean.valueOf(true));
                    }
                });
            }
        });
    }

    private Future<Void> removeFromParent(final Transaction transaction, final List<String> list) {
        return new NodeFinder(PathUtil.popBack(list)).find(transaction).map(new Function<Node, Void>(){

            @Override
            public Void apply(Node node) {
                transaction.clear(node.subspace.get(0L).get(DirectoryLayer.getLast(list)).getKey());
                return null;
            }
        });
    }

    private Future<Void> removeRecursive(final Transaction transaction, Subspace subspace) {
        Subspace subspace2 = subspace.get(0L);
        final AsyncIterator<KeyValue> asyncIterator = transaction.getRange(subspace2.range()).iterator();
        transaction.clear(Range.startsWith(this.nodeSubspace.unpack(subspace.getKey()).getBytes(0)));
        transaction.clear(subspace.range());
        return AsyncUtil.whileTrue(new Function<Void, Future<Boolean>>(){

            @Override
            public Future<Boolean> apply(Void void_) {
                Future future = asyncIterator.onHasNext().isDone() ? DirectoryLayer.this.removeRecursive(transaction, DirectoryLayer.this.nodeWithPrefix(((KeyValue)asyncIterator.next()).getValue())) : ReadyFuture.DONE;
                return future.flatMap(new Function<Void, Future<Boolean>>(){

                    @Override
                    public Future<Boolean> apply(Void void_) {
                        return asyncIterator.onHasNext();
                    }
                });
            }
        });
    }

    private Future<Boolean> isPrefixFree(final ReadTransaction readTransaction, final byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return new ReadyFuture<Boolean>(false);
        }
        return this.nodeContainingKey(readTransaction, byArray).flatMap(new Function<Subspace, Future<Boolean>>(){

            @Override
            public Future<Boolean> apply(Subspace subspace) {
                if (subspace != null) {
                    return new ReadyFuture<Boolean>(false);
                }
                AsyncIterator<KeyValue> asyncIterator = readTransaction.getRange(DirectoryLayer.this.nodeSubspace.pack(byArray), DirectoryLayer.this.nodeSubspace.pack(ByteArrayUtil.strinc(byArray)), 1).iterator();
                return asyncIterator.onHasNext().map(new Function<Boolean, Boolean>(){

                    @Override
                    public Boolean apply(Boolean bl) {
                        return bl == false;
                    }
                });
            }
        });
    }

    private Future<Void> checkVersion(final Transaction transaction, final boolean bl) {
        return transaction.get(this.rootNode.pack(VERSION_KEY)).map(new Function<byte[], Void>(){

            @Override
            public Void apply(byte[] byArray) {
                if (byArray == null) {
                    if (bl) {
                        DirectoryLayer.this.initializeDirectory(transaction);
                    }
                    return null;
                }
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                Integer[] integerArray = new Integer[3];
                for (int i = 0; i < integerArray.length; ++i) {
                    integerArray[i] = byteBuffer.getInt();
                }
                String string = String.format("version %d.%d.%d", integerArray);
                String string2 = String.format("directory layer %d.%d.%d", VERSION);
                if (integerArray[0] > VERSION[0]) {
                    throw new DirectoryVersionException("Cannot load directory with " + string + " using " + string2 + ".");
                }
                if (integerArray[1] > VERSION[1] && bl) {
                    throw new DirectoryVersionException("Directory with " + string + " is read-only when opened with " + string2 + ".");
                }
                return null;
            }
        });
    }

    private void initializeDirectory(Transaction transaction) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(VERSION.length * 4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        Integer[] integerArray = VERSION;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = integerArray[i];
            byteBuffer.putInt(n2);
        }
        transaction.set(this.rootNode.pack(VERSION_KEY), byteBuffer.array());
    }

    private Future<DirectorySubspace> createOrOpenInternal(TransactionContext transactionContext, List<String> list, final byte[] byArray, final byte[] byArray2, final boolean bl, final boolean bl2) {
        final ArrayList<String> arrayList = new ArrayList<String>(list);
        if (byArray2 != null && !this.allowManualPrefixes) {
            String string = this.path.size() == 0 ? "Cannot specify a prefix unless manual prefixes are enabled." : "Cannot specify a prefix in a partition.";
            return new ReadyFuture<DirectorySubspace>(new IllegalArgumentException(string));
        }
        return transactionContext.runAsync(new Function<Transaction, Future<DirectorySubspace>>(){

            @Override
            public Future<DirectorySubspace> apply(final Transaction transaction) {
                return DirectoryLayer.this.checkVersion(transaction, false).flatMap(new Function<Void, Future<Node>>(){

                    @Override
                    public Future<Node> apply(Void void_) {
                        if (arrayList.size() == 0) {
                            throw new IllegalArgumentException("The root directory may not be opened.");
                        }
                        return new NodeFinder(arrayList).find(transaction).flatMap(new NodeMetadataLoader(transaction));
                    }
                }).flatMap(new Function<Node, Future<DirectorySubspace>>(){

                    @Override
                    public Future<DirectorySubspace> apply(Node node) {
                        if (node.exists()) {
                            if (node.isInPartition(false)) {
                                List<String> list = node.getPartitionSubpath();
                                return node.getContents().getDirectoryLayer().createOrOpenInternal(transaction, list, byArray, byArray2, bl, bl2);
                            }
                            return new ReadyFuture<DirectorySubspace>(DirectoryLayer.this.openInternal(transaction, arrayList, byArray, node, bl2));
                        }
                        return DirectoryLayer.this.createInternal(transaction, arrayList, byArray, byArray2, bl);
                    }
                });
            }
        });
    }

    private DirectorySubspace openInternal(Transaction transaction, List<String> list, byte[] byArray, Node node, boolean bl) {
        if (!bl) {
            throw new DirectoryAlreadyExistsException(this.toAbsolutePath(list));
        }
        if (byArray.length > 0 && !Arrays.equals(byArray, node.layer)) {
            throw new MismatchedLayerException(this.toAbsolutePath(list), node.layer, byArray);
        }
        return node.getContents();
    }

    private Future<DirectorySubspace> createInternal(final Transaction transaction, final List<String> list, final byte[] byArray, final byte[] byArray2, boolean bl) {
        if (!bl) {
            throw new NoSuchDirectoryException(this.toAbsolutePath(list));
        }
        return this.checkVersion(transaction, true).flatMap(new Function<Void, Future<byte[]>>(){

            @Override
            public Future<byte[]> apply(Void void_) {
                if (byArray2 == null) {
                    return DirectoryLayer.this.allocator.allocate(transaction).flatMap(new Function<byte[], Future<byte[]>>(){

                        @Override
                        public Future<byte[]> apply(byte[] byArray) {
                            final byte[] byArray2 = ByteArrayUtil.join(DirectoryLayer.this.contentSubspace.getKey(), byArray);
                            return transaction.getRange(Range.startsWith(byArray2), 1).asList().map(new Function<List<KeyValue>, byte[]>(){

                                @Override
                                public byte[] apply(List<KeyValue> list) {
                                    if (list.size() > 0) {
                                        throw new IllegalStateException("The database has keys stored at the prefix chosen by the automatic prefix allocator: " + ByteArrayUtil.printable(byArray2) + ".");
                                    }
                                    return byArray2;
                                }
                            });
                        }
                    });
                }
                return new ReadyFuture<byte[]>(byArray2);
            }
        }).flatMap(new Function<byte[], Future<DirectorySubspace>>(){

            @Override
            public Future<DirectorySubspace> apply(final byte[] byArray3) {
                return DirectoryLayer.this.isPrefixFree(byArray2 == null ? transaction.snapshot() : transaction, byArray3).flatMap(new Function<Boolean, Future<Subspace>>(){

                    @Override
                    public Future<Subspace> apply(Boolean bl) {
                        if (!bl.booleanValue()) {
                            if (byArray2 == null) {
                                throw new IllegalStateException("The directory layer has manually allocated prefixes that conflict with the automatic prefix allocator.");
                            }
                            throw new IllegalArgumentException("Prefix already in use: " + ByteArrayUtil.printable(byArray3) + ".");
                        }
                        if (list.size() > 1) {
                            return DirectoryLayer.this.createOrOpen(transaction, PathUtil.popBack(list)).map(new Function<DirectorySubspace, Subspace>(){

                                @Override
                                public Subspace apply(DirectorySubspace directorySubspace) {
                                    return DirectoryLayer.this.nodeWithPrefix(directorySubspace.getKey());
                                }
                            });
                        }
                        return new ReadyFuture<Subspace>(DirectoryLayer.this.rootNode);
                    }
                }).map(new Function<Subspace, DirectorySubspace>(){

                    @Override
                    public DirectorySubspace apply(Subspace subspace) {
                        if (subspace == null) {
                            throw new IllegalStateException("The parent directory does not exist.");
                        }
                        Subspace subspace2 = DirectoryLayer.this.nodeWithPrefix(byArray3);
                        transaction.set(subspace.get(0L).get(DirectoryLayer.getLast(list)).getKey(), byArray3);
                        transaction.set(subspace2.get(LAYER_KEY).getKey(), byArray);
                        return DirectoryLayer.this.contentsOfNode(subspace2, list, byArray);
                    }
                });
            }
        });
    }

    private static long unpackLittleEndian(byte[] byArray) {
        assert (byArray.length == 8);
        int n = 0;
        for (int i = 0; i < 8; ++i) {
            n += byArray[i] << i * 8;
        }
        return n;
    }

    private static String getLast(List<String> list) {
        assert (list.size() > 0);
        return list.get(list.size() - 1);
    }

    private static class HighContentionAllocator {
        private final Subspace counters;
        private final Subspace recent;

        public HighContentionAllocator(Subspace subspace) {
            this.counters = subspace.get(0);
            this.recent = subspace.get(1);
        }

        public Future<byte[]> allocate(final Transaction transaction) {
            final AsyncIterator<KeyValue> asyncIterator = transaction.snapshot().getRange(this.counters.range(), 1, true).iterator();
            return asyncIterator.onHasNext().flatMap(new Function<Boolean, Future<byte[]>>(){

                @Override
                public Future<byte[]> apply(Boolean bl) {
                    int n;
                    long l = 0L;
                    long l2 = 0L;
                    if (bl.booleanValue()) {
                        KeyValue keyValue = (KeyValue)asyncIterator.next();
                        l = HighContentionAllocator.this.counters.unpack(keyValue.getKey()).getLong(0);
                        l2 = DirectoryLayer.unpackLittleEndian(keyValue.getValue());
                    }
                    if ((l2 + 1L) * 2L >= (long)(n = HighContentionAllocator.windowSize(l))) {
                        byte[] byArray = HighContentionAllocator.this.counters.getKey();
                        byte[] byArray2 = ByteArrayUtil.join(HighContentionAllocator.this.counters.get(l).getKey(), {0});
                        transaction.clear(byArray, byArray2);
                        transaction.clear(HighContentionAllocator.this.recent.getKey(), HighContentionAllocator.this.recent.get(l += (long)n).getKey());
                        n = HighContentionAllocator.windowSize(l);
                    }
                    transaction.mutate(MutationType.ADD, HighContentionAllocator.this.counters.get(l).getKey(), LITTLE_ENDIAN_LONG_ONE);
                    return new PrefixFinder(l, n).find(transaction, HighContentionAllocator.this.recent);
                }
            });
        }

        private static int windowSize(long l) {
            if (l < 255L) {
                return 64;
            }
            if (l < 65535L) {
                return 1024;
            }
            return 8192;
        }
    }

    private static class PrefixFinder {
        private final long start;
        private final int window;
        private final Random random;
        private long candidate;

        public PrefixFinder(long l, int n) {
            this.start = l;
            this.window = n;
            this.random = new Random();
        }

        public Future<byte[]> find(final Transaction transaction, final Subspace subspace) {
            return AsyncUtil.whileTrue(new Function<Void, Future<Boolean>>(){

                @Override
                public Future<Boolean> apply(Void void_) {
                    PrefixFinder.this.candidate = PrefixFinder.this.start + (long)PrefixFinder.this.random.nextInt(PrefixFinder.this.window);
                    final byte[] byArray = subspace.get(PrefixFinder.this.candidate).getKey();
                    return transaction.get(byArray).map(new Function<byte[], Boolean>(){

                        @Override
                        public Boolean apply(byte[] byArray2) {
                            if (byArray2 == null) {
                                transaction.set(byArray, EMPTY_BYTES);
                                return false;
                            }
                            return true;
                        }
                    });
                }
            }).map(new Function<Void, byte[]>(){

                @Override
                public byte[] apply(Void void_) {
                    return Tuple.from(PrefixFinder.this.candidate).pack();
                }
            });
        }
    }

    private class Node {
        public final Subspace subspace;
        public final List<String> path;
        public final List<String> targetPath;
        public byte[] layer;
        private boolean loadedMetadata;

        public Node(Subspace subspace, List<String> list, List<String> list2) {
            this.subspace = subspace;
            this.path = list;
            this.targetPath = list2;
            this.layer = null;
            this.loadedMetadata = false;
        }

        public boolean exists() {
            return this.subspace != null;
        }

        public Future<Node> loadMetadata(Transaction transaction) {
            if (!this.exists()) {
                this.loadedMetadata = true;
                return new ReadyFuture<Node>(this);
            }
            return transaction.get(this.subspace.pack(new Tuple().add(LAYER_KEY))).map(new Function<byte[], Node>(){

                @Override
                public Node apply(byte[] byArray) {
                    Node.this.layer = byArray;
                    Node.this.loadedMetadata = true;
                    return Node.this;
                }
            });
        }

        public void ensureMetadataLoaded() {
            if (!this.loadedMetadata) {
                throw new IllegalStateException("Metadata for node has not been loaded");
            }
        }

        public boolean isInPartition(boolean bl) {
            this.ensureMetadataLoaded();
            return this.exists() && Arrays.equals(this.layer, PARTITION_LAYER) && (bl || this.targetPath.size() > this.path.size());
        }

        public List<String> getPartitionSubpath() {
            this.ensureMetadataLoaded();
            return this.targetPath.subList(this.path.size(), this.targetPath.size());
        }

        public DirectorySubspace getContents() {
            this.ensureMetadataLoaded();
            return DirectoryLayer.this.contentsOfNode(this.subspace, this.path, this.layer);
        }
    }

    private static class NodeMetadataLoader
    implements Function<Node, Future<Node>> {
        private final Transaction tr;

        public NodeMetadataLoader(Transaction transaction) {
            this.tr = transaction;
        }

        @Override
        public Future<Node> apply(Node node) {
            return node.loadMetadata(this.tr);
        }
    }

    private class NodeFinder {
        private List<String> path;
        private int index;
        private Node node;
        private List<String> currentPath;

        public NodeFinder(List<String> list) {
            this.path = list;
        }

        public Future<Node> find(final Transaction transaction) {
            this.index = 0;
            this.node = new Node(DirectoryLayer.this.rootNode, this.currentPath, this.path);
            this.currentPath = new ArrayList<String>();
            return AsyncUtil.whileTrue(new Function<Void, Future<Boolean>>(){

                @Override
                public Future<Boolean> apply(Void void_) {
                    if (NodeFinder.this.index == NodeFinder.this.path.size()) {
                        return new ReadyFuture<Boolean>(false);
                    }
                    return transaction.get(((NodeFinder)NodeFinder.this).node.subspace.get(0L).get(NodeFinder.this.path.get(NodeFinder.this.index)).getKey()).flatMap(new Function<byte[], Future<Boolean>>(){

                        @Override
                        public Future<Boolean> apply(byte[] byArray) {
                            NodeFinder.this.currentPath.add(NodeFinder.this.path.get(NodeFinder.this.index));
                            NodeFinder.this.node = new Node(DirectoryLayer.this.nodeWithPrefix(byArray), NodeFinder.this.currentPath, NodeFinder.this.path);
                            if (!NodeFinder.this.node.exists()) {
                                return new ReadyFuture<Boolean>(false);
                            }
                            return NodeFinder.this.node.loadMetadata(transaction).map(new Function<Node, Boolean>(){

                                @Override
                                public Boolean apply(Node node) {
                                    ++NodeFinder.this.index;
                                    return !Arrays.equals(((NodeFinder)NodeFinder.this).node.layer, PARTITION_LAYER);
                                }
                            });
                        }
                    });
                }
            }).map(new Function<Void, Node>(){

                @Override
                public Node apply(Void void_) {
                    return NodeFinder.this.node;
                }
            });
        }
    }
}

