/*
 * Decompiled with CFR 0.152.
 */
package com.foundationdb.directory;

import com.foundationdb.TransactionContext;
import com.foundationdb.async.Future;
import com.foundationdb.directory.Directory;
import com.foundationdb.directory.DirectoryLayer;
import com.foundationdb.directory.DirectoryMoveException;
import com.foundationdb.directory.DirectoryUtil;
import com.foundationdb.directory.PathUtil;
import com.foundationdb.subspace.Subspace;
import com.foundationdb.tuple.ByteArrayUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DirectorySubspace
extends Subspace
implements Directory {
    private final List<String> path;
    private final byte[] layer;
    private final DirectoryLayer directoryLayer;

    DirectorySubspace(List<String> list, byte[] byArray, DirectoryLayer directoryLayer) {
        this(list, byArray, directoryLayer, DirectoryLayer.EMPTY_BYTES);
    }

    DirectorySubspace(List<String> list, byte[] byArray, DirectoryLayer directoryLayer, byte[] byArray2) {
        super(byArray);
        this.path = list;
        this.layer = byArray2;
        this.directoryLayer = directoryLayer;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + '(' + DirectoryUtil.pathStr(this.path) + ", " + ByteArrayUtil.printable(this.getKey()) + ')';
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DirectorySubspace directorySubspace = (DirectorySubspace)object;
        return (this.path == directorySubspace.path || ((Object)this.path).equals(directorySubspace.path)) && Arrays.equals(this.layer, directorySubspace.layer) && this.directoryLayer.equals(directorySubspace.directoryLayer) && super.equals(object);
    }

    @Override
    public List<String> getPath() {
        return Collections.unmodifiableList(this.path);
    }

    @Override
    public byte[] getLayer() {
        return Arrays.copyOf(this.layer, this.layer.length);
    }

    @Override
    public DirectoryLayer getDirectoryLayer() {
        return this.directoryLayer;
    }

    @Override
    public Future<DirectorySubspace> createOrOpen(TransactionContext transactionContext, List<String> list) {
        return this.createOrOpen(transactionContext, list, DirectoryLayer.EMPTY_BYTES);
    }

    @Override
    public Future<DirectorySubspace> createOrOpen(TransactionContext transactionContext, List<String> list, byte[] byArray) {
        return this.directoryLayer.createOrOpen(transactionContext, this.getPartitionSubpath(list), byArray);
    }

    @Override
    public Future<DirectorySubspace> open(TransactionContext transactionContext, List<String> list) {
        return this.open(transactionContext, list, DirectoryLayer.EMPTY_BYTES);
    }

    @Override
    public Future<DirectorySubspace> open(TransactionContext transactionContext, List<String> list, byte[] byArray) {
        return this.directoryLayer.open(transactionContext, this.getPartitionSubpath(list), byArray);
    }

    @Override
    public Future<DirectorySubspace> create(TransactionContext transactionContext, List<String> list) {
        return this.create(transactionContext, list, DirectoryLayer.EMPTY_BYTES, null);
    }

    @Override
    public Future<DirectorySubspace> create(TransactionContext transactionContext, List<String> list, byte[] byArray) {
        return this.create(transactionContext, list, byArray, null);
    }

    @Override
    public Future<DirectorySubspace> create(TransactionContext transactionContext, List<String> list, byte[] byArray, byte[] byArray2) {
        return this.directoryLayer.create(transactionContext, this.getPartitionSubpath(list), byArray, byArray2);
    }

    @Override
    public Future<List<String>> list(TransactionContext transactionContext) {
        return this.list(transactionContext, DirectoryLayer.EMPTY_PATH);
    }

    @Override
    public Future<List<String>> list(TransactionContext transactionContext, List<String> list) {
        return this.directoryLayer.list(transactionContext, this.getPartitionSubpath(list));
    }

    @Override
    public Future<DirectorySubspace> move(TransactionContext transactionContext, List<String> list, List<String> list2) {
        return this.directoryLayer.move(transactionContext, this.getPartitionSubpath(list), this.getPartitionSubpath(list2));
    }

    @Override
    public Future<DirectorySubspace> moveTo(TransactionContext transactionContext, List<String> list) {
        DirectoryLayer directoryLayer = this.getLayerForPath(DirectoryLayer.EMPTY_PATH);
        int n = directoryLayer.getPath().size();
        List<String> list2 = list.subList(0, Math.min(list.size(), n));
        if (!((Object)list2).equals(directoryLayer.getPath())) {
            throw new DirectoryMoveException("Cannot move between partitions", this.path, list);
        }
        return directoryLayer.move(transactionContext, this.getPartitionSubpath(DirectoryLayer.EMPTY_PATH, directoryLayer), list.subList(n, list.size()));
    }

    @Override
    public Future<Void> remove(TransactionContext transactionContext) {
        return this.remove(transactionContext, DirectoryLayer.EMPTY_PATH);
    }

    @Override
    public Future<Void> remove(TransactionContext transactionContext, List<String> list) {
        DirectoryLayer directoryLayer = this.getLayerForPath(list);
        return directoryLayer.remove(transactionContext, this.getPartitionSubpath(list, directoryLayer));
    }

    @Override
    public Future<Boolean> removeIfExists(TransactionContext transactionContext) {
        return this.removeIfExists(transactionContext, DirectoryLayer.EMPTY_PATH);
    }

    @Override
    public Future<Boolean> removeIfExists(TransactionContext transactionContext, List<String> list) {
        DirectoryLayer directoryLayer = this.getLayerForPath(list);
        return directoryLayer.removeIfExists(transactionContext, this.getPartitionSubpath(list, directoryLayer));
    }

    @Override
    public Future<Boolean> exists(TransactionContext transactionContext) {
        return this.exists(transactionContext, DirectoryLayer.EMPTY_PATH);
    }

    @Override
    public Future<Boolean> exists(TransactionContext transactionContext, List<String> list) {
        DirectoryLayer directoryLayer = this.getLayerForPath(list);
        return directoryLayer.exists(transactionContext, this.getPartitionSubpath(list, directoryLayer));
    }

    private List<String> getPartitionSubpath(List<String> list) {
        return this.getPartitionSubpath(list, this.directoryLayer);
    }

    private List<String> getPartitionSubpath(List<String> list, DirectoryLayer directoryLayer) {
        return PathUtil.join(this.path.subList(directoryLayer.getPath().size(), this.path.size()), list);
    }

    DirectoryLayer getLayerForPath(List<String> list) {
        return this.directoryLayer;
    }
}

