/*
 * Decompiled with CFR 0.152.
 */
package com.foundationdb.tuple;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class ByteArrayUtil {
    public static byte[] join(byte[] byArray, List<byte[]> list) {
        if (list == null) {
            return new byte[0];
        }
        int n = list.size();
        if (n == 0) {
            return new byte[0];
        }
        if (byArray == null) {
            byArray = new byte[]{};
        }
        int n2 = 0;
        int n3 = byArray.length;
        for (byte[] byArray2 : list) {
            n2 += byArray2.length;
        }
        Object object = new byte[n3 * (n - 1) + n2];
        int n4 = 0;
        int n5 = 0;
        for (byte[] byArray3 : list) {
            int n6 = byArray3.length;
            if (n6 > 0) {
                System.arraycopy(byArray3, 0, object, n4, n6);
                n4 += n6;
            }
            if (n5 < n - 1 && n3 > 0) {
                System.arraycopy(byArray, 0, object, n4, n3);
                n4 += n3;
            }
            ++n5;
        }
        return object;
    }

    public static byte[] join(byte[] ... byArray) {
        return ByteArrayUtil.join(null, Arrays.asList(byArray));
    }

    static boolean regionEquals(byte[] byArray, int n, byte[] byArray2) {
        if (byArray == null) {
            if (n == 0) {
                return byArray2 == null;
            }
            throw new IllegalArgumentException("start index after end of src");
        }
        if (byArray2 == null) {
            return false;
        }
        if (n >= byArray.length) {
            throw new IllegalArgumentException("start index after end of src");
        }
        if (byArray.length < n + byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray2[i] == byArray[n + i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] replace(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return ByteArrayUtil.join(byArray3, ByteArrayUtil.split(byArray, byArray2));
    }

    public static byte[] replace(byte[] byArray, int n, int n2, byte[] byArray2, byte[] byArray3) {
        return ByteArrayUtil.join(byArray3, ByteArrayUtil.split(byArray, n, n2, byArray2));
    }

    public static List<byte[]> split(byte[] byArray, byte[] byArray2) {
        return ByteArrayUtil.split(byArray, 0, byArray.length, byArray2);
    }

    public static List<byte[]> split(byte[] byArray, int n, int n2, byte[] byArray2) {
        LinkedList<byte[]> linkedList = new LinkedList<byte[]>();
        int n3 = n;
        int n4 = n;
        while (n3 <= n + n2 - byArray2.length) {
            if (ByteArrayUtil.regionEquals(byArray, n3, byArray2)) {
                linkedList.add(Arrays.copyOfRange(byArray, n4, n3));
                n4 = n3 += byArray2.length;
                continue;
            }
            ++n3;
        }
        if (n4 == n + n2) {
            linkedList.add(new byte[0]);
        } else {
            linkedList.add(Arrays.copyOfRange(byArray, n4, n + n2));
        }
        return linkedList;
    }

    static int bisectLeft(BigInteger[] bigIntegerArray, BigInteger bigInteger) {
        int n = Arrays.binarySearch(bigIntegerArray, bigInteger);
        if (n >= 0) {
            return n;
        }
        int n2 = (n + 1) * -1;
        return n2;
    }

    public static int compareUnsigned(byte[] byArray, byte[] byArray2) {
        int n = 0;
        while (n < byArray.length && n < byArray2.length) {
            if (byArray[n] == byArray2[n]) continue;
            return (byArray[n] & 0xFF) < (byArray2[n] & 0xFF) ? -1 : 1;
        }
        if (byArray.length == byArray2.length) {
            return 0;
        }
        return byArray.length < byArray2.length ? -1 : 1;
    }

    public static boolean startsWith(byte[] byArray, byte[] byArray2) {
        if (byArray.length < byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray2[i] == byArray[i]) continue;
            return false;
        }
        return true;
    }

    static int findNext(byte[] byArray, byte by, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (byArray[i] != by) continue;
            return i;
        }
        return -1;
    }

    static int findTerminator(byte[] byArray, byte by, byte by2, int n) {
        return ByteArrayUtil.findTerminator(byArray, by, by2, n, byArray.length);
    }

    static int findTerminator(byte[] byArray, byte by, byte by2, int n, int n2) {
        int n3 = n;
        while ((n3 = ByteArrayUtil.findNext(byArray, by, n3, n2)) >= 0) {
            if (n3 + 1 == n2 || byArray[n3 + 1] != by2) {
                return n3;
            }
            n3 += 2;
        }
        return n2;
    }

    public static byte[] strinc(byte[] byArray) {
        byte[] byArray2 = ByteArrayUtil.rstrip(byArray, (byte)-1);
        if (byArray2.length == 0) {
            throw new IllegalArgumentException("No key beyond supplied prefix");
        }
        byArray2[byArray2.length - 1] = (byte)(byArray2[byArray2.length - 1] + 1);
        return byArray2;
    }

    static byte[] rstrip(byte[] byArray, byte by) {
        int n;
        for (n = byArray.length - 1; n >= 0 && byArray[n] == by; --n) {
        }
        return Arrays.copyOfRange(byArray, 0, n + 1);
    }

    public static byte[] encodeInt(long l) {
        return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(l).array();
    }

    public static long decodeInt(byte[] byArray) {
        if (byArray.length != 8) {
            throw new IllegalArgumentException("Source array must be of length 8");
        }
        return ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getLong();
    }

    public static String printable(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            if (by >= 32 && by < 127 && by != 92) {
                stringBuilder.append((char)by);
                continue;
            }
            if (by == 92) {
                stringBuilder.append("\\\\");
                continue;
            }
            stringBuilder.append(String.format("\\x%02x", by));
        }
        return stringBuilder.toString();
    }

    private ByteArrayUtil() {
    }
}

