/*
 * Decompiled with CFR 0.152.
 */
package com.foundationdb;

import com.foundationdb.Cluster;
import com.foundationdb.Database;
import com.foundationdb.FDBException;
import com.foundationdb.FutureCluster;
import com.foundationdb.JNIUtil;
import com.foundationdb.NetworkOptions;
import com.foundationdb.OptionConsumer;
import java.nio.charset.Charset;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;

public class FDB {
    static FDB singleton = null;
    final int apiVersion;
    private ExecutorService ex;
    private volatile boolean netStarted = false;
    private volatile boolean netStopped = false;
    private final Semaphore netRunning = new Semaphore(1);
    private final NetworkOptions options;
    private static final Charset UTF8 = Charset.forName("UTF-8");

    private FDB(int n) {
        this.apiVersion = n;
        DaemonThreadFactory daemonThreadFactory = new DaemonThreadFactory(Executors.defaultThreadFactory());
        this.ex = Executors.newCachedThreadPool(daemonThreadFactory);
        this.options = new NetworkOptions(new OptionConsumer(){

            @Override
            public void setOption(int n, byte[] byArray) {
                FDB.this.Network_setOption(n, byArray);
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                FDB.this.stopNetwork();
            }
        }));
    }

    public NetworkOptions options() {
        return this.options;
    }

    public static synchronized FDB selectAPIVersion(int n) throws FDBException {
        if (singleton != null) {
            if (n != FDB.singleton.apiVersion) {
                throw new IllegalArgumentException("FoundationDB API already started at different version");
            }
            return singleton;
        }
        if (n < 23) {
            throw new IllegalArgumentException("API version not supported (minimum 23)");
        }
        if (n > 300) {
            throw new IllegalArgumentException("API version not supported (maximum 300)");
        }
        FDB.Select_API_version(n);
        singleton = new FDB(n);
        return singleton;
    }

    public Cluster createCluster() throws IllegalStateException, FDBException {
        return this.createCluster(null, this.ex);
    }

    public Cluster createCluster(String string) throws IllegalStateException, FDBException {
        return this.createCluster(string, this.ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cluster createCluster(String string, Executor executor) throws FDBException, IllegalStateException {
        FutureCluster futureCluster;
        FDB fDB = this;
        synchronized (fDB) {
            if (!this.isConnected()) {
                this.startNetwork(executor);
            }
            futureCluster = new FutureCluster(this.Cluster_create(string), executor);
        }
        return (Cluster)futureCluster.get();
    }

    public Database open() throws FDBException {
        return this.open(null);
    }

    public Database open(String string) throws FDBException {
        return this.open(string, "DB".getBytes(UTF8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Database open(String string, byte[] byArray) throws FDBException {
        FutureCluster futureCluster;
        Object object = this;
        synchronized (object) {
            if (!this.isConnected()) {
                this.startNetwork();
            }
            futureCluster = new FutureCluster(this.Cluster_create(string), this.ex);
        }
        object = (Cluster)futureCluster.get();
        return ((Cluster)object).openDatabase(byArray);
    }

    public void startNetwork() throws FDBException, IllegalStateException {
        this.startNetwork(this.ex);
    }

    public synchronized void startNetwork(Executor executor) throws FDBException, IllegalStateException {
        if (this.netStopped) {
            throw new IllegalStateException("Network has been stopped and cannot be restarted");
        }
        if (this.netStarted) {
            return;
        }
        this.Network_setup();
        this.netStarted = true;
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                boolean bl = false;
                try {
                    while (!bl) {
                        try {
                            FDB fDB = FDB.this;
                            synchronized (fDB) {
                                if (FDB.this.netStopped) {
                                    return;
                                }
                            }
                            FDB.this.netRunning.acquire();
                            bl = true;
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    try {
                        FDB.this.Network_run();
                        return;
                    }
                    catch (Throwable throwable) {
                        System.err.println("Unhandled error in FoundationDB network thread: " + throwable.getMessage());
                        return;
                    }
                }
                finally {
                    if (bl) {
                        FDB.this.netRunning.release();
                    }
                    FDB fDB = FDB.this;
                    synchronized (fDB) {
                        FDB.this.netStopped = true;
                    }
                }
            }
        });
    }

    private synchronized boolean isConnected() {
        return this.netStarted && !this.netStopped;
    }

    public synchronized void stopNetwork() throws FDBException {
        if (!this.netStarted || this.netStopped) {
            this.netStopped = true;
            return;
        }
        this.Network_stop();
        this.netStarted = true;
        this.netStopped = true;
        while (true) {
            try {
                this.netRunning.acquire();
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    static native void Select_API_version(int var0) throws FDBException;

    private native void Network_setOption(int var1, byte[] var2) throws FDBException;

    private native void Network_setup() throws FDBException;

    private native void Network_run() throws FDBException;

    private native void Network_stop() throws FDBException;

    private native long Cluster_create(String var1);

    static {
        try {
            JNIUtil.loadLibrary("fdb_c");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        JNIUtil.loadLibrary("fdb_java");
    }

    class DaemonThreadFactory
    implements ThreadFactory {
        private final ThreadFactory factory;

        public DaemonThreadFactory(ThreadFactory threadFactory) {
            this.factory = threadFactory;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = this.factory.newThread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    }
}

