/*
 * Decompiled with CFR 0.152.
 */
package com.foundationdb;

import com.foundationdb.Database;
import com.foundationdb.DatabaseOptions;
import com.foundationdb.DefaultDisposableImpl;
import com.foundationdb.Disposable;
import com.foundationdb.FDBException;
import com.foundationdb.FDBTransaction;
import com.foundationdb.OptionConsumer;
import com.foundationdb.ReadTransaction;
import com.foundationdb.Transaction;
import com.foundationdb.async.AsyncUtil;
import com.foundationdb.async.Function;
import com.foundationdb.async.Future;
import com.foundationdb.async.PartialFunction;
import com.foundationdb.async.PartialFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

class FDBDatabase
extends DefaultDisposableImpl
implements Database,
Disposable,
OptionConsumer {
    private Executor executor;
    private DatabaseOptions options;

    protected FDBDatabase(long l, Executor executor) {
        super(l);
        this.executor = executor;
        this.options = new DatabaseOptions(this);
    }

    @Override
    public DatabaseOptions options() {
        return this.options;
    }

    @Override
    public <T> T run(Function<? super Transaction, T> function) {
        Transaction transaction = this.createTransaction();
        while (true) {
            try {
                T t = function.apply(transaction);
                transaction.commit().get();
                T t2 = t;
                return t2;
            }
            catch (RuntimeException runtimeException) {
                transaction.onError(runtimeException).get();
                continue;
            }
            break;
        }
        finally {
            transaction.dispose();
        }
    }

    @Override
    public <T> T read(Function<? super ReadTransaction, T> function) {
        return this.run(function);
    }

    @Override
    public <T> T run(PartialFunction<? super Transaction, T> partialFunction) throws Exception {
        Transaction transaction = this.createTransaction();
        while (true) {
            try {
                T t = partialFunction.apply(transaction);
                transaction.commit().get();
                T t2 = t;
                return t2;
            }
            catch (RuntimeException runtimeException) {
                transaction.onError(runtimeException).get();
                continue;
            }
            break;
        }
        finally {
            transaction.dispose();
        }
    }

    @Override
    public <T> T read(PartialFunction<? super ReadTransaction, T> partialFunction) throws Exception {
        return this.run(partialFunction);
    }

    @Override
    public <T> Future<T> runAsync(final Function<? super Transaction, Future<T>> function) {
        final Transaction transaction = this.createTransaction();
        final AtomicReference atomicReference = new AtomicReference();
        return AsyncUtil.whileTrue(new Function<Void, Future<Boolean>>(){

            @Override
            public Future<Boolean> apply(Void void_) {
                Future future = AsyncUtil.applySafely(function, transaction);
                return future.flatMap(new Function<T, Future<Boolean>>(){

                    @Override
                    public Future<Boolean> apply(final T t) {
                        return transaction.commit().map(new Function<Void, Boolean>(){

                            @Override
                            public Boolean apply(Void void_) {
                                atomicReference.set(t);
                                return false;
                            }
                        });
                    }
                }).rescueRuntime(new Function<RuntimeException, Future<Boolean>>(){

                    @Override
                    public Future<Boolean> apply(RuntimeException runtimeException) {
                        return AsyncUtil.tag(transaction.onError(runtimeException), Boolean.valueOf(true));
                    }
                });
            }
        }).map(new Function<Void, T>(){

            @Override
            public T apply(Void void_) {
                transaction.dispose();
                return atomicReference.get();
            }
        });
    }

    @Override
    public <T> Future<T> readAsync(Function<? super ReadTransaction, Future<T>> function) {
        return this.runAsync(function);
    }

    @Override
    public <T> PartialFuture<T> runAsync(final PartialFunction<? super Transaction, ? extends PartialFuture<T>> partialFunction) {
        final Transaction transaction = this.createTransaction();
        final AtomicReference atomicReference = new AtomicReference();
        return AsyncUtil.whileTrue((PartialFunction<Void, ? extends PartialFuture<Boolean>>)new Function<Void, PartialFuture<Boolean>>(){

            @Override
            public PartialFuture<Boolean> apply(Void void_) {
                PartialFuture partialFuture = AsyncUtil.applySafely(partialFunction, transaction);
                return partialFuture.flatMap(new Function<T, Future<Boolean>>(){

                    @Override
                    public Future<Boolean> apply(final T t) {
                        return transaction.commit().map(new Function<Void, Boolean>(){

                            @Override
                            public Boolean apply(Void void_) {
                                atomicReference.set(t);
                                return false;
                            }
                        });
                    }
                }).rescue(new Function<Exception, PartialFuture<Boolean>>(){

                    @Override
                    public PartialFuture<Boolean> apply(Exception exception) {
                        return AsyncUtil.tag(transaction.onError(exception), Boolean.valueOf(true));
                    }
                });
            }
        }).map(new Function<Void, T>(){

            @Override
            public T apply(Void void_) {
                transaction.dispose();
                return atomicReference.get();
            }
        });
    }

    @Override
    public <T> PartialFuture<T> readAsync(PartialFunction<? super ReadTransaction, ? extends PartialFuture<T>> partialFunction) {
        return this.runAsync(partialFunction);
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Transaction createTransaction() {
        this.pointerReadLock.lock();
        try {
            FDBTransaction fDBTransaction = new FDBTransaction(this.Database_createTransaction(this.getPtr()), this, this.executor);
            return fDBTransaction;
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOption(int n, byte[] byArray) {
        this.pointerReadLock.lock();
        try {
            this.Database_setOption(this.getPtr(), n, byArray);
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    @Override
    protected void disposeInternal(long l) {
        this.Database_dispose(l);
    }

    private native long Database_createTransaction(long var1);

    private native void Database_dispose(long var1);

    private native void Database_setOption(long var1, int var3, byte[] var4) throws FDBException;
}

