/*
 * Decompiled with CFR 0.152.
 */
package com.foundationdb.directory;

import com.foundationdb.Range;
import com.foundationdb.directory.DirectoryLayer;
import com.foundationdb.directory.DirectorySubspace;
import com.foundationdb.subspace.Subspace;
import com.foundationdb.tuple.ByteArrayUtil;
import com.foundationdb.tuple.Tuple;
import java.util.List;

class DirectoryPartition
extends DirectorySubspace {
    private final DirectoryLayer parentDirectoryLayer;

    DirectoryPartition(List<String> list, byte[] byArray, DirectoryLayer directoryLayer) {
        super(list, byArray, new DirectoryLayer(new Subspace(ByteArrayUtil.join(byArray, DirectoryLayer.DEFAULT_NODE_SUBSPACE_PREFIX)), new Subspace(byArray)), DirectoryLayer.PARTITION_LAYER);
        this.getDirectoryLayer().setPath(list);
        this.parentDirectoryLayer = directoryLayer;
    }

    @Override
    public Subspace get(Object object) {
        throw new UnsupportedOperationException("Cannot open subspace in the root of a directory partition.");
    }

    @Override
    public Subspace get(Tuple tuple) {
        throw new UnsupportedOperationException("Cannot open subspace in the root of a directory partition.");
    }

    @Override
    public byte[] getKey() {
        throw new UnsupportedOperationException("Cannot get key for the root of a directory partition.");
    }

    @Override
    public byte[] pack() {
        throw new UnsupportedOperationException("Cannot pack keys using the root of a directory partition.");
    }

    @Override
    public byte[] pack(Object object) {
        throw new UnsupportedOperationException("Cannot pack keys using the root of a directory partition.");
    }

    @Override
    public byte[] pack(Tuple tuple) {
        throw new UnsupportedOperationException("Cannot pack keys using the root of a directory partition.");
    }

    @Override
    public Tuple unpack(byte[] byArray) {
        throw new UnsupportedOperationException("Cannot unpack keys using the root of a directory partition.");
    }

    @Override
    public Range range() {
        throw new UnsupportedOperationException("Cannot get range for the root of a directory partition.");
    }

    @Override
    public Range range(Tuple tuple) {
        throw new UnsupportedOperationException("Cannot get range for the root of a directory partition.");
    }

    @Override
    public boolean contains(byte[] byArray) {
        throw new UnsupportedOperationException("Cannot check whether a key belongs to the root of a directory partition.");
    }

    @Override
    public Subspace subspace(Tuple tuple) {
        throw new UnsupportedOperationException("Cannot open subspace in the root of a directory partition.");
    }

    @Override
    DirectoryLayer getLayerForPath(List<String> list) {
        if (list.size() == 0) {
            return this.parentDirectoryLayer;
        }
        return this.getDirectoryLayer();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DirectoryPartition directoryPartition = (DirectoryPartition)object;
        return (this.getPath() == directoryPartition.getPath() || this.getPath() == directoryPartition.getPath()) && this.parentDirectoryLayer.equals(directoryPartition.parentDirectoryLayer) && super.equals(object);
    }
}

