/*
 * Decompiled with CFR 0.152.
 */
package com.foundationdb.tuple;

import com.foundationdb.tuple.ByteArrayUtil;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

class TupleUtil {
    private static final byte nil = 0;
    private static final byte[] nil_rep = new byte[]{0, -1};
    private static final BigInteger[] size_limits = new BigInteger[9];
    private static final Charset UTF8;

    public static byte[] join(List<byte[]> list) {
        return ByteArrayUtil.join(null, list);
    }

    static byte[] encode(Object object) {
        if (object == null) {
            return new byte[]{0};
        }
        if (object instanceof byte[]) {
            return TupleUtil.encode((byte[])object);
        }
        if (object instanceof String) {
            return TupleUtil.encode((String)object);
        }
        if (object instanceof Number) {
            return TupleUtil.encode(((Number)object).longValue());
        }
        throw new IllegalArgumentException("Unsupported data type: " + object.getClass().getName());
    }

    static byte[] encode(byte[] byArray) {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(3);
        arrayList.add(new byte[]{1});
        arrayList.add(ByteArrayUtil.replace(byArray, new byte[]{0}, nil_rep));
        arrayList.add(new byte[]{0});
        return ByteArrayUtil.join(null, arrayList);
    }

    static byte[] encode(String string) {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(3);
        arrayList.add(new byte[]{2});
        arrayList.add(ByteArrayUtil.replace(string.getBytes(UTF8), new byte[]{0}, nil_rep));
        arrayList.add(new byte[]{0});
        return ByteArrayUtil.join(null, arrayList);
    }

    static byte[] encode(long l) {
        if (l == 0L) {
            return new byte[]{20};
        }
        if (l > 0L) {
            int n = ByteArrayUtil.bisectLeft(size_limits, BigInteger.valueOf(l));
            assert (n <= size_limits.length);
            byte[] byArray = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN).putLong(l).array();
            byte[] byArray2 = new byte[n + 1];
            byArray2[0] = (byte)(20 + n);
            System.arraycopy(byArray, byArray.length - n, byArray2, 1, n);
            return byArray2;
        }
        BigInteger bigInteger = BigInteger.valueOf(l);
        int n = ByteArrayUtil.bisectLeft(size_limits, bigInteger.negate());
        assert (n >= 0 && n < size_limits.length);
        long l2 = size_limits[n].add(bigInteger).longValue();
        byte[] byArray = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN).putLong(l2).array();
        byte[] byArray3 = new byte[n + 1];
        byArray3[0] = (byte)(20 - n);
        System.arraycopy(byArray, byArray.length - n, byArray3, 1, n);
        return byArray3;
    }

    static byte[] encode(Integer n) {
        return TupleUtil.encode(n.longValue());
    }

    static DecodeResult decode(byte[] byArray, int n, int n2) {
        byte by = byArray[n];
        int n3 = n + 1;
        if (by == 0) {
            return new DecodeResult(n3, null);
        }
        if (by == 1) {
            int n4 = ByteArrayUtil.findTerminator(byArray, (byte)0, (byte)-1, n3, n2);
            byte[] byArray2 = ByteArrayUtil.replace(byArray, n3, n4 - n3, nil_rep, new byte[]{0});
            return new DecodeResult(n4 + 1, byArray2);
        }
        if (by == 2) {
            int n5 = ByteArrayUtil.findTerminator(byArray, (byte)0, (byte)-1, n3, n2);
            byte[] byArray3 = ByteArrayUtil.replace(byArray, n3, n5 - n3, nil_rep, new byte[]{0});
            String string = new String(byArray3, UTF8);
            return new DecodeResult(n5 + 1, string);
        }
        if (by >= 12 && by <= 28) {
            byte[] byArray4 = new byte[9];
            Arrays.fill(byArray4, (byte)0);
            boolean bl = by >= 20;
            int n6 = bl ? by - 20 : 20 - by;
            int n7 = n3 + n6;
            if (byArray.length < n7) {
                throw new RuntimeException("Invalid tuple (possible truncation)");
            }
            System.arraycopy(byArray, n3, byArray4, 9 - n6, n6);
            if (!bl) {
                for (int i = 9 - n6; i < 9; ++i) {
                    byArray4[i] = ~byArray4[i];
                }
            }
            BigInteger bigInteger = new BigInteger(byArray4);
            if (!bl) {
                bigInteger = bigInteger.negate();
            }
            if (bigInteger.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) < 0 || bigInteger.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
                throw new RuntimeException("Value out of range for type long.");
            }
            return new DecodeResult(n7, bigInteger.longValue());
        }
        throw new IllegalArgumentException("Unknown tuple data type " + by + " at index " + n);
    }

    static List<Object> unpack(byte[] byArray, int n, int n2) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        int n3 = n;
        int n4 = n + n2;
        while (n3 < byArray.length) {
            DecodeResult decodeResult = TupleUtil.decode(byArray, n3, n4);
            linkedList.add(decodeResult.o);
            n3 = decodeResult.end;
        }
        return linkedList;
    }

    static byte[] pack(List<Object> list) {
        if (list.size() == 0) {
            return new byte[0];
        }
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(list.size());
        for (Object object : list) {
            byte[] byArray = TupleUtil.encode(object);
            arrayList.add(byArray);
        }
        return ByteArrayUtil.join(null, arrayList);
    }

    public static void main(String[] stringArray) {
        byte[] byArray;
        try {
            byArray = TupleUtil.encode(4L);
            assert (4 == (Integer)TupleUtil.decode((byte[])byArray, (int)0, (int)byArray.length).o);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Error " + exception.getMessage());
        }
        try {
            byArray = TupleUtil.encode("\u021aest \u0218tring");
            String string = (String)TupleUtil.decode((byte[])byArray, (int)0, (int)byArray.length).o;
            System.out.println("contents -> " + string);
            assert ("\u021aest \u0218tring" == string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Error " + exception.getMessage());
        }
    }

    private TupleUtil() {
    }

    static {
        for (int i = 0; i < 9; ++i) {
            TupleUtil.size_limits[i] = BigInteger.ONE.shiftLeft(i * 8).subtract(BigInteger.ONE);
        }
        UTF8 = Charset.forName("UTF-8");
    }

    static class DecodeResult {
        final int end;
        final Object o;

        DecodeResult(int n, Object object) {
            this.end = n;
            this.o = object;
        }
    }
}

