/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.http;

import com.franz.agraph.http.AGProtocol;
import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.http.handler.AGErrorHandler;
import com.franz.agraph.http.handler.AGMethodRetryHandler;
import com.franz.agraph.http.handler.AGResponseHandler;
import com.franz.agraph.http.handler.AGStringHandler;
import com.franz.agraph.http.handler.AGTQRHandler;
import com.franz.agraph.repository.AGValueFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.eclipse.rdf4j.http.protocol.UnauthorizedException;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.impl.TupleQueryResultBuilder;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AGHTTPClient
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(AGHTTPClient.class);
    public static final String PROP_HTTP_NUM_RETRIES = "com.franz.agraph.http.numRetries";
    private static final int DEFAULT_HTTP_NUM_RETRIES = 1;
    private final String serverURL;
    private final HttpClient httpClient;
    private AuthScope authScope;
    private String masqueradeAsUser;
    private boolean isClosed = false;
    private HttpConnectionManager mManager = null;
    private final AGMethodRetryHandler retryHandler = new AGMethodRetryHandler();
    private final int httpNumRetries;

    private AGHTTPClient(String serverURL, HttpClient client) {
        this.serverURL = serverURL.replaceAll("/$", "");
        this.httpClient = client;
        this.httpNumRetries = Integer.parseInt(System.getProperty(PROP_HTTP_NUM_RETRIES, "1"));
        if (logger.isDebugEnabled()) {
            logger.debug("connect: " + serverURL + " " + client);
        }
    }

    public AGHTTPClient(String serverURL) {
        this(serverURL, (HttpConnectionManager)((MultiThreadedHttpConnectionManager)null));
    }

    public AGHTTPClient(String serverURL, HttpConnectionManager manager) {
        this(serverURL, new HttpClient(manager == null ? AGHTTPClient.createManager() : manager));
        if (manager == null) {
            this.mManager = this.getHttpClient().getHttpConnectionManager();
        }
    }

    public AGHTTPClient(String serverURL, HttpConnectionManagerParams params) {
        this(serverURL, AGHTTPClient.createManager(params));
    }

    private static HttpConnectionManager createManager() {
        return AGHTTPClient.createManager(null);
    }

    private static HttpConnectionManager createManager(HttpConnectionManagerParams params) {
        MultiThreadedHttpConnectionManager manager = new MultiThreadedHttpConnectionManager();
        if (params == null) {
            params = new HttpConnectionManagerParams();
        }
        params.setDefaultMaxConnectionsPerHost(Integer.MAX_VALUE);
        params.setMaxTotalConnections(Integer.MAX_VALUE);
        manager.setParams(params);
        return manager;
    }

    public String toString() {
        return "{" + super.toString() + " " + this.serverURL + " " + this.httpClient + "}";
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void post(String url, Header[] headers, NameValuePair[] params, RequestEntity requestEntity, AGResponseHandler handler) throws AGHttpException {
        PostMethod post = new PostMethod(url);
        this.setDoAuthentication((HttpMethod)post);
        for (Header header : headers) {
            post.addRequestHeader(header);
        }
        if (System.getProperty("com.franz.agraph.http.useGzip", "true").equals("true")) {
            post.addRequestHeader("Accept-encoding", "gzip");
        }
        Header contentType = post.getRequestHeader("Content-Type");
        if (requestEntity == null && (contentType == null || contentType.getValue().contains("application/x-www-form-urlencoded"))) {
            post.setRequestBody(params);
        } else {
            post.setQueryString(params);
            post.setRequestEntity(requestEntity);
        }
        this.executeMethod(url, (HttpMethod)post, handler);
    }

    private boolean is2xx(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    public void get(String url, Header[] headers, NameValuePair[] params, AGResponseHandler handler) throws AGHttpException {
        int numTries = this.httpNumRetries + 1;
        for (int i = 0; i < numTries; ++i) {
            boolean mightRetry;
            GetMethod get = new GetMethod(url);
            this.setDoAuthentication((HttpMethod)get);
            if (headers != null) {
                for (Header header : headers) {
                    get.addRequestHeader(header);
                }
            }
            if (System.getProperty("com.franz.agraph.http.useGzip", "true").equals("true")) {
                get.addRequestHeader("Accept-encoding", "gzip");
            }
            if (params != null) {
                get.setQueryString(params);
            }
            boolean bl = mightRetry = i < numTries - 1;
            if (this.executeMethod(url, (HttpMethod)get, handler, mightRetry) != ExecuteResult.SUCCESS) continue;
            return;
        }
        throw new AGHttpException("GET request failed (unreachable)");
    }

    public void delete(String url, Header[] headers, NameValuePair[] params, AGResponseHandler handler) throws AGHttpException {
        DeleteMethod delete = new DeleteMethod(url);
        this.setDoAuthentication((HttpMethod)delete);
        if (headers != null) {
            for (Header header : headers) {
                delete.addRequestHeader(header);
            }
        }
        if (params != null) {
            delete.setQueryString(params);
        }
        this.executeMethod(url, (HttpMethod)delete, handler);
    }

    public void put(String url, Header[] headers, NameValuePair[] params, RequestEntity requestEntity, AGResponseHandler handler) throws AGHttpException {
        PutMethod put = new PutMethod(url);
        this.setDoAuthentication((HttpMethod)put);
        if (headers != null) {
            for (Header header : headers) {
                put.addRequestHeader(header);
            }
        }
        if (params != null) {
            put.setQueryString(params);
        }
        if (requestEntity != null) {
            put.setRequestEntity(requestEntity);
        }
        this.executeMethod(url, (HttpMethod)put, handler);
    }

    private void executeMethod(String url, HttpMethod method, AGResponseHandler handler) {
        this.executeMethod(url, method, handler, false);
    }

    private ExecuteResult executeMethod(String url, HttpMethod method, AGResponseHandler handler, boolean returnRetryOn408) throws AGHttpException {
        method.getParams().setParameter("http.method.retry-handler", (Object)this.retryHandler);
        try {
            int httpCode = this.getHttpClient().executeMethod(method);
            if (httpCode == 200) {
                if (handler != null) {
                    handler.handleResponse(method);
                }
                ExecuteResult executeResult = ExecuteResult.SUCCESS;
                return executeResult;
            }
            if (httpCode == 401) {
                throw new AGHttpException((Exception)((Object)new UnauthorizedException()));
            }
            if (returnRetryOn408 && httpCode == 408) {
                ExecuteResult executeResult = ExecuteResult.RETRY;
                return executeResult;
            }
            if (this.is2xx(httpCode)) {
                ExecuteResult executeResult = ExecuteResult.SUCCESS;
                return executeResult;
            }
            try {
                AGErrorHandler errHandler = new AGErrorHandler();
                errHandler.handleResponse(method);
                throw errHandler.getResult();
            }
            catch (IOException e) {
                throw new AGHttpException(e);
            }
        }
        finally {
            if (handler == null || handler.releaseConnection()) {
                this.releaseConnection(method);
            }
        }
    }

    public void setUsernameAndPassword(String username, String password) {
        if (username != null && password != null) {
            logger.debug("Setting username '{}' and password for server at {}.", (Object)username, (Object)this.serverURL);
            try {
                URL server = new URL(this.serverURL);
                this.authScope = new AuthScope(server.getHost(), -1);
                this.httpClient.getState().setCredentials(this.authScope, (Credentials)new UsernamePasswordCredentials(username, password));
                this.httpClient.getParams().setAuthenticationPreemptive(true);
            }
            catch (MalformedURLException e) {
                logger.warn("Unable to set username and password for malformed URL " + this.serverURL, (Throwable)e);
            }
        } else {
            this.authScope = null;
            this.httpClient.getState().clearCredentials();
            this.httpClient.getParams().setAuthenticationPreemptive(false);
        }
    }

    public String[] getUsernameAndPassword() {
        String[] res = new String[2];
        UsernamePasswordCredentials cred = (UsernamePasswordCredentials)this.httpClient.getState().getCredentials(this.authScope);
        res[0] = cred.getUserName();
        res[1] = cred.getPassword();
        return res;
    }

    public void setMasqueradeAsUser(String user) {
        this.masqueradeAsUser = user;
    }

    protected final void setDoAuthentication(HttpMethod method) {
        if (this.authScope != null && this.httpClient.getState().getCredentials(this.authScope) != null) {
            method.setDoAuthentication(true);
        }
        if (this.masqueradeAsUser != null) {
            method.addRequestHeader(new Header("x-masquerade-as-user", this.masqueradeAsUser));
        }
        method.addRequestHeader(new Header("Connection", "keep-alive"));
    }

    protected final void releaseConnection(HttpMethod method) {
        try {
            InputStream responseStream = method.getResponseBodyAsStream();
            if (responseStream != null) {
                while (responseStream.read() >= 0) {
                }
            }
            method.releaseConnection();
        }
        catch (IOException e) {
            logger.warn("I/O error upon releasing connection", (Throwable)e);
        }
    }

    public void putCatalog(String catalogURL) throws AGHttpException {
        if (logger.isDebugEnabled()) {
            logger.debug("putCatalog: " + catalogURL);
        }
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        this.put(catalogURL, headers, params, null, null);
    }

    public void deleteCatalog(String catalogURL) throws AGHttpException {
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        this.delete(catalogURL, headers, params, null);
    }

    public void putRepository(String repositoryURL) throws AGHttpException {
        if (logger.isDebugEnabled()) {
            logger.debug("putRepository: " + repositoryURL);
        }
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("override", "false")};
        this.put(repositoryURL, headers, params, null, null);
    }

    public void deleteRepository(String repositoryURL) throws AGHttpException {
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        this.delete(repositoryURL, headers, params, null);
    }

    public TupleQueryResult getTupleQueryResult(String url) throws AGHttpException {
        Header[] headers = new Header[]{new Header("Accept", TupleQueryResultFormat.SPARQL.getDefaultMIMEType())};
        NameValuePair[] params = new NameValuePair[]{};
        TupleQueryResultBuilder builder = new TupleQueryResultBuilder();
        AGTQRHandler handler = new AGTQRHandler(TupleQueryResultFormat.SPARQL, (TupleQueryResultHandler)builder, new AGValueFactory(null), false);
        this.get(url, headers, params, handler);
        return builder.getQueryResult();
    }

    public String[] getBlankNodes(String repositoryURL, int amount) throws AGHttpException {
        String url = AGProtocol.getBlankNodesURL(repositoryURL);
        Header[] headers = new Header[]{};
        NameValuePair[] data = new NameValuePair[]{new NameValuePair("amount", Integer.toString(amount))};
        AGStringHandler handler = new AGStringHandler();
        this.post(url, headers, data, null, handler);
        return handler.getResult().split("\n");
    }

    public String getString(String url) throws AGHttpException {
        Header[] headers = new Header[]{};
        NameValuePair[] data = new NameValuePair[]{};
        AGStringHandler handler = new AGStringHandler();
        this.get(url, headers, data, handler);
        return handler.getResult();
    }

    public String[] getStringArray(String url) throws AGHttpException {
        String result = this.getString(url);
        if (result.equals("")) {
            return new String[0];
        }
        return result.split("\n");
    }

    public List<String> getListOfStrings(String url) throws AGHttpException {
        return Arrays.asList(this.getStringArray(url));
    }

    public String openSession(String spec, boolean autocommit) throws AGHttpException {
        String url = AGProtocol.getSessionURL(this.serverURL);
        Header[] headers = new Header[]{};
        NameValuePair[] data = new NameValuePair[]{new NameValuePair("store", spec), new NameValuePair("autoCommit", Boolean.toString(autocommit)), new NameValuePair("lifetime", Long.toString(3600L))};
        AGStringHandler handler = new AGStringHandler();
        this.post(url, headers, data, null, handler);
        return handler.getResult();
    }

    @Override
    public void close() {
        logger.debug("close: " + this.serverURL + " " + this.mManager);
        if (this.mManager instanceof MultiThreadedHttpConnectionManager) {
            ((MultiThreadedHttpConnectionManager)this.mManager).shutdown();
            this.mManager = null;
        }
        this.isClosed = true;
    }

    boolean isClosed() {
        return this.isClosed;
    }

    public String[] generateURIs(String repositoryURL, String namespace, int amount) throws AGHttpException {
        String url = repositoryURL + "/encodedIds";
        Header[] headers = new Header[]{};
        NameValuePair[] data = new NameValuePair[]{new NameValuePair("prefix", namespace), new NameValuePair("amount", Integer.toString(amount))};
        AGStringHandler handler = new AGStringHandler();
        this.post(url, headers, data, null, handler);
        return handler.getResult().split("\n");
    }

    private static enum ExecuteResult {
        SUCCESS,
        RETRY;

    }
}

