/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.http.handler;

import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.http.handler.AGResponseHandler;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.HttpMethod;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultFormat;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultParser;
import org.eclipse.rdf4j.query.resultio.QueryResultFormat;
import org.eclipse.rdf4j.query.resultio.QueryResultIO;
import org.eclipse.rdf4j.query.resultio.QueryResultParseException;

public class AGBQRHandler
extends AGResponseHandler {
    private boolean result;

    public AGBQRHandler() {
        super(BooleanQueryResultFormat.TEXT.getDefaultMIMEType());
    }

    @Override
    public void handleResponse(HttpMethod method) throws IOException, AGHttpException {
        String mimeType = this.getResponseMIMEType(method);
        if (!mimeType.equals(this.getRequestMIMEType())) {
            throw new AGHttpException("unexpected response MIME type: " + mimeType);
        }
        InputStream response = AGBQRHandler.getInputStream(method);
        try {
            BooleanQueryResultFormat format = BooleanQueryResultFormat.TEXT;
            BooleanQueryResultParser parser = QueryResultIO.createBooleanParser((QueryResultFormat)format);
            this.result = parser.parse(response);
        }
        catch (QueryResultParseException e) {
            throw new AGHttpException((Exception)((Object)e));
        }
    }

    public boolean getResult() {
        return this.result;
    }
}

