/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.http.handler;

import com.franz.agraph.http.AGHttpRepoClient;
import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.http.handler.AGResponseHandler;
import com.franz.agraph.repository.AGValueFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.apache.commons.httpclient.HttpMethod;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;

public class AGRDFHandler
extends AGResponseHandler {
    private final RDFFormat format;
    private final RDFHandler rdfhandler;
    private final AGValueFactory vf;

    public AGRDFHandler(RDFFormat format, RDFHandler rdfhandler, AGValueFactory vf, boolean recoverExternalBNodes) {
        super(format.getDefaultMIMEType());
        this.format = format;
        this.rdfhandler = recoverExternalBNodes ? this.recoverBNodesRDFHandler(rdfhandler) : rdfhandler;
        this.vf = vf;
    }

    @Override
    public void handleResponse(HttpMethod method) throws IOException, AGHttpException {
        String mimeType = this.getResponseMIMEType(method);
        if (!mimeType.equals(this.getRequestMIMEType())) {
            throw new AGHttpException("unexpected response MIME type: " + mimeType);
        }
        InputStream response = AGRDFHandler.getInputStream(method);
        InputStreamReader reader = new InputStreamReader(response, StandardCharsets.UTF_8);
        try {
            RDFParser parser = Rio.createParser((RDFFormat)this.format, (ValueFactory)this.vf);
            parser.setPreserveBNodeIDs(true);
            parser.setRDFHandler(this.rdfhandler);
            parser.parse((Reader)reader, method.getURI().getURI());
        }
        catch (RDFParseException e) {
            throw new AGHttpException((Exception)((Object)e));
        }
        catch (RDFHandlerException e) {
            throw new AGHttpException((Exception)((Object)e));
        }
    }

    private RDFHandler recoverBNodesRDFHandler(final RDFHandler handler) {
        return new RDFHandler(){

            public void startRDF() throws RDFHandlerException {
                handler.startRDF();
            }

            public void endRDF() throws RDFHandlerException {
                handler.endRDF();
            }

            public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
                handler.handleNamespace(prefix, uri);
            }

            public void handleStatement(Statement st) throws RDFHandlerException {
                Resource s = AGHttpRepoClient.getApplicationResource(st.getSubject(), AGRDFHandler.this.vf);
                Value o = AGHttpRepoClient.getApplicationValue(st.getObject(), AGRDFHandler.this.vf);
                Resource c = AGHttpRepoClient.getApplicationResource(st.getContext(), AGRDFHandler.this.vf);
                st = AGRDFHandler.this.vf.createStatement(s, st.getPredicate(), o, c);
                handler.handleStatement(st);
            }

            public void handleComment(String comment) throws RDFHandlerException {
                handler.handleComment(comment);
            }
        };
    }
}

