/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.http.handler;

import com.franz.agraph.http.AGHttpRepoClient;
import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.http.handler.AGResponseHandler;
import com.franz.agraph.repository.AGValueFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.httpclient.HttpMethod;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AGTQRStreamer
extends AGResponseHandler {
    private static final XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
    final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AGValueFactory vf;
    private XMLStreamReader xml;
    private HttpMethod method;

    public AGTQRStreamer(TupleQueryResultFormat format, AGValueFactory vf) {
        super(format.getDefaultMIMEType());
        this.vf = vf;
    }

    @Override
    public String getRequestMIMEType() {
        return TupleQueryResultFormat.SPARQL.getDefaultMIMEType();
    }

    @Override
    public boolean releaseConnection() {
        return false;
    }

    @Override
    public void handleResponse(HttpMethod method) throws IOException, AGHttpException {
        this.method = method;
        try {
            this.xml = xmlInputFactory.createXMLStreamReader(AGResponseHandler.getInputStream(method));
        }
        catch (XMLStreamException e) {
            throw new AGHttpException(e);
        }
    }

    public TupleQueryResult getResult() {
        return new Result();
    }

    class Result
    implements TupleQueryResult {
        private List<String> bindingNames;
        private MapBindingSet next = null;
        private boolean closed = false;

        Result() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public List<String> getBindingNames() {
            if (this.bindingNames != null) return this.bindingNames;
            try {
                block6: while (AGTQRStreamer.this.xml.hasNext()) {
                    switch (AGTQRStreamer.this.xml.next()) {
                        case 1: {
                            if ("head".equals(AGTQRStreamer.this.xml.getLocalName())) {
                                this.bindingNames = new ArrayList<String>();
                                break;
                            }
                            if ("variable".equals(AGTQRStreamer.this.xml.getLocalName())) {
                                for (int i = 0; i < AGTQRStreamer.this.xml.getAttributeCount(); ++i) {
                                    if (!"name".equals(AGTQRStreamer.this.xml.getAttributeLocalName(i))) continue;
                                    this.bindingNames.add(AGTQRStreamer.this.xml.getAttributeValue(i));
                                }
                                continue block6;
                            }
                            if ("sparql".equals(AGTQRStreamer.this.xml.getLocalName())) continue block6;
                            throw new RuntimeException("Unexpected tag: " + AGTQRStreamer.this.xml.getLocalName());
                        }
                        case 2: {
                            if (!"head".equals(AGTQRStreamer.this.xml.getLocalName())) break;
                            return this.bindingNames;
                        }
                    }
                }
                return this.bindingNames;
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean hasNext() throws QueryEvaluationException {
            if (this.next == null) {
                if (this.closed) {
                    return false;
                }
                this.getBindingNames();
                try {
                    String bindingName = null;
                    while (AGTQRStreamer.this.xml.hasNext()) {
                        int event = AGTQRStreamer.this.xml.next();
                        if (AGTQRStreamer.this.xml.isStartElement()) {
                            String name = AGTQRStreamer.this.xml.getLocalName();
                            if ("result".equals(name)) {
                                this.next = new MapBindingSet(this.bindingNames.size());
                                continue;
                            }
                            if ("results".equals(AGTQRStreamer.this.xml.getLocalName())) continue;
                            if ("binding".equals(name)) {
                                for (int i = 0; i < AGTQRStreamer.this.xml.getAttributeCount(); ++i) {
                                    if (!"name".equals(AGTQRStreamer.this.xml.getAttributeLocalName(i))) continue;
                                    bindingName = AGTQRStreamer.this.xml.getAttributeValue(i);
                                }
                                continue;
                            }
                            if ("literal".equals(name)) {
                                String lang = null;
                                String datatype = null;
                                for (int i = 0; i < AGTQRStreamer.this.xml.getAttributeCount(); ++i) {
                                    if ("lang".equals(AGTQRStreamer.this.xml.getAttributeLocalName(i)) && "http://www.w3.org/XML/1998/namespace".equals(AGTQRStreamer.this.xml.getAttributeNamespace(i))) {
                                        lang = AGTQRStreamer.this.xml.getAttributeValue(i);
                                        continue;
                                    }
                                    if (!"datatype".equals(AGTQRStreamer.this.xml.getAttributeLocalName(i))) continue;
                                    datatype = AGTQRStreamer.this.xml.getAttributeValue(i);
                                }
                                String text = AGTQRStreamer.this.xml.getElementText();
                                Literal value = null;
                                if (datatype != null) {
                                    try {
                                        value = AGTQRStreamer.this.vf.createLiteral(text, AGTQRStreamer.this.vf.createIRI(datatype));
                                    }
                                    catch (IllegalArgumentException e) {
                                        throw new QueryEvaluationException(e.getMessage(), (Throwable)e);
                                    }
                                } else {
                                    value = lang != null ? AGTQRStreamer.this.vf.createLiteral(text, lang) : AGTQRStreamer.this.vf.createLiteral(text);
                                }
                                this.next.addBinding(bindingName, (Value)value);
                                continue;
                            }
                            if ("uri".equals(name)) {
                                this.next.addBinding(bindingName, (Value)AGHttpRepoClient.getApplicationResource((Resource)AGTQRStreamer.this.vf.createIRI(AGTQRStreamer.this.xml.getElementText()), AGTQRStreamer.this.vf));
                                continue;
                            }
                            if ("bnode".equals(name)) {
                                this.next.addBinding(bindingName, (Value)AGTQRStreamer.this.vf.createBNode(AGTQRStreamer.this.xml.getElementText()));
                                continue;
                            }
                            AGTQRStreamer.this.log.warn("unknown elem: " + name + " attrs=" + AGTQRStreamer.this.xml.getAttributeCount());
                            continue;
                        }
                        if (AGTQRStreamer.this.xml.isEndElement()) {
                            if ("result".equals(AGTQRStreamer.this.xml.getLocalName())) {
                                return this.next != null;
                            }
                            if ("results".equals(AGTQRStreamer.this.xml.getLocalName())) {
                                this.close();
                                return false;
                            }
                            if ("sparql".equals(AGTQRStreamer.this.xml.getLocalName())) {
                                this.close();
                                return false;
                            }
                            if ("binding".equals(AGTQRStreamer.this.xml.getLocalName())) continue;
                            AGTQRStreamer.this.log.warn("unknown elem end: " + AGTQRStreamer.this.xml.getLocalName());
                            continue;
                        }
                        if (event != 8) continue;
                        this.close();
                        return false;
                    }
                }
                catch (XMLStreamException e) {
                    throw new QueryEvaluationException((Throwable)e);
                }
            }
            return this.next != null;
        }

        public BindingSet next() throws QueryEvaluationException {
            if (this.hasNext()) {
                MapBindingSet curr = this.next;
                this.next = null;
                return curr;
            }
            if (this.closed) {
                throw new RuntimeException("closed");
            }
            throw new NoSuchElementException();
        }

        public void close() throws QueryEvaluationException {
            if (!this.closed) {
                this.closed = true;
                try {
                    AGTQRStreamer.this.xml.close();
                    AGTQRStreamer.this.method.getResponseBodyAsStream().close();
                    AGTQRStreamer.this.method.releaseConnection();
                }
                catch (IOException | XMLStreamException e) {
                    throw new QueryEvaluationException("I/O error closing resources", (Throwable)e);
                }
            }
        }

        public void remove() throws QueryEvaluationException {
            throw new UnsupportedOperationException();
        }
    }
}

