/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.jena;

import com.franz.agraph.jena.AGGraph;
import com.franz.agraph.jena.AGStatement;
import com.franz.agraph.repository.AGValueFactory;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.AnonId;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.impl.ModelCom;
import org.apache.jena.rdf.model.impl.StatementImpl;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.nquads.NQuadsWriter;

public class AGModel
extends ModelCom
implements Model,
Closeable {
    public AGModel(AGGraph base) {
        super((Graph)base);
    }

    public AGGraph getGraph() {
        return (AGGraph)this.graph;
    }

    public AGModel read(InputStream reader, String base) {
        return this.read(reader, base, "RDF/XML");
    }

    public AGModel read(InputStream reader, String base, String lang) {
        RDFFormat format;
        if (lang.contains("TRIPLE")) {
            format = RDFFormat.NTRIPLES;
        } else if (lang.contains("RDF")) {
            format = RDFFormat.RDFXML;
        } else if (lang.contains("TURTLE")) {
            format = RDFFormat.TURTLE;
        } else if (lang.contains("QUADS")) {
            format = RDFFormat.NQUADS;
        } else {
            throw new IllegalArgumentException("Unsupported format: " + lang + " (expected RDF/XML, N-TRIPLE, TURTLE, or NQUADS).");
        }
        try {
            this.getGraph().getConnection().add(reader, base, format, this.getGraph().getGraphContext());
        }
        catch (RDFParseException e) {
            throw new RuntimeException(e);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public Model write(OutputStream out, String lang) {
        return this.write(out, lang, "");
    }

    public Model write(OutputStream out, String lang, String base) {
        if (!lang.contains("QUADS")) {
            return super.write(out, lang, base);
        }
        NQuadsWriter writer = new NQuadsWriter(out);
        try {
            this.getGraph().getConnection().exportStatements(null, null, null, false, (RDFHandler)writer, this.getGraph().getGraphContexts());
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public Resource createResource() {
        AGValueFactory vf = this.getGraph().getConnection().getValueFactory();
        BNode blank = vf.createBNode();
        return this.createResource(new AnonId(blank.stringValue()));
    }

    public Resource createResource(AnonId id) {
        return super.createResource(id);
    }

    public AGModel add(Statement[] statements) {
        GraphUtil.add((Graph)this.getGraph(), (Triple[])StatementImpl.asTriples((Statement[])statements));
        return this;
    }

    public AGModel remove(Statement[] statements) {
        GraphUtil.delete((Graph)this.getGraph(), (Triple[])StatementImpl.asTriples((Statement[])statements));
        return this;
    }

    public AGStatement createStatement(Resource r, Property p, RDFNode o) {
        return new AGStatement(r, p, o, this);
    }

    public Statement asStatement(Triple t) {
        return AGStatement.toStatement(t, this);
    }
}

