/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.jena;

import com.franz.agraph.jena.AGGraph;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.shared.PrefixMapping;
import org.apache.xerces.util.XMLChar;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;

public class AGPrefixMapping
implements PrefixMapping {
    protected boolean locked;
    AGGraph graph;

    public AGPrefixMapping(AGGraph graph) {
        this.graph = graph;
    }

    AGGraph getGraph() {
        return this.graph;
    }

    public String expandPrefix(String prefixed) {
        int colon = prefixed.indexOf(58);
        if (colon < 0) {
            return prefixed;
        }
        String uri = this.getNsPrefixURI(prefixed.substring(0, colon));
        return uri == null ? prefixed : uri + prefixed.substring(colon + 1);
    }

    public Map<String, String> getNsPrefixMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            RepositoryResult<Namespace> result = this.getGraph().getConnection().getNamespaces();
            while (result.hasNext()) {
                Namespace ns = (Namespace)result.next();
                map.put(ns.getPrefix(), ns.getName());
            }
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    public String getNsPrefixURI(String prefix) {
        String uri = null;
        try {
            if (prefix != null) {
                uri = this.getGraph().getConnection().getNamespace(prefix);
            }
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        return uri;
    }

    public String getNsURIPrefix(String uri) {
        String prefix = null;
        try {
            RepositoryResult<Namespace> result = this.getGraph().getConnection().getNamespaces();
            while (prefix == null && result.hasNext()) {
                Namespace ns = (Namespace)result.next();
                if (!uri.equalsIgnoreCase(ns.getName())) continue;
                prefix = ns.getPrefix();
            }
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        return prefix;
    }

    public PrefixMapping lock() {
        this.locked = true;
        return this;
    }

    public boolean hasNoMappings() {
        return this.getNsPrefixMap().isEmpty();
    }

    public String qnameFor(String uri) {
        int split = Util.splitNamespaceXML((String)uri);
        String ns = uri.substring(0, split);
        String local = uri.substring(split);
        if (local.equals("")) {
            return null;
        }
        String prefix = this.getNsURIPrefix(ns);
        return prefix == null ? null : prefix + ":" + local;
    }

    public PrefixMapping removeNsPrefix(String prefix) {
        this.checkUnlocked();
        try {
            this.getGraph().getConnection().removeNamespace(prefix);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public PrefixMapping clearNsPrefixMap() {
        this.getGraph().getConnection().clearNamespaces();
        return this;
    }

    public boolean samePrefixMappingAs(PrefixMapping other) {
        return this.getNsPrefixMap().equals(other.getNsPrefixMap());
    }

    public PrefixMapping setNsPrefix(String prefix, String uri) {
        this.checkUnlocked();
        if (prefix.length() > 0 && !XMLChar.isValidNCName((String)prefix)) {
            throw new PrefixMapping.IllegalPrefixException(prefix);
        }
        if (uri == null) {
            throw new NullPointerException("null URIs are prohibited as arguments to setNsPrefix");
        }
        try {
            this.getGraph().getConnection().setNamespace(prefix, uri);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    protected void checkUnlocked() {
        if (this.locked) {
            throw new PrefixMapping.JenaLockedException((PrefixMapping)this);
        }
    }

    public PrefixMapping setNsPrefixes(PrefixMapping other) {
        return this.setNsPrefixes(other.getNsPrefixMap());
    }

    public PrefixMapping setNsPrefixes(Map<String, String> map) {
        this.checkUnlocked();
        for (String key : map.keySet()) {
            this.setNsPrefix(key, map.get(key));
        }
        return this;
    }

    public String shortForm(String uri) {
        Map<String, String> map = this.getNsPrefixMap();
        for (Map.Entry<String, String> s : map.entrySet()) {
            if (!uri.startsWith(s.getValue())) continue;
            return s.getKey() + ":" + uri.substring(s.getValue().length());
        }
        return uri;
    }

    public int numPrefixes() {
        return this.getNsPrefixMap().size();
    }

    public PrefixMapping withDefaultMappings(PrefixMapping map) {
        Map<String, String> thisMap = this.getNsPrefixMap();
        Map otherMap = map.getNsPrefixMap();
        for (String key : otherMap.keySet()) {
            String value = (String)otherMap.get(key);
            if (thisMap.containsKey(key) || thisMap.containsValue(value)) continue;
            this.setNsPrefix(key, value);
        }
        return this;
    }

    public String toString() {
        return this.toString(20);
    }

    public String toString(int max) {
        int count;
        Map<String, String> map = this.getNsPrefixMap();
        int size = map.size();
        Iterator<String> it = map.keySet().iterator();
        StringBuffer b = new StringBuffer(this.getClass().getSimpleName() + "(size: " + size + "){");
        String gap = "";
        for (count = 0; it.hasNext() && count < max; ++count) {
            b.append(gap);
            gap = ", ";
            String key = it.next();
            b.append(key + "=" + map.get(key));
        }
        if (count == max && it.hasNext()) {
            b.append(",...");
        }
        b.append("}");
        return b.toString();
    }
}

