/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.repository;

import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.http.handler.AGDownloadHandler;
import com.franz.agraph.http.handler.AGLongHandler;
import com.franz.agraph.http.handler.AGRDFHandler;
import com.franz.agraph.http.handler.AGRawStreamer;
import com.franz.agraph.repository.AGQuery;
import com.franz.agraph.repository.AGRepositoryConnection;
import java.io.File;
import java.io.InputStream;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.impl.IteratingGraphQueryResult;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;

public class AGGraphQuery
extends AGQuery
implements GraphQuery {
    public AGGraphQuery(AGRepositoryConnection con, QueryLanguage ql, String queryString, String baseURI) {
        super(con, ql, queryString, baseURI);
    }

    public GraphQueryResult evaluate() throws QueryEvaluationException {
        try {
            StatementCollector collector = new StatementCollector();
            this.evaluate((RDFHandler)collector);
            return new IteratingGraphQueryResult(collector.getNamespaces(), (Iterable)collector.getStatements());
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    public void evaluate(RDFHandler handler) throws QueryEvaluationException, RDFHandlerException {
        RDFFormat format = this.httpCon.prepareHttpRepoClient().getPreferredRDFFormat();
        this.evaluate(new AGRDFHandler(format, handler, this.httpCon.getValueFactory(), this.httpCon.prepareHttpRepoClient().getAllowExternalBlankNodeIds()));
    }

    public long count() throws QueryEvaluationException {
        AGLongHandler handler = new AGLongHandler();
        this.evaluate(handler);
        return handler.getResult();
    }

    public void download(File file, RDFFormat format) throws QueryEvaluationException {
        this.evaluate(new AGDownloadHandler(file, format));
    }

    public void download(String file, RDFFormat format) throws QueryEvaluationException {
        this.evaluate(new AGDownloadHandler(file, format));
    }

    public InputStream stream(RDFFormat format) throws QueryEvaluationException {
        AGRawStreamer handler = new AGRawStreamer(format);
        this.evaluate(handler);
        try {
            return handler.getStream();
        }
        catch (AGHttpException e) {
            throw new QueryEvaluationException((Throwable)((Object)e));
        }
    }
}

