/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.repository;

import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.http.exception.AGQueryTimeoutException;
import com.franz.agraph.http.handler.AGDownloadHandler;
import com.franz.agraph.http.handler.AGRawStreamer;
import com.franz.agraph.http.handler.AGResponseHandler;
import com.franz.agraph.http.handler.AGStringHandler;
import com.franz.agraph.repository.AGRepositoryConnection;
import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryInterruptedException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.impl.AbstractQuery;

public abstract class AGQuery
extends AbstractQuery {
    public static final String SPARQL_COVERAGE_PLANNER = "coverage";
    public static final String SPARQL_IDENTITY_PLANNER = "identity";
    public static final String RDFS_PLUS_PLUS = "rdfs++";
    public static final String RESTRICTION = "restriction";
    protected AGRepositoryConnection httpCon;
    protected QueryLanguage queryLanguage;
    protected String queryString;
    protected String baseURI;
    protected String entailmentRegime = "rdfs++";
    protected String planner;
    protected String saveName = null;
    protected boolean prepared = false;
    protected boolean checkVariables = false;
    protected int limit = -1;
    protected int offset = -1;
    protected boolean loggingEnabled = false;
    private String engine;

    public AGQuery(AGRepositoryConnection con, QueryLanguage ql, String queryString, String baseURI) {
        super.setIncludeInferred(false);
        this.httpCon = con;
        this.queryLanguage = ql;
        this.queryString = queryString;
        this.baseURI = baseURI;
        this.includeInferred = false;
    }

    public static String getFranzOptionPrefixString(String option, String value) throws URIException {
        return "PREFIX franzOption_" + option + ": <franz:" + URIUtil.encodeQuery((String)value, (String)"utf-8") + "> ";
    }

    public void setIncludeInferred(boolean includeInferred) {
        super.setIncludeInferred(includeInferred);
    }

    public String getEntailmentRegime() {
        return this.entailmentRegime;
    }

    public void setEntailmentRegime(String entailmentRegime) {
        this.entailmentRegime = entailmentRegime;
    }

    public QueryLanguage getLanguage() {
        return this.queryLanguage;
    }

    public String getQueryString() {
        long timeout = this.getMaxQueryTime();
        String timeoutPrefix = timeout > 0L ? "PREFIX franzOption_queryTimeout: <franz:" + timeout + ">     # timeout in seconds\n " : "";
        return timeoutPrefix + this.queryString;
    }

    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    public void setLoggingEnabled(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public String getPlanner() {
        return this.planner;
    }

    public void setPlanner(String planner) {
        this.planner = planner;
    }

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    synchronized void prepare() {
    }

    public void setSaveName(String name) {
        this.saveName = name;
    }

    public String getName() {
        return this.saveName;
    }

    public boolean isPrepared() {
        return this.prepared;
    }

    public void setPrepared(boolean prepared) {
        this.prepared = prepared;
    }

    protected void evaluate(AGResponseHandler handler) throws QueryEvaluationException {
        this.evaluate(false, handler);
    }

    protected void evaluate(boolean analyzeOnly, AGResponseHandler handler) throws QueryEvaluationException {
        try {
            this.httpCon.prepareHttpRepoClient().query(this, analyzeOnly, handler);
        }
        catch (AGQueryTimeoutException e) {
            throw new QueryInterruptedException((Throwable)((Object)e));
        }
        catch (AGHttpException e) {
            throw new QueryEvaluationException((Throwable)((Object)e));
        }
    }

    public void download(File file) throws QueryEvaluationException {
        this.evaluate(new AGDownloadHandler(file));
    }

    public void download(String file) throws QueryEvaluationException {
        this.evaluate(new AGDownloadHandler(file));
    }

    public void download(File file, String mimeType) throws QueryEvaluationException {
        this.evaluate(new AGDownloadHandler(file, mimeType));
    }

    public void download(String file, String mimeType) throws QueryEvaluationException {
        this.evaluate(new AGDownloadHandler(file, mimeType));
    }

    public InputStream stream(String mimeType) throws QueryEvaluationException {
        AGRawStreamer handler = new AGRawStreamer(mimeType);
        this.evaluate(handler);
        try {
            return handler.getStream();
        }
        catch (AGHttpException e) {
            throw new QueryEvaluationException((Throwable)((Object)e));
        }
    }

    public InputStream stream() throws QueryEvaluationException {
        return this.stream("*/*");
    }

    public String analyze() throws QueryEvaluationException {
        AGStringHandler handler = new AGStringHandler();
        this.evaluate(true, handler);
        return handler.getResult();
    }

    public boolean isCheckVariables() {
        return this.checkVariables;
    }

    public void setCheckVariables(boolean checkVariables) {
        this.checkVariables = checkVariables;
    }

    public Binding[] getBindingsArray() {
        BindingSet bindings = this.getBindings();
        Binding[] bindingsArray = new Binding[bindings.size()];
        Iterator iter = bindings.iterator();
        for (int i = 0; i < bindings.size(); ++i) {
            bindingsArray[i] = (Binding)iter.next();
        }
        return bindingsArray;
    }

    public String toString() {
        return this.queryString;
    }

    protected void finalize() throws Throwable {
        if (this.saveName != null) {
            this.httpCon.prepareHttpRepoClient().savedQueryDeleteQueue.add(this.saveName);
        }
        super.finalize();
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }
}

