/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.repository;

import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.http.handler.AGDownloadHandler;
import com.franz.agraph.http.handler.AGLongHandler;
import com.franz.agraph.http.handler.AGRawStreamer;
import com.franz.agraph.http.handler.AGTQRHandler;
import com.franz.agraph.repository.AGQuery;
import com.franz.agraph.repository.AGRepositoryConnection;
import java.io.File;
import java.io.InputStream;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.impl.TupleQueryResultBuilder;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;

public class AGTupleQuery
extends AGQuery
implements TupleQuery {
    public AGTupleQuery(AGRepositoryConnection con, QueryLanguage ql, String queryString, String baseURI) {
        super(con, ql, queryString, baseURI);
    }

    public TupleQueryResult evaluate() throws QueryEvaluationException {
        try {
            TupleQueryResultBuilder builder = new TupleQueryResultBuilder();
            this.evaluate((TupleQueryResultHandler)builder);
            return builder.getQueryResult();
        }
        catch (TupleQueryResultHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    public void evaluate(TupleQueryResultHandler handler) throws QueryEvaluationException, TupleQueryResultHandlerException {
        this.evaluate(new AGTQRHandler(this.httpCon.prepareHttpRepoClient().getPreferredTQRFormat(), handler, this.httpCon.getValueFactory(), this.httpCon.prepareHttpRepoClient().getAllowExternalBlankNodeIds()));
    }

    public long count() throws QueryEvaluationException {
        AGLongHandler handler = new AGLongHandler();
        this.evaluate(handler);
        return handler.getResult();
    }

    public void download(File file, TupleQueryResultFormat format) throws QueryEvaluationException {
        this.evaluate(new AGDownloadHandler(file, format));
    }

    public void download(String file, TupleQueryResultFormat format) throws QueryEvaluationException {
        this.evaluate(new AGDownloadHandler(file, format));
    }

    public InputStream stream(TupleQueryResultFormat format) throws QueryEvaluationException {
        AGRawStreamer handler = new AGRawStreamer(format);
        this.evaluate(handler);
        try {
            return handler.getStream();
        }
        catch (AGHttpException e) {
            throw new QueryEvaluationException((Throwable)((Object)e));
        }
    }
}

