/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.repository;

import com.franz.agraph.http.AGHTTPClient;
import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.repository.AGRepository;
import com.franz.agraph.repository.AGRepositoryConnection;
import java.util.regex.Pattern;
import org.apache.jena.graph.Node;
import org.apache.jena.vocabulary.RDF;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.ValueFactoryImpl;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.ntriples.NTriplesUtil;

public class AGValueFactory
extends ValueFactoryImpl {
    private static final Pattern AG_BNODE_ID_PATTERN = Pattern.compile("\\Ab[0-9A-Fa-f]{8}x\\d+\\z");
    private static final String RDF_LANG_STRING = RDF.langString.toString();
    private static final String JENA_EMPTY_URL = "http://franz.com/jena-empty-uri";
    private final AGRepository repository;
    private final AGRepositoryConnection conn;
    public String PREFIX_FOR_EXTERNAL_BNODES = "urn:x-bnode:";
    private int blankNodesPerRequest = Integer.parseInt(System.getProperty("com.franz.agraph.repository.blankNodesPerRequest", "100"));
    private String[] blankNodeIds;
    private int index = -1;

    public AGValueFactory(AGRepository repository) {
        this.repository = repository;
        this.conn = null;
    }

    public AGValueFactory(AGRepository repository, AGRepositoryConnection conn) {
        this.repository = repository;
        this.conn = conn;
    }

    public AGRepository getRepository() {
        return this.repository;
    }

    public AGHTTPClient getHTTPClient() {
        return this.getRepository().getHTTPClient();
    }

    private void requestBlankNodeIds() {
        try {
            this.blankNodeIds = this.conn == null ? this.getHTTPClient().getBlankNodes(this.getRepository().getRepositoryURL(), this.blankNodesPerRequest) : this.conn.prepareHttpRepoClient().getBlankNodes(this.blankNodesPerRequest);
            this.index = this.blankNodeIds.length - 1;
        }
        catch (AGHttpException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    public int getBlankNodesPerRequest() {
        return this.blankNodesPerRequest;
    }

    public void setBlankNodesPerRequest(int amount) {
        this.blankNodesPerRequest = amount;
    }

    public String[] getBlankNodeIds() {
        return this.blankNodeIds;
    }

    String getNextBNodeId() {
        if (this.index == -1) {
            this.requestBlankNodeIds();
        }
        String id = this.blankNodeIds[this.index];
        --this.index;
        return id.substring(2);
    }

    public BNode createBNode(String nodeID) {
        if (nodeID == null || "".equals(nodeID)) {
            nodeID = this.getNextBNodeId();
        }
        return super.createBNode(nodeID);
    }

    public BNode createBNode() {
        if (this.repository != null) {
            return this.createBNode(null);
        }
        return super.createBNode();
    }

    public Value asValue(Node node) {
        IRI val;
        if (node == null || node == Node.ANY) {
            val = null;
        } else if (node.isURI()) {
            val = this.createIRI(node.getURI());
        } else if (node.isBlank()) {
            String id = node.getBlankNodeLabel();
            val = this.createBNode(id);
        } else if (node.isLiteral()) {
            String lang = node.getLiteralLanguage();
            String datatypeURI = node.getLiteralDatatypeURI();
            if (lang != null && !lang.equals("")) {
                if (datatypeURI != null && !datatypeURI.equals(RDF_LANG_STRING)) {
                    String msg = String.format("Wrong tagged literal type: %s, should be: %s", datatypeURI, RDF_LANG_STRING);
                    throw new IllegalArgumentException(msg);
                }
                val = this.createLiteral(node.getLiteralLexicalForm(), lang);
            } else if (datatypeURI != null) {
                IRI datatype = this.createIRI(datatypeURI);
                val = this.createLiteral(node.getLiteralLexicalForm(), datatype);
            } else {
                val = this.createLiteral(node.getLiteralLexicalForm());
            }
        } else {
            throw new IllegalArgumentException("Cannot convert Node to Value: " + node);
        }
        return val;
    }

    public boolean isAGBlankNodeId(String id) {
        return AG_BNODE_ID_PATTERN.matcher(id).matches();
    }

    public boolean isURIForExternalBlankNode(Value v) {
        return v.stringValue().startsWith(this.PREFIX_FOR_EXTERNAL_BNODES);
    }

    public Resource asResource(Node node) {
        BNode res;
        if (node == null || node == Node.ANY) {
            res = null;
        } else if (node.isURI()) {
            String uri = node.getURI();
            if (uri.isEmpty()) {
                uri = JENA_EMPTY_URL;
            }
            res = this.createIRI(uri);
        } else if (node.isBlank()) {
            res = this.createBNode(node.getBlankNodeLabel());
        } else {
            throw new IllegalArgumentException("Cannot convert Node to Resource: " + node);
        }
        return res;
    }

    public IRI asURI(Node node) {
        IRI uri;
        if (node == null || node == Node.ANY) {
            uri = null;
        } else if (node.isURI()) {
            uri = this.createIRI(node.getURI());
        } else if (node.isBlank()) {
            uri = this.createIRI("http://anon/" + node.getBlankNodeLabel());
        } else {
            throw new IllegalArgumentException("Cannot convert Node to URI: " + node);
        }
        return uri;
    }

    public IRI[] generateURIs(String namespace, int amount) throws RepositoryException {
        IRI[] uris;
        try {
            String[] uri_strs = this.getHTTPClient().generateURIs(this.getRepository().getRepositoryURL(), namespace, amount);
            uris = new IRI[uri_strs.length];
            for (int i = 0; i < uri_strs.length; ++i) {
                uris[i] = NTriplesUtil.parseURI((String)uri_strs[i], (ValueFactory)this);
            }
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)((Object)e));
        }
        return uris;
    }

    public IRI generateURI(String registeredEncodableNamespace) throws RepositoryException {
        return this.generateURIs(registeredEncodableNamespace, 1)[0];
    }
}

