/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.repository.config;

import com.franz.agraph.repository.config.AGRepositorySchema;
import org.eclipse.rdf4j.model.Graph;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.ValueFactoryImpl;
import org.eclipse.rdf4j.model.util.GraphUtil;
import org.eclipse.rdf4j.model.util.GraphUtilException;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.config.RepositoryImplConfigBase;

public class AGRepositoryConfig
extends RepositoryImplConfigBase {
    private String serverUrl;
    private String username;
    private String password;
    private String catalogId;
    private String repositoryId;

    public AGRepositoryConfig() {
        super("allegrograph:AGRepository");
    }

    public AGRepositoryConfig(String url) {
        this();
        this.setServerUrl(url);
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String url) {
        this.serverUrl = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public void setCatalogId(String catalogId) {
        this.catalogId = catalogId;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public void validate() throws RepositoryConfigException {
        super.validate();
        if (this.serverUrl == null) {
            throw new RepositoryConfigException("No serverUrl specified for AG repositoryId");
        }
        if (this.username == null) {
            throw new RepositoryConfigException("No username specified for AG repositoryId");
        }
        if (this.password == null) {
            throw new RepositoryConfigException("No password specified for AG repositoryId");
        }
        if (this.catalogId == null) {
            throw new RepositoryConfigException("No catalogId specified for AG repositoryId");
        }
        if (this.repositoryId == null) {
            throw new RepositoryConfigException("No repositoryId specified for AG repositoryId");
        }
    }

    public Resource export(Model graph) {
        Resource implNode = super.export(graph);
        if (this.serverUrl != null) {
            graph.add(implNode, AGRepositorySchema.SERVERURL, (Value)this.getValueFactory().createIRI(this.serverUrl), new Resource[0]);
        }
        if (this.username != null) {
            graph.add(implNode, AGRepositorySchema.USERNAME, (Value)this.getValueFactory().createLiteral(this.username), new Resource[0]);
        }
        if (this.password != null) {
            graph.add(implNode, AGRepositorySchema.PASSWORD, (Value)this.getValueFactory().createLiteral(this.password), new Resource[0]);
        }
        if (this.catalogId != null) {
            graph.add(implNode, AGRepositorySchema.CATALOGID, (Value)this.getValueFactory().createLiteral(this.catalogId), new Resource[0]);
        }
        if (this.repositoryId != null) {
            graph.add(implNode, AGRepositorySchema.REPOSITORYID, (Value)this.getValueFactory().createLiteral(this.repositoryId), new Resource[0]);
        }
        return implNode;
    }

    public void parse(Model graph, Resource implNode) throws RepositoryConfigException {
        super.parse(graph, implNode);
        try {
            Literal repositoryId;
            Literal catalogId;
            Literal password;
            Literal username;
            IRI uri = GraphUtil.getOptionalObjectURI((Graph)graph, (Resource)implNode, (IRI)AGRepositorySchema.SERVERURL);
            if (uri != null) {
                this.setServerUrl(uri.toString());
            }
            if ((username = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)implNode, (IRI)AGRepositorySchema.USERNAME)) != null) {
                this.setUsername(username.getLabel());
            }
            if ((password = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)implNode, (IRI)AGRepositorySchema.PASSWORD)) != null) {
                this.setPassword(password.getLabel());
            }
            if ((catalogId = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)implNode, (IRI)AGRepositorySchema.CATALOGID)) != null) {
                this.setCatalogId(catalogId.getLabel());
            }
            if ((repositoryId = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)implNode, (IRI)AGRepositorySchema.REPOSITORYID)) != null) {
                this.setRepositoryId(repositoryId.getLabel());
            }
        }
        catch (GraphUtilException e) {
            throw new RepositoryConfigException(e.getMessage(), (Throwable)e);
        }
    }

    private ValueFactory getValueFactory() {
        return ValueFactoryImpl.getInstance();
    }
}

