/*
 * Decompiled with CFR 0.152.
 */
package com.franz.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Closer
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(Closer.class);
    private final List<AutoCloseable> toClose = Collections.synchronizedList(new ArrayList());

    public <Obj extends AutoCloseable> Obj closeLater(Obj o) {
        this.toClose.add(o);
        return o;
    }

    public boolean remove(AutoCloseable o) {
        boolean removed = false;
        if (o != null) {
            while (this.toClose.remove(o)) {
                removed = true;
            }
        }
        return removed;
    }

    @Override
    public void close() {
        Collections.reverse(this.toClose);
        this.toClose.forEach(this::closeQuietly);
        this.toClose.clear();
    }

    public void close(Collection<? extends AutoCloseable> objects) {
        objects.forEach(this::close);
    }

    public String toString() {
        return "{" + super.toString() + " toClose=" + this.toClose.size() + "}";
    }

    protected void handleCloseException(Object o, Throwable e) {
        log.warn("ignoring error with close: " + o, e);
    }

    private void closeQuietly(AutoCloseable o) {
        if (o != null) {
            try {
                o.close();
            }
            catch (Exception e) {
                this.handleCloseException(o, e);
            }
        }
    }

    public <CloseableType extends AutoCloseable> CloseableType close(CloseableType o) {
        this.closeQuietly(o);
        this.remove(o);
        return o;
    }
}

