/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.repository.AGAbstractRepository;
import com.franz.agraph.repository.AGCatalog;
import com.franz.agraph.repository.AGRepository;
import com.franz.agraph.repository.AGRepositoryConnection;
import com.franz.agraph.repository.AGServer;
import com.franz.agraph.repository.AGValueFactory;
import com.franz.util.Closer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jena.rdf.model.StmtIterator;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParserRegistry;
import org.eclipse.rdf4j.rio.Rio;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import test.Util;

public class AGAbstractTest {
    public static final String CATALOG_ID = "java-catalog";
    public static final String REPO_ID = "javatest";
    protected static AGServer server;
    protected static AGCatalog cat;
    private static String serverUrl;
    private static String sslServerUrl;
    private static AGRepository sharedRepo;
    public Logger log = LoggerFactory.getLogger(this.getClass());
    protected AGRepository repo;
    protected AGRepositoryConnection conn;
    protected AGValueFactory vf;
    protected Closer closer = new Closer();
    private String testName = null;

    public static String findServerUrl() {
        if (serverUrl == null) {
            serverUrl = AGAbstractTest.findServerUrl1();
        }
        return serverUrl;
    }

    public static String findSslServerUrl() {
        if (sslServerUrl == null) {
            sslServerUrl = AGAbstractTest.findSslServerUrl1();
        }
        return sslServerUrl;
    }

    private static String findServerUrl1() {
        String host = Util.coalesce(Util.ifBlank(System.getenv("AGRAPH_HOST"), null), Util.ifBlank(System.getProperty("AGRAPH_HOST"), null));
        String port = Util.coalesce(Util.ifBlank(System.getenv("AGRAPH_PORT"), null), Util.ifBlank(System.getProperty("AGRAPH_PORT"), null));
        if ((host == null || host.equals("localhost")) && port == null) {
            File portFile = new File("../agraph/lisp/agraph.port");
            try {
                host = "localhost";
                if (portFile.exists()) {
                    System.out.println("Reading agraph.port: " + portFile.getAbsolutePath());
                    port = FileUtils.readFileToString((File)portFile).trim();
                } else {
                    port = "10035";
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Trying to read PortFile: " + portFile.getAbsolutePath(), e);
            }
        }
        return "http://" + Util.coalesce(host, "localhost") + ":" + Util.coalesce(port, "10035");
    }

    private static String findSslServerUrl1() {
        String host = Util.coalesce(Util.ifBlank(System.getenv("AGRAPH_SSLHOST"), null), Util.ifBlank(System.getProperty("AGRAPH_SSLHOST"), null));
        String port = Util.coalesce(Util.ifBlank(System.getenv("AGRAPH_SSLPORT"), null), Util.ifBlank(System.getProperty("AGRAPH_SSLPORT"), null));
        if ((host == null || host.equals("localhost")) && port == null) {
            File portFile = new File("../agraph/lisp/agraph.sslport");
            try {
                host = "localhost";
                if (portFile.exists()) {
                    System.out.println("Reading agraph.sslport: " + portFile.getAbsolutePath());
                    port = FileUtils.readFileToString((File)portFile).trim();
                } else {
                    port = "10036";
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Trying to read SSLPortFile: " + portFile.getAbsolutePath(), e);
            }
        }
        return "https://" + Util.coalesce(host, "localhost") + ":" + Util.coalesce(port, "10036");
    }

    public static String username() {
        return Util.coalesce(System.getenv("AGRAPH_USER"), "test");
    }

    public static String password() {
        return Util.coalesce(System.getenv("AGRAPH_PASSWORD"), "xyzzy");
    }

    public static AGServer newAGServer() {
        String url = AGAbstractTest.findServerUrl();
        try {
            return new AGServer(url, AGAbstractTest.username(), AGAbstractTest.password());
        }
        catch (Exception e) {
            throw new RuntimeException("server url: " + url, e);
        }
    }

    public static AGRepository sharedRepository() throws RepositoryException {
        if (sharedRepo == null) {
            AGCatalog cat = AGAbstractTest.newAGServer().getCatalog(CATALOG_ID);
            cat.deleteRepository(REPO_ID);
            sharedRepo = cat.createRepository(REPO_ID);
        } else {
            AGRepositoryConnection conn = sharedRepo.getConnection();
            conn.clear(new Resource[0]);
            conn.clearNamespaces();
        }
        return sharedRepo;
    }

    @BeforeClass
    public static void setUpOnce() {
        server = AGAbstractTest.newAGServer();
        try {
            cat = server.getCatalog(CATALOG_ID);
            cat.deleteRepository(REPO_ID);
            AGAbstractTest.ping();
        }
        catch (Exception e) {
            throw new RuntimeException("server url: " + server.getServerURL(), e);
        }
    }

    public static void deleteRepository(String catalog, String repo) throws RepositoryException {
        try (AGServer server = new AGServer(AGAbstractTest.findServerUrl(), AGAbstractTest.username(), AGAbstractTest.password());){
            AGCatalog cat = server.getCatalog(catalog);
            cat.deleteRepository(repo);
        }
    }

    private static void ping() throws RepositoryException {
        try (AGRepository repo = cat.createRepository(REPO_ID);){
            repo.initialize();
            try (AGRepositoryConnection conn = repo.getConnection();){
                conn.ping();
            }
        }
    }

    public static Map<String, String> processes(AGServer server) throws AGHttpException {
        String url = server.getServerURL() + "/" + "processes";
        HashMap<String, String> map = new HashMap<String, String>();
        try (TupleQueryResult results = server.getHTTPClient().getTupleQueryResult(url);){
            while (results.hasNext()) {
                BindingSet bindingSet = (BindingSet)results.next();
                Value id = bindingSet.getValue("pid");
                Value name = bindingSet.getValue("name");
                map.put(id.stringValue(), name.stringValue());
            }
        }
        catch (QueryEvaluationException e) {
            throw new AGHttpException((Exception)((Object)e));
        }
        return map;
    }

    public static Map<String, String> sessions(AGServer server) throws AGHttpException {
        String url = server.getServerURL() + "/" + "session";
        HashMap<String, String> map = new HashMap<String, String>();
        try (TupleQueryResult results = server.getHTTPClient().getTupleQueryResult(url);){
            while (results.hasNext()) {
                BindingSet bindingSet = (BindingSet)results.next();
                Value k = bindingSet.getValue("uri");
                Value v = bindingSet.getValue("description");
                map.put(k.stringValue(), v.stringValue());
            }
        }
        catch (QueryEvaluationException e) {
            throw new AGHttpException((Exception)((Object)e));
        }
        return map;
    }

    @AfterClass
    public static void tearDownOnce() throws Exception {
        server.close();
    }

    public static void assertSetsEqual(Collection expected, Set actual) {
        AGAbstractTest.assertSetsEqual("", expected, actual);
    }

    public static void assertSetsEqual(String msg, byte[] expected, byte[] actual) {
        AGAbstractTest.assertSetsEqual(msg, Util.toList(expected), Util.toList(actual));
    }

    public static void assertSetsEqual(String msg, Collection expected, Collection actual) {
        expected = new ArrayList(expected);
        actual = new ArrayList(actual);
        Assert.assertEquals((String)msg, (long)expected.size(), (long)actual.size());
        for (Object exp : expected) {
            boolean found = false;
            Iterator ait = actual.iterator();
            while (ait.hasNext()) {
                Object act = ait.next();
                if (!exp.equals(act)) continue;
                found = true;
                ait.remove();
                break;
            }
            Assert.assertTrue((String)(msg + ". Not found: " + exp + " in " + actual), (boolean)found);
        }
        Assert.assertEquals((String)(msg + ". Remaining: " + actual), (long)0L, (long)actual.size());
    }

    public static void assertEqualsDeep(String msg, Object expected, Object actual) {
        if (expected == null) {
            Assert.assertEquals((String)msg, (Object)expected, (Object)actual);
        } else if (actual == null) {
            Assert.assertEquals((String)msg, (Object)expected, (Object)actual);
        } else if (expected instanceof List) {
            List expList = (List)expected;
            Assert.assertTrue((String)(msg + "; expected Collection type, actual: " + actual.getClass()), (boolean)(actual instanceof List));
            List actList = (List)actual;
            Assert.assertTrue((String)(msg + "; expected same size=" + expList.size() + ", actual=" + actList.size()), (expList.size() == actList.size() ? 1 : 0) != 0);
            for (int i = 0; i < expList.size(); ++i) {
                AGAbstractTest.assertEqualsDeep("[" + i + "]" + msg, expList.get(i), actList.get(i));
            }
        } else if (expected instanceof Object[]) {
            Object[] expList = (Object[])expected;
            Assert.assertTrue((String)(msg + "; expected Object[] type, actual: " + actual.getClass()), (boolean)(actual instanceof Object[]));
            Object[] actList = (Object[])actual;
            Assert.assertTrue((String)(msg + "; expected same size=" + expList.length + ", actual=" + actList.length), (expList.length == actList.length ? 1 : 0) != 0);
            for (int i = 0; i < expList.length; ++i) {
                AGAbstractTest.assertEqualsDeep("[" + i + "]" + msg, expList[i], actList[i]);
            }
        } else if (expected instanceof byte[]) {
            byte[] expList = (byte[])expected;
            Assert.assertTrue((String)(msg + "; expected byte[] type, actual: " + actual.getClass()), (boolean)(actual instanceof byte[]));
            byte[] actList = (byte[])actual;
            Assert.assertTrue((String)(msg + "; expected same size=" + expList.length + ", actual=" + actList.length), (expList.length == actList.length ? 1 : 0) != 0);
            for (int i = 0; i < expList.length; ++i) {
                AGAbstractTest.assertEqualsDeep("[" + i + "]" + msg, expList[i], actList[i]);
            }
        } else if (expected instanceof Set) {
            AGAbstractTest.assertSetsEqual(msg, (Set)expected, (Collection)actual);
        } else {
            Assert.assertEquals((String)msg, (Object)expected, (Object)actual);
        }
    }

    public static void assertSetsSome(String msg, Collection expected, Collection actual) {
        for (Object act : actual) {
            boolean found = false;
            for (Object exp : expected) {
                if (!exp.equals(act)) continue;
                found = true;
                break;
            }
            Assert.assertTrue((String)(msg + "; unexpected: " + act), (boolean)found);
        }
    }

    public static void assertFiles(File expected, File actual) throws Exception {
        AGAbstractTest.assertSetsEqual("diff " + expected.getCanonicalPath() + " " + actual.getCanonicalPath(), AGAbstractTest.stripBlankNodes(FileUtils.readLines((File)expected, (Charset)StandardCharsets.UTF_8)), AGAbstractTest.stripBlankNodes(FileUtils.readLines((File)actual, (Charset)StandardCharsets.UTF_8)));
    }

    public static void assertRDFFilesIsomorphic(File expected, File actual) throws Exception {
        AGAbstractTest.assertRDFFilesIsomorphic(expected, actual, null);
    }

    public static void assertRDFFilesIsomorphic(File expected, File actual, RDFFormat format) throws Exception {
        Model actualModel;
        Model expectedModel;
        RDFFormat actualFormat;
        RDFFormat expectedFormat;
        if (format == null) {
            RDFParserRegistry registry = RDFParserRegistry.getInstance();
            expectedFormat = registry.getFileFormatForFileName(expected.getName()).orElse(null);
            actualFormat = registry.getFileFormatForFileName(actual.getName()).orElse(null);
            Assert.assertNotNull((String)"Can't guess the expected file format", (Object)expectedFormat);
            Assert.assertNotNull((String)"Can't guess the actual file format", (Object)actualFormat);
        } else {
            expectedFormat = format;
            actualFormat = format;
        }
        try (FileInputStream expectedStream = new FileInputStream(expected);
             FileInputStream actualStream = new FileInputStream(actual);){
            expectedModel = Rio.parse((InputStream)expectedStream, (String)"base://", (RDFFormat)expectedFormat, (Resource[])new Resource[0]);
            actualModel = Rio.parse((InputStream)actualStream, (String)"base://", (RDFFormat)actualFormat, (Resource[])new Resource[0]);
        }
        Assert.assertTrue((String)"RDF files are not isomorphic", (boolean)Models.isomorphic((Iterable)expectedModel, (Iterable)actualModel));
    }

    private static List<String> stripBlankNodes(List<String> strings) {
        ArrayList<String> ret = new ArrayList<String>(strings.size());
        for (String str : strings) {
            ret.add(str.replaceAll("b........x.", "b00000000x0"));
        }
        return ret;
    }

    public static Map mapKeep(Object[] keys, Map map) {
        HashMap ret = new HashMap();
        for (int i = 0; i < keys.length; ++i) {
            ret.put(keys[i], map.get(keys[i]));
        }
        return ret;
    }

    public static String readFileAsString(String filePath) throws IOException {
        return new String(Files.readAllBytes(Paths.get(filePath, new String[0])));
    }

    public static String readResourceAsString(String path) throws IOException {
        try (InputStream input = AGAbstractTest.class.getResourceAsStream(path);){
            String string = IOUtils.toString((InputStream)input, (String)"utf-8");
            return string;
        }
    }

    public static void println(Object x) {
        System.out.println(x);
    }

    public static void printRows(CloseableIteration rows) throws Exception {
        try (CloseableIteration ignored = rows;){
            while (rows.hasNext()) {
                AGAbstractTest.println(rows.next());
            }
        }
    }

    public static void printRows(String headerMsg, int limit, CloseableIteration rows) throws Exception {
        int count;
        AGAbstractTest.println(headerMsg);
        try (CloseableIteration ignored = rows;){
            for (count = 0; count < limit && rows.hasNext(); ++count) {
                AGAbstractTest.println(rows.next());
            }
        }
        AGAbstractTest.println("Number of results: " + count);
    }

    public String getTestName() {
        return this.testName;
    }

    public void setTestName(String testName) {
        this.testName = testName;
        this.log = LoggerFactory.getLogger((String)(this.getClass().getName() + "." + testName));
    }

    @Before
    public void setUp() throws Exception {
        this.repo = cat.createRepository(REPO_ID);
        this.repo.initialize();
        this.vf = this.repo.getValueFactory();
        this.conn = this.getConnection();
        this.conn.deleteStaticAttributeFilter();
        this.conn.clear(new Resource[0]);
        this.conn.clearAttributes();
        this.conn.clearMappings();
        this.conn.clearNamespaces();
        this.conn.setNamespace("fti", "http://franz.com/ns/allegrograph/2.2/textindex/");
        this.conn.setNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
    }

    @After
    public void tearDown() throws Exception {
        this.closer.close();
        this.conn.close();
        this.repo.close();
        this.vf = null;
        this.conn = null;
        this.repo = null;
    }

    protected <T extends AutoCloseable> T closeLater(T closeable) {
        this.closer.closeLater(closeable);
        return closeable;
    }

    protected StmtIterator closeLater(StmtIterator iter) {
        this.closeLater(() -> ((StmtIterator)iter).close());
        return iter;
    }

    AGRepositoryConnection getConnection() throws RepositoryException {
        return this.getConnection((AGAbstractRepository)this.repo);
    }

    AGRepositoryConnection getConnection(AGAbstractRepository repo) throws RepositoryException {
        return repo.getConnection();
    }

    public void addAll(Collection stmts, RepositoryConnection conn) throws RepositoryException {
        for (Statement st : stmts) {
            conn.add(st, new Resource[0]);
        }
    }

    static {
        sharedRepo = null;
    }
}

