/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.http.AGHTTPClient;
import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.http.handler.AGResponseHandler;
import org.apache.commons.httpclient.ConnectionPoolTimeoutException;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import test.AGAbstractTest;

public class AGHTTPClientTests {
    private AGHTTPClient client;
    private AuditingConnectionManager manager;
    private String serverUrl;

    @Before
    public void setUp() {
        this.serverUrl = AGAbstractTest.findServerUrl();
        this.manager = new AuditingConnectionManager((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        this.client = new AGHTTPClient(this.serverUrl, (HttpConnectionManager)this.manager);
        this.client.setUsernameAndPassword(AGAbstractTest.username(), AGAbstractTest.password());
    }

    @Test
    public void testConnectionReleasedOnErrorWhenStreaming() {
        NullStreamer handler = new NullStreamer();
        int connectionsBefore = this.manager.getConnectionCount();
        try {
            this.client.get(this.serverUrl + "/PleaseRespondWith404", null, null, null);
        }
        catch (AGHttpException aGHttpException) {
            // empty catch block
        }
        this.manager.closeIdleConnections(0L);
        Assert.assertEquals((long)connectionsBefore, (long)this.manager.getConnectionCount());
    }

    private static final class AuditingConnectionManager
    implements HttpConnectionManager {
        private final HttpConnectionManager wrapped;
        private int connectionCount = 0;

        public AuditingConnectionManager(HttpConnectionManager wrapped) {
            this.wrapped = wrapped;
        }

        public int getConnectionCount() {
            return this.connectionCount;
        }

        private HttpConnection fixConnection(HttpConnection conn) {
            conn.setHttpConnectionManager((HttpConnectionManager)this);
            return conn;
        }

        public HttpConnection getConnection(HostConfiguration hostConfiguration) {
            ++this.connectionCount;
            return this.fixConnection(this.wrapped.getConnection(hostConfiguration));
        }

        public HttpConnection getConnection(HostConfiguration hostConfiguration, long timeout) throws HttpException {
            ++this.connectionCount;
            return this.fixConnection(this.wrapped.getConnection(hostConfiguration, timeout));
        }

        public HttpConnection getConnectionWithTimeout(HostConfiguration hostConfiguration, long timeout) throws ConnectionPoolTimeoutException {
            ++this.connectionCount;
            return this.fixConnection(this.wrapped.getConnectionWithTimeout(hostConfiguration, timeout));
        }

        public void releaseConnection(HttpConnection conn) {
            --this.connectionCount;
            this.wrapped.releaseConnection(conn);
        }

        public void closeIdleConnections(long idleTimeout) {
            this.wrapped.closeIdleConnections(idleTimeout);
        }

        public HttpConnectionManagerParams getParams() {
            return this.wrapped.getParams();
        }

        public void setParams(HttpConnectionManagerParams params) {
            this.wrapped.setParams(params);
        }
    }

    private static final class NullStreamer
    extends AGResponseHandler {
        public NullStreamer() {
            super("who/cares/and/why/is/this/required");
        }

        public void handleResponse(HttpMethod method) {
            method.releaseConnection();
        }

        public boolean releaseConnection() {
            return false;
        }
    }
}

