/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.repository.AGMaterializer;
import junit.framework.AssertionFailedError;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.OWL;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import test.AGAbstractTest;
import test.TestSuites;
import test.Util;

public class AGMaterializerTests
extends AGAbstractTest {
    protected static String printStatements(RepositoryConnection conn) throws RepositoryException {
        RepositoryResult results = conn.getStatements(null, null, null, false, new Resource[0]);
        StringBuffer m = new StringBuffer();
        int limit = Integer.parseInt(System.getProperty("AGMaterializerTests.printStatements.limit", "50"));
        for (int i = 0; results.hasNext() && i < limit; ++i) {
            if (i == 0) {
                m.append("\nDumping all statements to help debug:\n");
            }
            m.append(results.next());
            m.append("\n");
        }
        if (results.hasNext()) {
            m.append("(there are more, stopping at " + limit + ")\n");
        }
        return m.toString();
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void materializeOverDefaultGraph() throws Exception {
        IRI a = this.vf.createIRI("http://a");
        IRI p = this.vf.createIRI("http://p");
        IRI A = this.vf.createIRI("http://A");
        try {
            this.conn.add((Resource)a, p, (Value)a, new Resource[0]);
            this.conn.add((Resource)p, RDFS.DOMAIN, (Value)A, new Resource[0]);
            AGMaterializer materializer = AGMaterializer.newInstance();
            materializer.withRuleset("all");
            Assert.assertEquals((String)"unexpected number of materialized triples added", (long)13L, (long)this.conn.materialize(materializer));
            Assert.assertEquals((String)"expected size 15", (long)15L, (long)this.conn.size(new Resource[0]));
            Assert.assertTrue((boolean)this.conn.hasStatement((Resource)a, RDF.TYPE, (Value)A, false, new Resource[0]));
            Assert.assertEquals((String)"unexpected number of materialized triples deleted", (long)13L, (long)this.conn.deleteMaterialized());
            Assert.assertFalse((boolean)this.conn.hasStatement((Resource)a, RDF.TYPE, (Value)A, false, new Resource[0]));
            Assert.assertEquals((String)"expected size 2", (long)2L, (long)this.conn.size(new Resource[0]));
        }
        catch (AssertionFailedError e) {
            throw new AssertionFailedError(e.getMessage() + AGMaterializerTests.printStatements((RepositoryConnection)this.conn));
        }
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void materializeIntoNamedGraph() throws Exception {
        IRI a = this.vf.createIRI("http://a");
        IRI p = this.vf.createIRI("http://p");
        IRI A = this.vf.createIRI("http://A");
        IRI g = this.vf.createIRI("http://g");
        try {
            this.conn.add((Resource)a, p, (Value)a, new Resource[0]);
            this.conn.add((Resource)p, RDFS.DOMAIN, (Value)A, new Resource[0]);
            AGMaterializer materializer = AGMaterializer.newInstance();
            materializer.withRuleset("all");
            materializer.setInferredGraph((Resource)g);
            Assert.assertEquals((String)"unexpected number of materialized triples added", (long)13L, (long)this.conn.materialize(materializer));
            Assert.assertEquals((String)"wrong size of G", (long)13L, (long)this.conn.size(new Resource[]{g}));
            Assert.assertEquals((String)"wrong size of the default graph", (long)2L, (long)this.conn.size(new Resource[]{null}));
            Assert.assertTrue((boolean)this.conn.hasStatement((Resource)a, RDF.TYPE, (Value)A, false, new Resource[]{g}));
            Assert.assertEquals((String)"materialized triples deleted from wrong graph", (long)0L, (long)this.conn.deleteMaterialized());
            Assert.assertEquals((String)"unexpected number of materialized triples deleted", (long)13L, (long)this.conn.deleteMaterialized(materializer));
            Assert.assertFalse((boolean)this.conn.hasStatement((Resource)a, RDF.TYPE, (Value)A, false, new Resource[]{g}));
            Assert.assertEquals((String)"G not empty after delete", (long)0L, (long)this.conn.size(new Resource[]{g}));
        }
        catch (AssertionFailedError e) {
            throw new AssertionFailedError(e.getMessage() + AGMaterializerTests.printStatements((RepositoryConnection)this.conn));
        }
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void materializeOverDefaultGraphTransactional() throws Exception {
        IRI a = this.vf.createIRI("http://a");
        IRI p = this.vf.createIRI("http://p");
        IRI A = this.vf.createIRI("http://A");
        this.conn.setAutoCommit(false);
        this.conn.add((Resource)a, p, (Value)a, new Resource[0]);
        this.conn.add((Resource)p, RDFS.DOMAIN, (Value)A, new Resource[0]);
        AGMaterializer materializer = AGMaterializer.newInstance();
        materializer.withRuleset("all");
        Assert.assertEquals((long)13L, (long)this.conn.materialize(materializer));
        Assert.assertEquals((String)"expected size 15", (long)15L, (long)this.conn.size(new Resource[0]));
        Assert.assertTrue((boolean)this.conn.hasStatement((Resource)a, RDF.TYPE, (Value)A, false, new Resource[0]));
        Assert.assertEquals((long)13L, (long)this.conn.deleteMaterialized());
        Assert.assertFalse((boolean)this.conn.hasStatement((Resource)a, RDF.TYPE, (Value)A, false, new Resource[0]));
        Assert.assertEquals((String)"expected size 2", (long)2L, (long)this.conn.size(new Resource[0]));
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void materializeOverDefaultGraphUseTypeSubproperty() throws Exception {
        IRI a = this.vf.createIRI("http://a");
        IRI A = this.vf.createIRI("http://A");
        IRI B = this.vf.createIRI("http://B");
        IRI mytype = this.vf.createIRI("http://mytype");
        this.conn.add((Resource)A, RDFS.SUBCLASSOF, (Value)B, new Resource[0]);
        this.conn.add((Resource)mytype, RDFS.SUBPROPERTYOF, (Value)RDF.TYPE, new Resource[0]);
        this.conn.add((Resource)a, mytype, (Value)A, new Resource[0]);
        AGMaterializer materializer = AGMaterializer.newInstance();
        materializer.setUseTypeSubproperty(Boolean.valueOf(false));
        this.conn.materialize(materializer);
        Assert.assertTrue((boolean)this.conn.hasStatement((Resource)a, RDF.TYPE, (Value)A, false, new Resource[0]));
        Assert.assertTrue((boolean)this.conn.hasStatement((Resource)a, RDF.TYPE, (Value)B, false, new Resource[0]));
        this.conn.deleteMaterialized();
        Assert.assertEquals((String)"expected size 3", (long)3L, (long)this.conn.size(new Resource[0]));
        materializer.setUseTypeSubproperty(Boolean.valueOf(true));
        this.conn.materialize(materializer);
        Assert.assertTrue((boolean)this.conn.hasStatement((Resource)a, RDF.TYPE, (Value)A, false, new Resource[0]));
        Assert.assertTrue((boolean)this.conn.hasStatement((Resource)a, mytype, (Value)B, false, new Resource[0]));
        Assert.assertTrue((boolean)this.conn.hasStatement((Resource)a, RDF.TYPE, (Value)B, false, new Resource[0]));
    }

    @Test
    @Category(value={TestSuites.Broken.class})
    public void materializeOverNamedGraphs() throws Exception {
        Util.add((RepositoryConnection)this.conn, "/test/example.nq", null, RDFFormat.NQUADS, new Resource[0]);
        this.conn.add((Resource)this.vf.createIRI("http://xmlns.com/foaf/0.1/name"), RDFS.DOMAIN, (Value)OWL.INDIVIDUAL, new Resource[0]);
        Assert.assertEquals((String)"expected size 11", (long)11L, (long)this.conn.size(new Resource[0]));
        this.conn.materialize(null);
        Assert.assertFalse((boolean)this.conn.hasStatement((Resource)this.vf.createIRI("http://www.franz.com/materialized"), null, null, false, new Resource[0]));
        Assert.assertEquals((String)"expected size 14", (long)14L, (long)this.conn.size(new Resource[0]));
    }
}

