/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.jena.AGGraph;
import com.franz.agraph.jena.AGGraphMaker;
import com.franz.agraph.jena.AGModel;
import com.franz.agraph.repository.AGRepositoryConnection;
import junit.framework.Test;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.test.AbstractTestModel;
import test.JenaUtil;

public class AGModelTest
extends AbstractTestModel {
    protected static JenaUtil util = new JenaUtil(AGModelTest.class);
    private static int graphId = 0;
    protected AGRepositoryConnection conn = null;
    protected AGGraphMaker maker = null;

    public AGModelTest(String name) {
        super(name);
    }

    public static Test suite() {
        return util;
    }

    public void setUp() {
        this.conn = util.getConn();
        this.maker = util.getMaker();
        super.setUp();
    }

    public Model getModel() {
        AGGraph graph = util.getMaker().createGraph("http://anon" + graphId);
        ++graphId;
        return new AGModel(graph);
    }

    public void testContainsResource() {
        Model model = this.getModel();
        AGModelTest.modelAdd((Model)model, (String)"x R y; a P b");
        AGModelTest.assertTrue((boolean)model.containsResource((RDFNode)AGModelTest.resource((Model)model, (String)"x")));
        AGModelTest.assertTrue((boolean)model.containsResource((RDFNode)AGModelTest.resource((Model)model, (String)"R")));
        AGModelTest.assertTrue((boolean)model.containsResource((RDFNode)AGModelTest.resource((Model)model, (String)"y")));
        AGModelTest.assertTrue((boolean)model.containsResource((RDFNode)AGModelTest.resource((Model)model, (String)"a")));
        AGModelTest.assertTrue((boolean)model.containsResource((RDFNode)AGModelTest.resource((Model)model, (String)"P")));
        AGModelTest.assertTrue((boolean)model.containsResource((RDFNode)AGModelTest.resource((Model)model, (String)"b")));
        AGModelTest.assertFalse((boolean)model.containsResource((RDFNode)AGModelTest.resource((Model)model, (String)"i")));
        AGModelTest.assertFalse((boolean)model.containsResource((RDFNode)AGModelTest.resource((Model)model, (String)"j")));
    }

    public void testRemoveAll() {
        this.testRemoveAll("");
        this.testRemoveAll("a RR b");
        this.testRemoveAll("x P y; a Q b; c R 17; d S 'e'");
        this.testRemoveAll("subject Predicate 'object'; http://nowhere/x scheme:cunning not:plan");
    }

    public void testGetPropertyWithLanguage() {
    }
}

