/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.repository.config.AGRepositoryConfig;
import com.franz.agraph.repository.config.AGRepositoryFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import junit.framework.Assert;
import org.apache.commons.io.FileUtils;
import org.eclipse.rdf4j.model.Graph;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.util.GraphUtil;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.config.RepositoryConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigSchema;
import org.eclipse.rdf4j.repository.config.RepositoryImplConfig;
import org.eclipse.rdf4j.repository.manager.LocalRepositoryManager;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import test.AGAbstractTest;
import test.TestSuites;
import test.Util;

public class AGRepositoryFactoryTest
extends AGAbstractTest {
    final String configFile = "/test/repoconfig.ttl";
    final String ns = "http://franz.com/agraph/repository/config#";

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void getRepositoryUsingConfig() throws Exception {
        Model graph = this.parseTurtleGraph("/test/repoconfig.ttl");
        this.updateGraphForTestServer(graph);
        Resource implNode = GraphUtil.getUniqueSubject((Graph)graph, (IRI)this.vf.createIRI("http://www.openrdf.org/config/repository#repositoryType"), (Value)this.vf.createLiteral("allegrograph:AGRepository"), (Resource[])new Resource[0]);
        AGRepositoryFactory factory = new AGRepositoryFactory();
        AGRepositoryConfig config = factory.getConfig();
        config.parse(graph, implNode);
        config.setServerUrl(AGAbstractTest.findServerUrl());
        config.setUsername(AGAbstractTest.username());
        config.setPassword(AGAbstractTest.password());
        Repository repo = factory.getRepository((RepositoryImplConfig)config);
        Assert.assertEquals((long)0L, (long)repo.getConnection().size(new Resource[0]));
        LinkedHashModel graph2 = new LinkedHashModel();
        config.export((Model)graph2);
        Assert.assertEquals((int)6, (int)graph2.size());
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void getRepositoryUsingManager() throws Exception {
        Path confDir = Files.createTempDirectory("repomgr", new FileAttribute[0]);
        this.closeLater(() -> FileUtils.deleteDirectory((File)confDir.toFile()));
        LocalRepositoryManager manager = new LocalRepositoryManager(confDir.toFile());
        manager.initialize();
        this.closeLater(() -> ((RepositoryManager)manager).shutDown());
        Model graph = this.parseTurtleGraph("/test/repoconfig.ttl");
        this.updateGraphForTestServer(graph);
        Resource node = GraphUtil.getUniqueSubject((Graph)graph, (IRI)RDF.TYPE, (Value)RepositoryConfigSchema.REPOSITORY, (Resource[])new Resource[0]);
        String id = GraphUtil.getUniqueObjectLiteral((Graph)graph, (Resource)node, (IRI)RepositoryConfigSchema.REPOSITORYID).stringValue();
        RepositoryConfig config = RepositoryConfig.create((Model)graph, (Resource)node);
        config.validate();
        manager.addRepositoryConfig(config);
        Repository repo = manager.getRepository(id);
        repo.initialize();
        this.closeLater(() -> ((Repository)repo).shutDown());
        Assert.assertEquals((long)0L, (long)repo.getConnection().size(new Resource[0]));
    }

    private Model parseTurtleGraph(String configFile) throws IOException, RDFParseException, RDFHandlerException, FileNotFoundException {
        RDFParser parser = Rio.createParser((RDFFormat)RDFFormat.TURTLE, (ValueFactory)this.vf);
        parser.setPreserveBNodeIDs(true);
        StatementCollector collector = new StatementCollector();
        parser.setRDFHandler((RDFHandler)collector);
        try (InputStream fis = Util.resourceAsStream(configFile);){
            parser.parse(fis, "");
        }
        return new LinkedHashModel(collector.getStatements());
    }

    private void updateValue(Model graph, IRI pred, Value val) {
        Iterator it = graph.match(null, pred, null, new Resource[0]);
        Statement s = (Statement)it.next();
        graph.remove((Object)s);
        graph.add(s.getSubject(), pred, val, new Resource[0]);
    }

    private void updateGraphForTestServer(Model graph) {
        this.updateValue(graph, this.vf.createIRI("http://franz.com/agraph/repository/config#", "serverUrl"), (Value)this.vf.createIRI(AGAbstractTest.findServerUrl()));
        this.updateValue(graph, this.vf.createIRI("http://franz.com/agraph/repository/config#", "username"), (Value)this.vf.createLiteral(AGAbstractTest.username()));
        this.updateValue(graph, this.vf.createIRI("http://franz.com/agraph/repository/config#", "password"), (Value)this.vf.createLiteral(AGAbstractTest.password()));
    }
}

