/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.jena.AGModel;
import com.franz.agraph.jena.AGQuery;
import com.franz.agraph.jena.AGQueryExecution;
import com.franz.agraph.jena.AGQueryExecutionFactory;
import com.franz.agraph.jena.AGQueryFactory;
import java.io.FileNotFoundException;
import java.util.Iterator;
import junit.framework.Test;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import test.AGModelTest;
import test.JenaUtil;
import test.Util;

public class AGResultSetTest
extends AGModelTest {
    public AGResultSetTest(String name) {
        super(name);
    }

    public static Test suite() {
        util = new JenaUtil(AGResultSetTest.class);
        return util;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResultSet() throws FileNotFoundException {
        AGModel model = (AGModel)this.getModel();
        model.read(Util.resourceAsStream("/test/default-graph.nt"), null, "N-TRIPLE");
        try {
            ResultSet results;
            String queryString = "SELECT ?s ?p ?o  WHERE {?s ?p ?o .}";
            AGQuery sparql = AGQueryFactory.create((String)queryString);
            try (AGQueryExecution qe = AGQueryExecutionFactory.create((AGQuery)sparql, (AGModel)model);){
                results = qe.execSelect();
                AGResultSetTest.assertEquals((Object)results.getResourceModel(), (Object)model);
                AGResultSetTest.assertEquals((int)results.getResultVars().size(), (int)3);
                while (results.hasNext()) {
                    QuerySolution result = results.next();
                    RDFNode s = result.get("s");
                    RDFNode p = result.get("p");
                    RDFNode o = result.get("o");
                    RDFNode g = result.get("g");
                    AGResultSetTest.assertTrue((boolean)s.isResource());
                    AGResultSetTest.assertTrue((boolean)p.isResource());
                    AGResultSetTest.assertTrue((boolean)o.isLiteral());
                    AGResultSetTest.assertNull((Object)g);
                }
            }
            queryString = "SELECT ?s ?p ?o ?g  WHERE {GRAPH ?g {?s ?p ?o .}}";
            sparql = AGQueryFactory.create((String)queryString);
            qe = AGQueryExecutionFactory.create((AGQuery)sparql, (AGModel)model);
            try {
                results = qe.execSelect();
                AGResultSetTest.assertEquals((Object)results.getResourceModel(), (Object)model);
                AGResultSetTest.assertEquals((int)results.getResultVars().size(), (int)4);
                int count = 0;
                while (results.hasNext()) {
                    QuerySolution result = results.next();
                    Iterator vars = result.varNames();
                    while (vars.hasNext()) {
                        AGResultSetTest.assertTrue((boolean)result.contains((String)vars.next()));
                    }
                    Resource s = result.getResource("s");
                    Resource p = result.getResource("p");
                    try {
                        result.getResource("o");
                        AGResultSetTest.fail();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Literal o = result.getLiteral("o");
                    Resource g = result.getResource("g");
                    AGResultSetTest.assertTrue((boolean)s.isResource());
                    AGResultSetTest.assertTrue((boolean)p.isResource());
                    AGResultSetTest.assertTrue((boolean)o.isLiteral());
                    AGResultSetTest.assertTrue((boolean)g.isResource());
                    ++count;
                }
                AGResultSetTest.assertEquals((int)count, (int)4);
            }
            finally {
                qe.close();
            }
        }
        finally {
            model.close();
        }
    }
}

