/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.repository.AGRepositoryConnection;
import com.franz.agraph.repository.AGValueFactory;
import java.util.ArrayList;
import org.apache.jena.vocabulary.RDFS;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import test.AGAbstractTest;
import test.TestSuites;

public class AGTripleAttributesTest
extends AGAbstractTest {
    private int id = 0;
    private AGRepositoryConnection conn;

    private String genAttributeName() {
        ++this.id;
        return "attrdef" + this.id;
    }

    @Before
    public void connect() {
        this.conn = this.getConnection();
    }

    @After
    public void disconnect() {
        this.conn.close();
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testAttributeDefinitionsBasic() throws Exception {
        AGRepositoryConnection aGRepositoryConnection = this.conn;
        aGRepositoryConnection.getClass();
        new AGRepositoryConnection.AttributeDefinition(aGRepositoryConnection, "remoteAttr1").add();
        JSONArray attrs = this.conn.getAttributeDefinitions();
        Assert.assertEquals((String)"Verifying 1 attribute definition", (long)1L, (long)attrs.length());
        AGRepositoryConnection aGRepositoryConnection2 = this.conn;
        aGRepositoryConnection2.getClass();
        new AGRepositoryConnection.AttributeDefinition(aGRepositoryConnection2, "remoteAttr2").allowedValue("sales").allowedValue("devel").allowedValue("hr").add();
        attrs = this.conn.getAttributeDefinitions();
        Assert.assertEquals((String)"Verifying 2 attribute definitions", (long)2L, (long)attrs.length());
        AGRepositoryConnection aGRepositoryConnection3 = this.conn;
        aGRepositoryConnection3.getClass();
        new AGRepositoryConnection.AttributeDefinition(aGRepositoryConnection3, "remoteAttr3").allowedValue("low").allowedValue("medium").allowedValue("high").ordered(true).add();
        attrs = this.conn.getAttributeDefinitions();
        Assert.assertEquals((String)"Verifying 3 attribute definitions", (long)3L, (long)attrs.length());
        ArrayList<String> values4 = new ArrayList<String>(3);
        values4.add("moe");
        values4.add("larry");
        values4.add("curly");
        AGRepositoryConnection aGRepositoryConnection4 = this.conn;
        aGRepositoryConnection4.getClass();
        AGRepositoryConnection.AttributeDefinition defn4 = new AGRepositoryConnection.AttributeDefinition(aGRepositoryConnection4, "remoteAttr4");
        defn4.allowedValues(values4).maximum(1L).add();
        attrs = this.conn.getAttributeDefinitions();
        Assert.assertEquals((String)"Verifying 4 attribute definitions", (long)4L, (long)attrs.length());
        attrs = this.conn.getAttributeDefinition("remoteAttr3");
        Assert.assertEquals((String)"Fetching remoteAttr3", (long)1L, (long)attrs.length());
        this.conn.deleteAttributeDefinition(attrs.getJSONObject(0).getString("name"));
        attrs = this.conn.getAttributeDefinitions();
        Assert.assertEquals((String)"Verifying one fewer defined attributes", (long)3L, (long)attrs.length());
        attrs = this.conn.getAttributeDefinition("remoteAttr3");
        Assert.assertEquals((String)"Verifying remoteAttr3 was deleted", (long)0L, (long)attrs.length());
    }

    @Category(value={TestSuites.Prepush.class})
    @Test
    public void testInvalidNameException() throws Exception {
        try {
            AGRepositoryConnection aGRepositoryConnection = this.conn;
            aGRepositoryConnection.getClass();
            new AGRepositoryConnection.AttributeDefinition(aGRepositoryConnection, "no spaces allowed").add();
            Assert.fail((String)"no exception for invalid name.");
        }
        catch (AGHttpException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Invalid name:"));
        }
    }

    @Category(value={TestSuites.Prepush.class})
    @Test
    public void testNegativeMinimum() throws Exception {
        try {
            AGRepositoryConnection aGRepositoryConnection = this.conn;
            aGRepositoryConnection.getClass();
            new AGRepositoryConnection.AttributeDefinition(aGRepositoryConnection, this.genAttributeName()).minimum(-5L);
            Assert.fail((String)"no exception for negative value.");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("minimum"));
        }
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testNegativeMaximum() throws Exception {
        try {
            AGRepositoryConnection aGRepositoryConnection = this.conn;
            aGRepositoryConnection.getClass();
            new AGRepositoryConnection.AttributeDefinition(aGRepositoryConnection, this.genAttributeName()).maximum(-5L);
            Assert.fail((String)"no exception for negative value.");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("maximum"));
        }
    }

    @Test(expected=AGHttpException.class)
    @Category(value={TestSuites.Prepush.class})
    public void testMaximumTooBig() throws Exception {
        AGRepositoryConnection aGRepositoryConnection = this.conn;
        aGRepositoryConnection.getClass();
        new AGRepositoryConnection.AttributeDefinition(aGRepositoryConnection, this.genAttributeName()).maximum(Long.MAX_VALUE).add();
    }

    @Test(expected=AGHttpException.class)
    @Category(value={TestSuites.Prepush.class})
    public void testMinimumTooBig() throws Exception {
        AGRepositoryConnection aGRepositoryConnection = this.conn;
        aGRepositoryConnection.getClass();
        new AGRepositoryConnection.AttributeDefinition(aGRepositoryConnection, this.genAttributeName()).minimum(Long.MAX_VALUE).add();
    }

    @Test(expected=AGHttpException.class)
    @Category(value={TestSuites.Prepush.class})
    public void testMinGreaterThanMax() throws Exception {
        AGRepositoryConnection aGRepositoryConnection = this.conn;
        aGRepositoryConnection.getClass();
        new AGRepositoryConnection.AttributeDefinition(aGRepositoryConnection, this.genAttributeName()).maximum(2L).minimum(10L).add();
    }

    @Test(expected=AGHttpException.class)
    @Category(value={TestSuites.Prepush.class})
    public void testMaxOfOneWhenOrdered() throws Exception {
        ArrayList<String> values = new ArrayList<String>(3);
        values.add("low");
        values.add("medium");
        values.add("high");
        AGRepositoryConnection aGRepositoryConnection = this.conn;
        aGRepositoryConnection.getClass();
        new AGRepositoryConnection.AttributeDefinition(aGRepositoryConnection, this.genAttributeName()).ordered(true).maximum(1L).allowedValues(values).add();
        AGRepositoryConnection aGRepositoryConnection2 = this.conn;
        aGRepositoryConnection2.getClass();
        new AGRepositoryConnection.AttributeDefinition(aGRepositoryConnection2, this.genAttributeName()).ordered(true).maximum(5L).allowedValues(values).add();
    }

    @Test(expected=AGHttpException.class)
    @Category(value={TestSuites.Prepush.class})
    public void testOrderedSansValues() throws Exception {
        AGRepositoryConnection aGRepositoryConnection = this.conn;
        aGRepositoryConnection.getClass();
        new AGRepositoryConnection.AttributeDefinition(aGRepositoryConnection, this.genAttributeName()).ordered(true).add();
    }

    @Test(expected=RepositoryException.class)
    @Category(value={TestSuites.Prepush.class})
    public void testAddTriplesWithAttributes() throws Exception {
        AGValueFactory vf = this.conn.getRepository().getValueFactory();
        AGRepositoryConnection aGRepositoryConnection = this.conn;
        aGRepositoryConnection.getClass();
        AGRepositoryConnection.AttributeDefinition def1 = new AGRepositoryConnection.AttributeDefinition(aGRepositoryConnection, "canWork").allowedValue("AR").allowedValue("CH").allowedValue("BR").allowedValue("VZ");
        AGRepositoryConnection aGRepositoryConnection2 = this.conn;
        aGRepositoryConnection2.getClass();
        AGRepositoryConnection.AttributeDefinition def2 = new AGRepositoryConnection.AttributeDefinition(aGRepositoryConnection2, "gameImportance").allowedValue("Group").allowedValue("Quarter").allowedValue("Semi").allowedValue("Final").ordered(true);
        AGRepositoryConnection aGRepositoryConnection3 = this.conn;
        aGRepositoryConnection3.getClass();
        AGRepositoryConnection.AttributeDefinition def3 = new AGRepositoryConnection.AttributeDefinition(aGRepositoryConnection3, "note");
        def1.add();
        def2.add();
        def3.add();
        IRI ref1 = vf.createIRI("http://example.org/fifa/refs/CrookedReferee");
        IRI ref2 = vf.createIRI("http://example.org/fifa/refs/HonestReferee");
        IRI ref = vf.createIRI("http://example.org/ontology/HeadReferee");
        IRI c1 = vf.createIRI("http://example.org/fifa/copa_america");
        IRI c2 = vf.createIRI("http://example.org/fifa/copa_mundial");
        JSONObject attr1 = new JSONObject("{ canWork: [ AR, BR, null ], gameImportance: Semi, note: null }");
        JSONObject attr2 = new JSONObject("{ canWork: [ AR, CH, BR, VZ ], gameImportance: Final }");
        this.conn.add((Resource)ref1, RDF.TYPE, (Value)ref, attr1, new Resource[]{c1});
        this.conn.add((Resource)ref2, RDF.TYPE, (Value)ref, attr2, new Resource[]{c1, c2});
        Statement stmt1 = vf.createStatement((Resource)ref1, vf.createIRI(RDFS.label.getURI()), (Value)vf.createLiteral("Don't trust this ref."));
        this.conn.add(stmt1, new Resource[0]);
        JSONObject badAttrs = new JSONObject("{ canWork: [ AR, CH ], nationality: AR }");
        this.conn.add((Resource)ref2, RDF.TYPE, (Value)ref, badAttrs, new Resource[0]);
    }

    @Category(value={TestSuites.Prepush.class})
    @Test
    public void testStaticAttributeFiltersBasic() throws Exception {
        this.setupStaticAttributeFilters();
        String filter = "(and (attribute>= user.access-level triple.access-level)\n(attribute-contains-one-of user.department triple.department)\n(attribute-contains-all-of user.token triple.token))";
        String result = this.conn.getStaticAttributeFilter();
        Assert.assertNull((String)("non-null result fetching StaticFilter before one defined. Got '" + result + "'"), (Object)result);
        this.conn.setStaticAttributeFilter(filter);
        String returnedFilter = this.conn.getStaticAttributeFilter();
        Assert.assertEquals((Object)filter, (Object)returnedFilter);
        this.conn.deleteStaticAttributeFilter();
        result = this.conn.getStaticAttributeFilter();
        Assert.assertNull((String)("non-null result after deleting staticFilter. Got '" + result + "'"), (Object)result);
    }

    private void setupStaticAttributeFilters() throws Exception {
        try (AGRepositoryConnection conn = this.getConnection();){
            AGRepositoryConnection aGRepositoryConnection = conn;
            aGRepositoryConnection.getClass();
            new AGRepositoryConnection.AttributeDefinition(aGRepositoryConnection, "access-level").allowedValue("low").allowedValue("medium").allowedValue("high").ordered(true).minimum(1L).add();
            AGRepositoryConnection aGRepositoryConnection2 = conn;
            aGRepositoryConnection2.getClass();
            new AGRepositoryConnection.AttributeDefinition(aGRepositoryConnection2, "department").allowedValue("tech").allowedValue("hr").allowedValue("sales").allowedValue("accounting").add();
            AGRepositoryConnection aGRepositoryConnection3 = conn;
            aGRepositoryConnection3.getClass();
            new AGRepositoryConnection.AttributeDefinition(aGRepositoryConnection3, "token").allowedValue("A").allowedValue("B").allowedValue("C").allowedValue("D").allowedValue("E").allowedValue("F").add();
        }
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testPassingUserAttributesHeader() throws Exception {
        this.conn.close();
        cat.deleteRepository("javatest");
        cat.createRepository("javatest");
        this.conn = this.getConnection();
        JSONObject userAttrs = new JSONObject("{ access-level: medium, token: [ A, B, F ], department: sales }");
        this.conn.setUserAttributes(userAttrs);
        try {
            this.conn.size(new Resource[0]);
            Assert.fail((String)"No exception thrown when passing undefined user-attributes.");
        }
        catch (AGHttpException aGHttpException) {
            // empty catch block
        }
        this.conn.setUserAttributes((String)null);
        this.conn.size(new Resource[0]);
        this.conn.setUserAttributes(userAttrs);
        this.setupStaticAttributeFilters();
        this.conn.size(new Resource[0]);
    }
}

