/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.repository.AGRepositoryConnection;
import junit.framework.Assert;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import test.AGAbstractTest;
import test.TestSuites;
import test.Util;

public class DeleteDuplicatesTests
extends AGAbstractTest {
    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testDuplicateSuppressionPolicy() throws Exception {
        Assert.assertEquals((String)"expected false", (String)"false", (String)this.repo.getDuplicateSuppressionPolicy());
        this.repo.setDuplicateSuppressionPolicy("spog");
        Assert.assertEquals((String)"expected spog", (String)"spog", (String)this.repo.getDuplicateSuppressionPolicy());
        Util.add((RepositoryConnection)this.conn, "/test/example.nq", null, RDFFormat.NQUADS, new Resource[0]);
        Assert.assertEquals((String)"expected size 10", (long)10L, (long)this.conn.size(new Resource[0]));
        Util.add((RepositoryConnection)this.conn, "/test/example.nq", null, RDFFormat.NQUADS, new Resource[0]);
        Assert.assertEquals((String)"expected size 15", (long)15L, (long)this.conn.size(new Resource[0]));
        this.repo.setDuplicateSuppressionPolicy("spo");
        Assert.assertEquals((String)"expected spo", (String)"spo", (String)this.repo.getDuplicateSuppressionPolicy());
        this.repo.setDuplicateSuppressionPolicy("false");
        Assert.assertEquals((String)"expected false", (String)"false", (String)this.repo.getDuplicateSuppressionPolicy());
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testSPOG() throws Exception {
        Util.add((RepositoryConnection)this.conn, "/test/example.nq", null, RDFFormat.NQUADS, new Resource[0]);
        Assert.assertEquals((String)"expected size 10", (long)10L, (long)this.conn.size(new Resource[0]));
        Util.add((RepositoryConnection)this.conn, "/test/example.nq", null, RDFFormat.NQUADS, new Resource[0]);
        Assert.assertEquals((String)"expected size 20", (long)20L, (long)this.conn.size(new Resource[0]));
        RepositoryResult result = this.conn.getDuplicateStatements("spog");
        int count = 0;
        while (result.hasNext()) {
            result.next();
            ++count;
        }
        Assert.assertEquals((String)"expected duplicate count 5", (int)5, (int)count);
        this.conn.deleteDuplicates("spog");
        Assert.assertEquals((String)"expected size 15", (long)15L, (long)this.conn.size(new Resource[0]));
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testSPO() throws Exception {
        Util.add((RepositoryConnection)this.conn, "/test/example.nq", null, RDFFormat.NQUADS, new Resource[0]);
        Assert.assertEquals((String)"expected size 10", (long)10L, (long)this.conn.size(new Resource[0]));
        this.conn.add((Resource)this.vf.createIRI("http://example.org/alice/foaf.rdf#me"), RDF.TYPE, (Value)this.vf.createIRI("http://xmlns.com/foaf/0.1/Person"), new Resource[0]);
        Assert.assertEquals((String)"expected size 11", (long)11L, (long)this.conn.size(new Resource[0]));
        this.conn.deleteDuplicates("spog");
        Assert.assertEquals((String)"expected size 11", (long)11L, (long)this.conn.size(new Resource[0]));
        RepositoryResult result = this.conn.getDuplicateStatements("spo");
        int count = 0;
        while (result.hasNext()) {
            result.next();
            ++count;
        }
        Assert.assertEquals((String)"expected duplicate count 1", (int)1, (int)count);
        this.conn.deleteDuplicates("spo");
        Assert.assertEquals((String)"expected size 10", (long)10L, (long)this.conn.size(new Resource[0]));
    }

    @Test
    @Category(value={TestSuites.Broken.class})
    public void testDefault() throws Exception {
        Util.add((RepositoryConnection)this.conn, "/test/example.nq", null, RDFFormat.NQUADS, new Resource[0]);
        Assert.assertEquals((String)"expected size 10", (long)10L, (long)this.conn.size(new Resource[0]));
        this.conn.add((Resource)this.vf.createIRI("http://example.org/alice/foaf.rdf#me"), RDF.TYPE, (Value)this.vf.createIRI("http://xmlns.com/foaf/0.1/Person"), new Resource[0]);
        Assert.assertEquals((String)"expected size 11", (long)11L, (long)this.conn.size(new Resource[0]));
        this.conn.deleteDuplicates(null);
        Assert.assertEquals((String)"expected size 11", (long)11L, (long)this.conn.size(new Resource[0]));
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testCommit() throws Exception {
        Util.add((RepositoryConnection)this.conn, "/test/example.nq", null, RDFFormat.NQUADS, new Resource[0]);
        Assert.assertEquals((String)"expected size 10", (long)10L, (long)this.conn.size(new Resource[0]));
        AGRepositoryConnection conn2 = this.repo.getConnection();
        this.conn.setAutoCommit(false);
        Util.add((RepositoryConnection)this.conn, "/test/example.nq", null, RDFFormat.NQUADS, new Resource[0]);
        Assert.assertEquals((String)"expected size 20", (long)20L, (long)this.conn.size(new Resource[0]));
        this.conn.deleteDuplicates("spog");
        Assert.assertEquals((String)"expected size 15", (long)15L, (long)this.conn.size(new Resource[0]));
        Assert.assertEquals((String)"expected conn2 size 10", (long)10L, (long)conn2.size(new Resource[0]));
        this.conn.commit();
        Assert.assertEquals((String)"expected size 15", (long)15L, (long)this.conn.size(new Resource[0]));
        Assert.assertEquals((String)"expected conn2 size 15", (long)15L, (long)conn2.size(new Resource[0]));
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testRollback() throws Exception {
        Util.add((RepositoryConnection)this.conn, "/test/example.nq", null, RDFFormat.NQUADS, new Resource[0]);
        Assert.assertEquals((String)"expected size 10", (long)10L, (long)this.conn.size(new Resource[0]));
        Util.add((RepositoryConnection)this.conn, "/test/example.nq", null, RDFFormat.NQUADS, new Resource[0]);
        Assert.assertEquals((String)"expected size 20", (long)20L, (long)this.conn.size(new Resource[0]));
        AGRepositoryConnection conn2 = this.repo.getConnection();
        this.conn.setAutoCommit(false);
        this.conn.deleteDuplicates("spog");
        Assert.assertEquals((String)"expected size 15", (long)15L, (long)this.conn.size(new Resource[0]));
        Assert.assertEquals((String)"expected conn2 size 20", (long)20L, (long)conn2.size(new Resource[0]));
        this.conn.rollback();
        Assert.assertEquals((String)"expected size 20", (long)20L, (long)this.conn.size(new Resource[0]));
    }
}

