/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.repository.AGSpinFunction;
import com.franz.agraph.repository.AGSpinMagicProperty;
import com.franz.agraph.repository.AGTupleQuery;
import java.util.List;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import test.AGAbstractTest;
import test.Stmt;
import test.TestSuites;
import test.Util;

public class SpinTest
extends AGAbstractTest {
    private final String baseURI = "http://ex.org#";
    private final String kennedyNamespace = "http://www.franz.com/simple#";
    private final String ageFn = "http://ex.org#age";
    private final String parentsMP = "http://ex.org#parents";
    private IRI context;

    @Before
    public void installScripts() throws Exception {
        this.conn.setAutoCommit(true);
        this.context = this.vf.createIRI("http://www.franz.com/simple#");
        this.conn.setNamespace("ex", "http://ex.org#");
        this.conn.setNamespace("kennedy", "http://www.franz.com/simple#");
        Util.add((RepositoryConnection)this.conn, "/tutorial/java-kennedy.ntriples", "http://www.franz.com/simple#", RDFFormat.NTRIPLES, new Resource[]{this.context});
    }

    @After
    public void cleanup0() throws Exception {
    }

    @After
    public void cleanup1() throws Exception {
        this.conn.prepareHttpRepoClient().deleteHardSpinFunction("http://ex.org#age");
    }

    @After
    public void cleanup2() throws Exception {
        this.conn.prepareHttpRepoClient().deleteHardSpinMagicProperty("http://ex.org#parents");
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void spinFunction() throws Exception {
        block2: {
            try {
                Assert.fail((String)this.conn.getSpinFunction("http://ex.org#age"));
            }
            catch (Exception e) {
                if (e.getMessage().contains("http://ex.org#age is not a registered SPIN function")) break block2;
                throw e;
            }
        }
        this.conn.prepareHttpRepoClient().deleteHardSpinMagicProperty("http://ex.org#age");
        String ageFnSparql = "prefix kennedy: <http://www.franz.com/simple#>\nprefix xs: <http://www.w3.org/2001/XMLSchema#>\nselect ( (2011 - xs:int(?birthYear)) as ?age ) { ?who kennedy:birth-year ?birthYear . }";
        this.conn.putSpinFunction(new AGSpinFunction("http://ex.org#age", new String[]{"who"}, ageFnSparql));
        Assert.assertEquals((Object)ageFnSparql, (Object)this.conn.getSpinFunction("http://ex.org#age"));
        String queryString = "prefix ex: <http://ex.org#>\nprefix kennedy: <http://www.franz.com/simple#>\nprefix kennedy: <http://www.franz.com/simple#>\nprefix ex: <http://ex.org#>\nselect ?first ?last ?age ?birthYear {\n?person kennedy:first-name ?first .\n?person kennedy:last-name ?last .\n?person kennedy:birth-year ?birthYear .\nbind( ex:age( ?person ) as ?age ) .\n} order by ?age limit 2";
        AGTupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
        query.setEngine("set-based");
        SpinTest.assertSetsEqual(Stmt.stmts(new Stmt(null, null, (Value)this.vf.createLiteral("39", XMLSchema.INTEGER)), new Stmt(null, null, (Value)this.vf.createLiteral("43", XMLSchema.INTEGER))), Stmt.statementSet(query.evaluate(), null, null, "age"));
        List list = this.conn.listSpinFunctions();
        Assert.assertEquals((String)list.toString(), (long)1L, (long)list.size());
        AGSpinFunction fn = (AGSpinFunction)list.get(0);
        Assert.assertEquals((String)list.toString(), (Object)ageFnSparql, (Object)fn.getQuery());
        Assert.assertEquals((String)list.toString(), (long)1L, (long)fn.getArguments().length);
        Assert.assertEquals((String)list.toString(), (Object)"who", (Object)fn.getArguments()[0]);
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void listSpinFunctions_0args() throws Exception {
        String ageFnSparql = "prefix kennedy: <http://www.franz.com/simple#>\nprefix xs: <http://www.w3.org/2001/XMLSchema#>\nselect ( (2011 - xs:int(?birthYear)) as ?age ) { ?who kennedy:birth-year ?birthYear . }";
        this.conn.putSpinFunction(new AGSpinFunction("http://ex.org#age", null, ageFnSparql));
        Assert.assertEquals((Object)ageFnSparql, (Object)this.conn.getSpinFunction("http://ex.org#age"));
        List list = this.conn.listSpinFunctions();
        Assert.assertEquals((String)list.toString(), (long)1L, (long)list.size());
        AGSpinFunction fn = (AGSpinFunction)list.get(0);
        Assert.assertEquals((String)list.toString(), (Object)ageFnSparql, (Object)fn.getQuery());
        Assert.assertEquals((String)list.toString(), (long)0L, (long)fn.getArguments().length);
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void listSpinFunctions_2args() throws Exception {
        String ageFnSparql = "prefix kennedy: <http://www.franz.com/simple#>\nprefix xs: <http://www.w3.org/2001/XMLSchema#>\nselect ( (2011 - xs:int(?birthYear)) as ?age ) { ?who kennedy:birth-year ?birthYear . }";
        this.conn.putSpinFunction(new AGSpinFunction("http://ex.org#age", new String[]{"who", "extra"}, ageFnSparql));
        Assert.assertEquals((Object)ageFnSparql, (Object)this.conn.getSpinFunction("http://ex.org#age"));
        List list = this.conn.listSpinFunctions();
        Assert.assertEquals((String)list.toString(), (long)1L, (long)list.size());
        AGSpinFunction fn = (AGSpinFunction)list.get(0);
        Assert.assertEquals((String)list.toString(), (Object)ageFnSparql, (Object)fn.getQuery());
        Assert.assertEquals((String)list.toString(), (long)2L, (long)fn.getArguments().length);
        Assert.assertEquals((String)list.toString(), (Object)"who", (Object)fn.getArguments()[0]);
        Assert.assertEquals((String)list.toString(), (Object)"extra", (Object)fn.getArguments()[1]);
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void spinMagicProperty() throws Exception {
        block2: {
            try {
                Assert.fail((String)this.conn.getSpinMagicProperty("http://ex.org#parents"));
            }
            catch (Exception e) {
                if (e.getMessage().contains("http://ex.org#parents is not a registered SPIN magic property")) break block2;
                throw e;
            }
        }
        this.conn.prepareHttpRepoClient().deleteHardSpinMagicProperty("http://ex.org#parents");
        String parentsFnSparql = "prefix kennedy: <http://www.franz.com/simple#>\nselect ?parent { ?parent kennedy:has-child ?child . }";
        this.conn.putSpinMagicProperty(new AGSpinMagicProperty("http://ex.org#parents", new String[]{"?child"}, parentsFnSparql));
        Assert.assertEquals((Object)parentsFnSparql, (Object)this.conn.getSpinMagicProperty("http://ex.org#parents"));
        String prefixes = "prefix ex: <http://ex.org#>\nprefix kennedy: <http://www.franz.com/simple#>\n";
        String queryString = "select ?person ?parentFirst {\n?person kennedy:first-name 'Joseph' .\n?person kennedy:birth-year '1915' .\n?person ex:parents ?parent .\n?parent kennedy:first-name ?parentFirst .\n}";
        AGTupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, prefixes + queryString);
        query.setEngine("set-based");
        SpinTest.assertSetsEqual(Stmt.stmts(new Stmt(null, null, (Value)this.vf.createLiteral("Joseph")), new Stmt(null, null, (Value)this.vf.createLiteral("Rose"))), Stmt.statementSet(query.evaluate(), null, null, "parentFirst"));
        List list = this.conn.listSpinMagicProperties();
        Assert.assertEquals((String)list.toString(), (long)1L, (long)list.size());
        AGSpinMagicProperty fn = (AGSpinMagicProperty)list.get(0);
        Assert.assertEquals((String)list.toString(), (Object)parentsFnSparql, (Object)fn.getQuery());
        Assert.assertEquals((String)list.toString(), (long)1L, (long)fn.getArguments().length);
        Assert.assertEquals((String)list.toString(), (Object)"?child", (Object)fn.getArguments()[0]);
    }
}

