/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.repository.AGAbstractRepository;
import com.franz.agraph.repository.AGBooleanQuery;
import com.franz.agraph.repository.AGFreetextIndexConfig;
import com.franz.agraph.repository.AGFreetextQuery;
import com.franz.agraph.repository.AGGraphQuery;
import com.franz.agraph.repository.AGQueryLanguage;
import com.franz.agraph.repository.AGRepository;
import com.franz.agraph.repository.AGRepositoryConnection;
import com.franz.agraph.repository.AGServer;
import com.franz.agraph.repository.AGTupleQuery;
import com.franz.agraph.repository.AGValueFactory;
import com.franz.agraph.repository.AGVirtualRepository;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.OWL;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.QueryResult;
import org.eclipse.rdf4j.query.impl.DatasetImpl;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.ntriples.NTriplesWriter;
import org.eclipse.rdf4j.rio.rdfxml.RDFXMLWriter;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import test.AGAbstractTest;
import test.Stmt;
import test.TestSuites;
import test.Util;

public class TutorialTests
extends AGAbstractTest {
    static final String FOAF_NS = "http://xmlns.com/foaf/0.1/";

    public static IRI example6_setup(AGRepositoryConnection conn, AGRepository repo) throws Exception {
        conn.clear(new Resource[0]);
        conn.setAutoCommit(false);
        Assert.assertEquals((long)0L, (long)conn.size(new Resource[0]));
        AGValueFactory f = repo.getValueFactory();
        String path1 = "/tutorial/java-vcards.rdf";
        String path2 = "/tutorial/java-kennedy.ntriples";
        String baseURI = "http://example.org/example/local";
        IRI context = f.createIRI("http://example.org#vcards");
        Util.add((RepositoryConnection)conn, path1, baseURI, RDFFormat.RDFXML, new Resource[]{context});
        Util.add((RepositoryConnection)conn, path2, baseURI, RDFFormat.NTRIPLES, new Resource[0]);
        return context;
    }

    @Test
    public void example1() throws Exception {
        Assert.assertTrue((server.getVersion().length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((server.getBuildDate().length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((server.getRevision().length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((server.listCatalogs().size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"java-catalog", (Object)cat.getCatalogName());
        Assert.assertEquals((Object)"javatest", (Object)this.repo.getRepositoryID());
        Assert.assertNotNull((Object)this.repo.getRepositoryURL());
        Assert.assertTrue((boolean)this.repo.isWritable());
        Assert.assertEquals((long)0L, (long)this.conn.size(new Resource[0]));
    }

    private Map<String, Stmt> example2inputs() throws Exception {
        AGValueFactory vf = this.repo.getValueFactory();
        IRI alice = vf.createIRI("http://example.org/people/alice");
        IRI bob = vf.createIRI("http://example.org/people/bob");
        IRI name = vf.createIRI("http://example.org/ontology/name");
        IRI person = vf.createIRI("http://example.org/ontology/Person");
        Literal bobsName = vf.createLiteral("Bob");
        Literal alicesName = vf.createLiteral("Alice");
        Assert.assertEquals((long)0L, (long)this.conn.size(new Resource[0]));
        HashMap<String, Stmt> inputs = new HashMap<String, Stmt>();
        inputs.put("an", new Stmt((Resource)alice, name, (Value)alicesName));
        inputs.put("at", new Stmt((Resource)alice, RDF.TYPE, (Value)person));
        inputs.put("bn", new Stmt((Resource)bob, name, (Value)bobsName));
        inputs.put("bt", new Stmt((Resource)bob, RDF.TYPE, (Value)person));
        return inputs;
    }

    private Map<String, Stmt> example2setup() throws Exception {
        Map<String, Stmt> inputs = this.example2inputs();
        this.addAll(inputs.values(), (RepositoryConnection)this.conn);
        Assert.assertEquals((long)4L, (long)this.conn.size(new Resource[0]));
        return inputs;
    }

    @Test
    public void example2() throws Exception {
        Map<String, Stmt> inputs = this.example2setup();
        Set<Stmt> stmts = Stmt.statementSet((RepositoryResult<Statement>)this.conn.getStatements(null, null, null, false, new Resource[0]));
        TutorialTests.assertSetsEqual(inputs.values(), stmts);
        Stmt x = inputs.values().iterator().next();
        this.conn.remove((Statement)x, new Resource[0]);
        Assert.assertEquals((long)3L, (long)this.conn.size(new Resource[0]));
        this.conn.add((Statement)x, new Resource[0]);
        Assert.assertEquals((long)4L, (long)this.conn.size(new Resource[0]));
    }

    @Test
    public void example3() throws Exception {
        Map<String, Stmt> inputs = this.example2setup();
        String queryString = "SELECT ?s ?p ?o  WHERE {?s ?p ?o .}";
        AGTupleQuery tupleQuery = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
        Set<Stmt> stmts = Stmt.statementSet(tupleQuery.evaluate(), new String[0]);
        TutorialTests.assertSetsEqual(inputs.values(), stmts);
    }

    @Test
    public void example4() throws Exception {
        Map<String, Stmt> inputs = this.example2setup();
        IRI alice = this.repo.getValueFactory().createIRI("http://example.org/people/alice");
        RepositoryResult result = this.conn.getStatements((Resource)alice, null, null, false, new Resource[0]);
        result.enableDuplicateFilter();
        Set<Stmt> stmts = Stmt.statementSet((RepositoryResult<Statement>)result);
        TutorialTests.assertSetsEqual(TutorialTests.mapKeep(new String[]{"an", "at"}, inputs).values(), stmts);
    }

    @Test
    public void example5() throws Exception {
        this.example2setup();
        this.conn.clear(new Resource[0]);
        AGValueFactory f = this.repo.getValueFactory();
        String exns = "http://example.org/people/";
        IRI alice = f.createIRI("http://example.org/people/alice");
        IRI ted = f.createIRI(exns, "ted");
        IRI age = f.createIRI(exns, "age");
        IRI weight = f.createIRI(exns, "weight");
        IRI favoriteColor = f.createIRI(exns, "favoriteColor");
        IRI birthdate = f.createIRI(exns, "birthdate");
        Literal red = f.createLiteral("Red");
        Literal rouge = f.createLiteral("Rouge", "fr");
        Literal fortyTwoInt = f.createLiteral("42", XMLSchema.INT);
        Literal fortyTwoLong = f.createLiteral("42", XMLSchema.LONG);
        Literal fortyTwoUntyped = f.createLiteral("42");
        Literal date = f.createLiteral("1984-12-06", XMLSchema.DATE);
        Literal time = f.createLiteral("1984-12-06T09:00:00Z", XMLSchema.DATETIME);
        Literal weightUntyped = f.createLiteral("120.5");
        Literal weightFloat = f.createLiteral("120.5", XMLSchema.FLOAT);
        Statement stmt1 = f.createStatement((Resource)alice, age, (Value)fortyTwoInt);
        Statement stmt2 = f.createStatement((Resource)ted, age, (Value)fortyTwoLong);
        Statement stmt3 = f.createStatement((Resource)ted, age, (Value)fortyTwoUntyped);
        HashSet<Statement> inputs = new HashSet<Statement>();
        inputs.add(stmt1);
        inputs.add(stmt2);
        inputs.add(stmt3);
        inputs.add(new Stmt((Resource)alice, weight, (Value)weightFloat));
        inputs.add(new Stmt((Resource)ted, weight, (Value)weightUntyped));
        inputs.add(new Stmt((Resource)alice, favoriteColor, (Value)red));
        inputs.add(new Stmt((Resource)ted, favoriteColor, (Value)rouge));
        inputs.add(new Stmt((Resource)alice, birthdate, (Value)date));
        inputs.add(new Stmt((Resource)ted, birthdate, (Value)time));
        this.addAll(inputs, (RepositoryConnection)this.conn);
        Assert.assertEquals((long)9L, (long)this.conn.size(new Resource[0]));
        TutorialTests.assertSetsEqual(inputs, Stmt.statementSet((RepositoryResult<Statement>)this.conn.getStatements(null, null, null, false, new Resource[0])));
        for (Literal literal : new Literal[]{fortyTwoInt, fortyTwoLong, fortyTwoUntyped, weightFloat, weightUntyped, red, rouge}) {
            TutorialTests.assertSetsSome("Retrieve triples matching: " + literal, inputs, Stmt.statementSet((RepositoryResult<Statement>)this.conn.getStatements(null, null, (Value)literal, false, new Resource[0])));
        }
        for (String string : new String[]{"42", "\"42\"", "120.5", "\"120.5\"", "\"120.5\"^^xsd:float", "\"Rouge\"@fr", "\"Rouge\"", "\"1984-12-06\"^^xsd:date"}) {
            String queryString = "PREFIX xsd: <http://www.w3.org/2001/XMLSchema#> SELECT ?s ?p ?o WHERE {?s ?p ?o . filter (?o = " + string + ")}";
            AGTupleQuery tupleQuery = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
            TutorialTests.assertSetsSome("Query triples matching " + string + ".", inputs, Stmt.statementSet(tupleQuery.evaluate(), new String[0]));
        }
        TutorialTests.assertSetsEqual("Retrieve triples matching DATE object.", Stmt.stmts(new Stmt((Resource)alice, birthdate, (Value)date)), Stmt.statementSet((RepositoryResult<Statement>)this.conn.getStatements(null, null, (Value)date, false, new Resource[0])));
        TutorialTests.assertSetsEqual("Match triples having a specific DATE value.", Stmt.stmts(new Stmt((Resource)alice, birthdate, (Value)date)), Stmt.statementSet((RepositoryResult<Statement>)this.conn.getStatements(null, null, (Value)f.createLiteral("1984-12-06", XMLSchema.DATE), false, new Resource[0])));
        TutorialTests.assertSetsEqual("Retrieve triples matching DATETIME object.", Stmt.stmts(new Stmt((Resource)ted, birthdate, (Value)time)), Stmt.statementSet((RepositoryResult<Statement>)this.conn.getStatements(null, null, (Value)time, false, new Resource[0])));
        TutorialTests.assertSetsEqual("Match triples having a specific DATETIME value.", Stmt.stmts(new Stmt((Resource)ted, birthdate, (Value)time)), Stmt.statementSet((RepositoryResult<Statement>)this.conn.getStatements(null, null, (Value)f.createLiteral("1984-12-06T09:00:00Z", XMLSchema.DATETIME), false, new Resource[0])));
    }

    @Test
    public void example6() throws Exception {
        IRI context = TutorialTests.example6_setup(this.conn, this.repo);
        Assert.assertEquals((long)16L, (long)this.conn.size(new Resource[]{context}));
        Assert.assertEquals((long)1214L, (long)this.conn.size(new Resource[]{null}));
        Assert.assertEquals((long)1230L, (long)this.conn.size(new Resource[0]));
    }

    @Test
    public void example7() throws Exception {
        this.example6();
        Assert.assertEquals((long)1230L, (long)Stmt.statementSet((RepositoryResult<Statement>)this.conn.getStatements(null, null, null, false, new Resource[0])).size());
        Assert.assertEquals((long)8L, (long)Stmt.statementSet(this.conn.prepareTupleQuery(QueryLanguage.SPARQL, "SELECT DISTINCT ?s ?g WHERE {graph ?g {?s ?p ?o .} }").evaluate(), new String[0]).size());
    }

    @Test
    public void example8() throws Exception {
        cat.deleteRepository("example8");
        this.repo = cat.createRepository("example8");
        this.closeLater(this.repo);
        this.repo.initialize();
        this.conn = this.getConnection((AGAbstractRepository)this.repo);
        this.vf = this.repo.getValueFactory();
        this.example6();
        IRI context = this.repo.getValueFactory().createIRI("http://example.org#vcards");
        File outputFile = File.createTempFile(this.getClass().getSimpleName(), ".nt");
        TutorialTests.println("Writing n-triples to: " + outputFile.getCanonicalPath());
        try (FileOutputStream out = new FileOutputStream(outputFile);){
            NTriplesWriter ntriplesWriter = new NTriplesWriter((OutputStream)out);
            this.conn.export((RDFHandler)ntriplesWriter, new Resource[]{context});
        }
        TutorialTests.assertFiles(Util.resourceAsTempFile("/test/tutorial-test8-expected.nt"), outputFile);
        outputFile.delete();
        outputFile = File.createTempFile(this.getClass().getSimpleName(), ".rdf");
        TutorialTests.println("Writing RDF to: " + outputFile);
        out = new FileOutputStream(outputFile);
        var4_4 = null;
        try {
            RDFXMLWriter rdfxmlfWriter = new RDFXMLWriter((OutputStream)out);
            this.conn.export((RDFHandler)rdfxmlfWriter, new Resource[]{context});
            ((OutputStream)out).write(10);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (out != null) {
                if (var4_4 != null) {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    ((OutputStream)out).close();
                }
            }
        }
        outputFile.delete();
    }

    @Test
    public void example9() throws Exception {
        this.example6();
        File f = File.createTempFile(this.getClass().getSimpleName(), ".rdf");
        try (FileWriter out = new FileWriter(f);){
            TutorialTests.println("export to " + f.getCanonicalFile());
            this.conn.exportStatements(null, RDF.TYPE, null, false, (RDFHandler)new RDFXMLWriter((Writer)out), new Resource[0]);
        }
        TutorialTests.assertRDFFilesIsomorphic(Util.resourceAsTempFile("/test/tutorial-test9-expected.rdf"), f, RDFFormat.RDFXML);
        f.delete();
    }

    @Test
    public void example10() throws Exception {
        AGValueFactory f = this.repo.getValueFactory();
        String exns = "http://example.org/people/";
        IRI alice = f.createIRI(exns, "alice");
        IRI bob = f.createIRI(exns, "bob");
        IRI ted = f.createIRI(exns, "ted");
        IRI person = f.createIRI("http://example.org/ontology/Person");
        IRI name = f.createIRI("http://example.org/ontology/name");
        Literal alicesName = f.createLiteral("Alice");
        Literal bobsName = f.createLiteral("Bob");
        Literal tedsName = f.createLiteral("Ted");
        IRI context1 = f.createIRI(exns, "cxt1");
        IRI context2 = f.createIRI(exns, "cxt2");
        this.conn.add((Resource)alice, RDF.TYPE, (Value)person, new Resource[]{context1});
        this.conn.add((Resource)alice, name, (Value)alicesName, new Resource[]{context1});
        this.conn.add((Resource)bob, RDF.TYPE, (Value)person, new Resource[]{context2});
        this.conn.add((Resource)bob, name, (Value)bobsName, new Resource[]{context2});
        this.conn.add((Resource)ted, RDF.TYPE, (Value)person, new Resource[0]);
        this.conn.add((Resource)ted, name, (Value)tedsName, new Resource[0]);
        TutorialTests.assertSetsEqual(Stmt.stmts(new Stmt((Resource)alice, RDF.TYPE, (Value)person, (Resource)context1), new Stmt((Resource)alice, name, (Value)alicesName, (Resource)context1), new Stmt((Resource)bob, RDF.TYPE, (Value)person, (Resource)context2), new Stmt((Resource)bob, name, (Value)bobsName, (Resource)context2), new Stmt((Resource)ted, RDF.TYPE, (Value)person), new Stmt((Resource)ted, name, (Value)tedsName)), Stmt.statementSet((RepositoryResult<Statement>)this.conn.getStatements(null, null, null, false, new Resource[0])));
        TutorialTests.assertSetsEqual(Stmt.stmts(new Stmt((Resource)alice, RDF.TYPE, (Value)person, (Resource)context1), new Stmt((Resource)alice, name, (Value)alicesName, (Resource)context1), new Stmt((Resource)bob, RDF.TYPE, (Value)person, (Resource)context2), new Stmt((Resource)bob, name, (Value)bobsName, (Resource)context2)), Stmt.statementSet((RepositoryResult<Statement>)this.conn.getStatements(null, null, null, false, new Resource[]{context1, context2})));
        TutorialTests.assertSetsEqual(Stmt.stmts(new Stmt((Resource)bob, RDF.TYPE, (Value)person, (Resource)context2), new Stmt((Resource)bob, name, (Value)bobsName, (Resource)context2), new Stmt((Resource)ted, RDF.TYPE, (Value)person), new Stmt((Resource)ted, name, (Value)tedsName)), Stmt.statementSet((RepositoryResult<Statement>)this.conn.getStatements(null, null, null, false, new Resource[]{null, context2})));
        DatasetImpl ds = new DatasetImpl();
        ds.addNamedGraph(context1);
        ds.addNamedGraph(context2);
        AGTupleQuery tupleQuery = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, "SELECT ?s ?p ?o ?g WHERE { GRAPH ?g {?s ?p ?o . } }");
        tupleQuery.setDataset((Dataset)ds);
        TutorialTests.assertSetsEqual(Stmt.stmts(new Stmt((Resource)alice, RDF.TYPE, (Value)person, (Resource)context1), new Stmt((Resource)alice, name, (Value)alicesName, (Resource)context1), new Stmt((Resource)bob, RDF.TYPE, (Value)person, (Resource)context2), new Stmt((Resource)bob, name, (Value)bobsName, (Resource)context2)), Stmt.statementSet(tupleQuery.evaluate(), new String[0]));
        ds = new DatasetImpl();
        ds.addDefaultGraph(null);
        tupleQuery = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, "SELECT ?s ?p ?o WHERE {?s ?p ?o . }");
        tupleQuery.setDataset((Dataset)ds);
        TutorialTests.assertSetsEqual(Stmt.stmts(new Stmt((Resource)ted, RDF.TYPE, (Value)person), new Stmt((Resource)ted, name, (Value)tedsName)), Stmt.statementSet(tupleQuery.evaluate(), new String[0]));
    }

    @Test
    public void example11() throws Exception {
        String exns = "http://example.org/people/";
        this.conn.setNamespace("ex", exns);
        IRI alice = this.vf.createIRI(exns, "alice");
        IRI person = this.vf.createIRI(exns, "Person");
        this.conn.add((Resource)alice, RDF.TYPE, (Value)person, new Resource[0]);
        String queryString = "PREFIX ex:<" + exns + ">\n" + "SELECT ?s ?p ?o WHERE { ?s ?p ?o . FILTER ((?p = rdf:type) && (?o = ex:Person) ) }";
        TutorialTests.assertSetsEqual(Stmt.stmts(new Stmt((Resource)alice, RDF.TYPE, (Value)person)), Stmt.statementSet(this.conn.prepareTupleQuery(QueryLanguage.SPARQL, queryString).evaluate(), new String[0]));
    }

    @Test
    public void example12() throws Exception {
        AGValueFactory f = this.conn.getValueFactory();
        String exns = "http://example.org/people/";
        this.conn.setNamespace("ex", exns);
        AGFreetextIndexConfig config = AGFreetextIndexConfig.newInstance();
        IRI fullname = f.createIRI(exns, "fullname");
        config.getPredicates().add(fullname);
        this.conn.createFreetextIndex("index1", config);
        ArrayList<String> indices = new ArrayList<String>();
        indices.add("index1");
        TutorialTests.assertSetsEqual("listFreetextIndices() expects index1", indices, this.conn.listFreetextIndices());
        ArrayList<IRI> preds = new ArrayList<IRI>();
        preds.add(fullname);
        AGFreetextIndexConfig config1 = this.conn.getFreetextIndexConfig("index1");
        TutorialTests.assertSetsEqual("getPredicates() expects fullname", preds, config1.getPredicates());
        IRI alice = f.createIRI(exns, "alice1");
        IRI carroll = f.createIRI(exns, "carroll");
        IRI person = f.createIRI(exns, "Person");
        Literal alicename = f.createLiteral("Alice B. Toklas");
        Literal lewisCarroll = f.createLiteral("Lewis Carroll");
        IRI book = f.createIRI(exns, "book1");
        IRI booktype = f.createIRI(exns, "Book");
        IRI booktitle = f.createIRI(exns, "title");
        IRI author = f.createIRI(exns, "author");
        Literal wonderland = f.createLiteral("Alice in Wonderland");
        this.conn.clear(new Resource[0]);
        this.conn.add((Resource)alice, RDF.TYPE, (Value)person, new Resource[0]);
        this.conn.add((Resource)alice, fullname, (Value)alicename, new Resource[0]);
        this.conn.add((Resource)book, RDF.TYPE, (Value)booktype, new Resource[0]);
        this.conn.add((Resource)book, booktitle, (Value)wonderland, new Resource[0]);
        this.conn.add((Resource)book, author, (Value)carroll, new Resource[0]);
        this.conn.add((Resource)carroll, RDF.TYPE, (Value)person, new Resource[0]);
        this.conn.add((Resource)carroll, fullname, (Value)lewisCarroll, new Resource[0]);
        String queryString = "SELECT ?s ?p ?o WHERE { ?s ?p ?o . ?s fti:match 'Alice' . }";
        AGTupleQuery tupleQuery = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
        Set<Stmt> stmts = Stmt.stmts(new Stmt((Resource)alice, fullname, (Value)alicename), new Stmt((Resource)alice, RDF.TYPE, (Value)person));
        TutorialTests.assertSetsEqual("Whole-word match for 'Alice'.", stmts, Stmt.statementSet(tupleQuery.evaluate(), new String[0]));
        AGFreetextQuery query = new AGFreetextQuery(this.conn);
        query.setPattern("Alice");
        query.setIndex("index1");
        stmts = Stmt.stmts(new Stmt((Resource)alice, fullname, (Value)alicename));
        TutorialTests.assertSetsEqual("Whole-word match for 'Alice' another way.", stmts, Stmt.statementSet((RepositoryResult<Statement>)query.evaluate()));
        queryString = "SELECT ?s ?p ?o WHERE { ?s ?p ?o . ?s fti:match 'Ali*' . }";
        tupleQuery = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
        TutorialTests.assertSetsEqual("Wildcard match for 'Ali*'.", Stmt.stmts(new Stmt((Resource)alice, fullname, (Value)alicename), new Stmt((Resource)alice, RDF.TYPE, (Value)person)), Stmt.statementSet(tupleQuery.evaluate(), new String[0]));
        queryString = "SELECT ?s ?p ?o WHERE { ?s ?p ?o . ?s fti:match '?l?c?' . }";
        tupleQuery = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
        TutorialTests.assertSetsEqual("Wildcard match for '?l?ce?.", Stmt.stmts(new Stmt((Resource)alice, fullname, (Value)alicename), new Stmt((Resource)alice, RDF.TYPE, (Value)person)), Stmt.statementSet(tupleQuery.evaluate(), new String[0]));
        queryString = "SELECT ?s ?p ?o WHERE { ?s ?p ?o . FILTER regex(?o, \"lic\") }";
        tupleQuery = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
        TutorialTests.assertSetsEqual("Substring match for 'lic'.", Stmt.stmts(new Stmt((Resource)alice, fullname, (Value)alicename), new Stmt((Resource)book, booktitle, (Value)wonderland)), Stmt.statementSet(tupleQuery.evaluate(), new String[0]));
        config = AGFreetextIndexConfig.newInstance();
        config.getPredicates().add(author);
        config.setIndexResources("short");
        this.conn.createFreetextIndex("index2", config);
        indices.add("index2");
        TutorialTests.assertSetsEqual("listFreetextIndices() expects index1 and index2", indices, this.conn.listFreetextIndices());
        preds = new ArrayList();
        preds.add(author);
        TutorialTests.assertSetsEqual("getPredicates() expects author", preds, config.getPredicates());
        Assert.assertEquals((String)"getIndexResources() expects short", (Object)"short", (Object)config.getIndexResources());
        query = new AGFreetextQuery(this.conn);
        query.setPattern("Carroll");
        query.setIndex("index2");
        stmts = Stmt.stmts(new Stmt((Resource)book, author, (Value)carroll));
        TutorialTests.assertSetsEqual("Search for Carroll on index2", stmts, Stmt.statementSet((RepositoryResult<Statement>)query.evaluate()));
        this.conn.deleteFreetextIndex("index1");
        indices.remove("index1");
        TutorialTests.assertSetsEqual("listFreetextIndices() expects index2", indices, this.conn.listFreetextIndices());
    }

    @Test
    public void example13() throws Exception {
        Map<String, Stmt> inputs = this.example2setup();
        this.conn.setNamespace("ex", "http://example.org/people/");
        this.conn.setNamespace("ont", "http://example.org/ontology/");
        String prefix = "PREFIX ont: <http://example.org/ontology/>\n";
        String queryString = "select ?s ?p ?o where { ?s ?p ?o} ";
        AGTupleQuery tupleQuery = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
        TutorialTests.assertSetsEqual("SELECT result:", inputs.values(), Stmt.statementSet(tupleQuery.evaluate(), new String[0]));
        AGBooleanQuery booleanQuery = this.conn.prepareBooleanQuery(QueryLanguage.SPARQL, prefix + "ask { ?s ont:name \"Alice\" } ");
        Assert.assertTrue((String)"Boolean result", (boolean)booleanQuery.evaluate());
        Assert.assertFalse((String)"Boolean result", (boolean)this.conn.prepareBooleanQuery(QueryLanguage.SPARQL, prefix + "ask { ?s ont:name \"NOT Alice\" } ").evaluate());
        queryString = "construct {?s ?p ?o} where { ?s ?p ?o . filter (?o = \"Alice\") } ";
        AGGraphQuery constructQuery = this.conn.prepareGraphQuery(QueryLanguage.SPARQL, queryString);
        TutorialTests.assertSetsEqual("Construct result", TutorialTests.mapKeep(new String[]{"an"}, inputs).values(), Stmt.statementSet((QueryResult<Statement>)constructQuery.evaluate()));
        queryString = "describe ?s where { ?s ?p ?o . filter (?o = \"Alice\") } ";
        AGGraphQuery describeQuery = this.conn.prepareGraphQuery(QueryLanguage.SPARQL, queryString);
        TutorialTests.assertSetsEqual("Describe result", TutorialTests.mapKeep(new String[]{"an", "at"}, inputs).values(), Stmt.statementSet((QueryResult<Statement>)describeQuery.evaluate()));
    }

    @Test
    public void example14() throws Exception {
        Map<String, Stmt> inputs = this.example2setup();
        AGValueFactory f = this.conn.getValueFactory();
        this.conn.setAutoCommit(false);
        IRI alice = f.createIRI("http://example.org/people/alice");
        IRI bob = f.createIRI("http://example.org/people/bob");
        String queryString = "select ?s ?p ?o where { ?s ?p ?o} ";
        AGTupleQuery tupleQuery = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
        tupleQuery.setBinding("s", (Value)alice);
        TutorialTests.assertSetsEqual("Facts about Alice", TutorialTests.mapKeep(new String[]{"an", "at"}, inputs).values(), Stmt.statementSet(tupleQuery.evaluate(), new String[0]));
        tupleQuery.setBinding("s", (Value)bob);
        TutorialTests.assertSetsEqual("Facts about Bob", TutorialTests.mapKeep(new String[]{"bn", "bt"}, inputs).values(), Stmt.statementSet(tupleQuery.evaluate(), new String[0]));
    }

    @Test
    public void example15() throws Exception {
        AGValueFactory f = this.conn.getValueFactory();
        this.conn.clear(new Resource[0]);
        String exns = "http://example.org/people/";
        this.conn.setNamespace("ex", exns);
        IRI alice = f.createIRI(exns, "alice");
        IRI bob = f.createIRI(exns, "bob");
        IRI carol = f.createIRI(exns, "carol");
        IRI age = f.createIRI(exns, "age");
        Literal l42 = f.createLiteral(42);
        this.conn.add((Resource)alice, age, (Value)l42, new Resource[0]);
        Literal l451 = f.createLiteral(45.1);
        this.conn.add((Resource)bob, age, (Value)l451, new Resource[0]);
        Literal l39 = f.createLiteral("39");
        this.conn.add((Resource)carol, age, (Value)l39, new Resource[0]);
        TutorialTests.assertSetsEqual("Range query for integers and floats.", Stmt.stmts(new Stmt((Resource)bob, age, (Value)l451), new Stmt((Resource)alice, age, (Value)l42)), Stmt.statementSet(this.conn.prepareTupleQuery(QueryLanguage.SPARQL, "SELECT ?s ?p ?o  WHERE { ?s ?p ?o . FILTER ((?o >= 30) && (?o <= 50)) }").evaluate(), new String[0]));
        TutorialTests.assertSetsEqual("Range query for integers, floats, and integers in strings.", Stmt.stmts(new Stmt((Resource)bob, age, (Value)l451), new Stmt((Resource)alice, age, (Value)l42), new Stmt((Resource)carol, age, (Value)l39)), Stmt.statementSet(this.conn.prepareTupleQuery(QueryLanguage.SPARQL, "PREFIX xsd: <http://www.w3.org/2001/XMLSchema#> SELECT ?s ?p ?o  WHERE { ?s ?p ?o . FILTER ((xsd:integer(?o) >= 30) && (xsd:integer(?o) <= 50)) }").evaluate(), new String[0]));
    }

    @Test
    public void example16() throws Exception {
        this.example6();
        AGRepository redRepo = cat.createRepository("redthingsjv-ex16");
        this.closeLater(redRepo);
        redRepo.initialize();
        AGRepositoryConnection redConn = this.getConnection((AGAbstractRepository)redRepo);
        redConn.clear(new Resource[0]);
        AGValueFactory rf = redConn.getValueFactory();
        AGRepository greenRepo = cat.createRepository("greenthingsjv-ex16");
        this.closeLater(greenRepo);
        greenRepo.initialize();
        AGRepositoryConnection greenConn = this.getConnection((AGAbstractRepository)greenRepo);
        greenConn.clear(new Resource[0]);
        AGValueFactory gf = greenConn.getValueFactory();
        AGServer server = cat.getServer();
        AGVirtualRepository rainbowRepo = server.federate(new AGAbstractRepository[]{redRepo, greenRepo});
        this.closeLater(rainbowRepo);
        rainbowRepo.initialize();
        Assert.assertFalse((String)"Federation is writable?", (boolean)rainbowRepo.isWritable());
        AGRepositoryConnection rainbowConn = this.getConnection((AGAbstractRepository)rainbowRepo);
        String ex = "http://example.org/";
        IRI mac = rf.createIRI(ex + "mcintosh");
        redConn.add((Resource)mac, RDF.TYPE, (Value)rf.createIRI(ex + "Apple"), new Resource[0]);
        IRI red = rf.createIRI(ex + "reddelicious");
        redConn.add((Resource)red, RDF.TYPE, (Value)rf.createIRI(ex + "Apple"), new Resource[0]);
        IRI pippen = gf.createIRI(ex + "pippin");
        greenConn.add((Resource)pippen, RDF.TYPE, (Value)gf.createIRI(ex + "Apple"), new Resource[0]);
        IRI kermit = gf.createIRI(ex + "kermitthefrog");
        greenConn.add((Resource)kermit, RDF.TYPE, (Value)gf.createIRI(ex + "Frog"), new Resource[0]);
        redConn.setNamespace("ex", ex);
        greenConn.setNamespace("ex", ex);
        rainbowConn.setNamespace("ex", ex);
        String queryString = "select ?s where { ?s rdf:type ex:Apple }";
        TutorialTests.assertSetsEqual("Red", Stmt.stmts(new Stmt((Resource)mac, null, null), new Stmt((Resource)red, null, null)), Stmt.statementSet(redConn.prepareTupleQuery(QueryLanguage.SPARQL, queryString).evaluate(), new String[0]));
        TutorialTests.assertSetsEqual("Green", Stmt.stmts(new Stmt((Resource)pippen, null, null)), Stmt.statementSet(greenConn.prepareTupleQuery(QueryLanguage.SPARQL, queryString).evaluate(), new String[0]));
        TutorialTests.assertSetsEqual("Federated", Stmt.stmts(new Stmt((Resource)red, null, null), new Stmt((Resource)mac, null, null), new Stmt((Resource)pippen, null, null)), Stmt.statementSet(rainbowConn.prepareTupleQuery(QueryLanguage.SPARQL, queryString).evaluate(), new String[0]));
    }

    @Test
    public void example17() throws Exception {
        this.example6();
        this.conn.setNamespace("kdy", "http://www.franz.com/simple#");
        String rules1 = "(<-- (woman ?person) ;; IF\n     (q ?person !kdy:sex !kdy:female)\n     (q ?person !rdf:type !kdy:person))\n(<-- (man ?person) ;; IF\n     (q ?person !kdy:sex !kdy:male)\n     (q ?person !rdf:type !kdy:person))";
        this.conn.addRules(rules1);
        String queryString = "(select (?first ?last)\n        (man ?person)\n        (q ?person !kdy:first-name ?first)\n        (q ?person !kdy:last-name ?last))";
        AGTupleQuery tupleQuery = this.conn.prepareTupleQuery((QueryLanguage)AGQueryLanguage.PROLOG, queryString);
        Assert.assertEquals((long)38L, (long)Stmt.statementSet(tupleQuery.evaluate(), new String[0]).size());
    }

    @Test
    public void example18() throws Exception {
        this.example6();
        this.conn.setNamespace("kdy", "http://www.franz.com/simple#");
        this.conn.setNamespace("rltv", "http://www.franz.com/simple#");
        this.conn.addRules(Util.resourceAsStream("/tutorial/java-rules.txt"));
        String queryString = "(select (?ufirst ?ulast ?cfirst ?clast)(uncle ?uncle ?child)(name ?uncle ?ufirst ?ulast)(name ?child ?cfirst ?clast))";
        AGTupleQuery tupleQuery = this.conn.prepareTupleQuery((QueryLanguage)AGQueryLanguage.PROLOG, queryString);
        Assert.assertEquals((long)52L, (long)Stmt.statementSet(tupleQuery.evaluate(), new String[0]).size());
    }

    @Test
    public void example19() throws Exception {
        AGValueFactory f = this.conn.getValueFactory();
        IRI robert = f.createIRI("http://example.org/people/robert");
        IRI roberta = f.createIRI("http://example.org/people/roberta");
        IRI bob = f.createIRI("http://example.org/people/bob");
        IRI bobby = f.createIRI("http://example.org/people/bobby");
        IRI name = f.createIRI("http://example.org/ontology/name");
        IRI fatherOf = f.createIRI("http://example.org/ontology/fatherOf");
        IRI person = f.createIRI("http://example.org/ontology/Person");
        Literal bobsName = f.createLiteral("Bob");
        Literal bobbysName = f.createLiteral("Bobby");
        Literal robertsName = f.createLiteral("Robert");
        Literal robertasName = f.createLiteral("Roberta");
        this.conn.add((Resource)bob, OWL.SAMEAS, (Value)robert, new Resource[0]);
        this.conn.add((Resource)robert, RDF.TYPE, (Value)person, new Resource[0]);
        this.conn.add((Resource)roberta, RDF.TYPE, (Value)person, new Resource[0]);
        this.conn.add((Resource)bob, RDF.TYPE, (Value)person, new Resource[0]);
        this.conn.add((Resource)bobby, RDF.TYPE, (Value)person, new Resource[0]);
        this.conn.add((Resource)robert, name, (Value)robertsName, new Resource[0]);
        this.conn.add((Resource)roberta, name, (Value)robertasName, new Resource[0]);
        this.conn.add((Resource)bob, name, (Value)bobsName, new Resource[0]);
        this.conn.add((Resource)bobby, name, (Value)bobbysName, new Resource[0]);
        this.conn.add((Resource)robert, fatherOf, (Value)roberta, new Resource[0]);
        this.conn.add((Resource)bob, fatherOf, (Value)bobby, new Resource[0]);
        TutorialTests.assertSetsEqual("Children of Robert, inference OFF", Stmt.stmts(new Stmt((Resource)robert, fatherOf, (Value)roberta)), Stmt.statementSet((RepositoryResult<Statement>)this.conn.getStatements((Resource)robert, fatherOf, null, false, new Resource[0])));
        TutorialTests.assertSetsEqual("Children of Robert, inference ON", Stmt.stmts(new Stmt((Resource)robert, fatherOf, (Value)roberta), new Stmt((Resource)robert, fatherOf, (Value)bobby)), Stmt.statementSet((RepositoryResult<Statement>)this.conn.getStatements((Resource)robert, fatherOf, null, true, new Resource[0])));
        this.conn.remove((Resource)bob, OWL.SAMEAS, (Value)robert, new Resource[0]);
        IRI hasFather = f.createIRI("http://example.org/ontology/hasFather");
        this.conn.add((Resource)hasFather, OWL.INVERSEOF, (Value)fatherOf, new Resource[0]);
        TutorialTests.assertSetsEqual("People with fathers, inference OFF", Stmt.stmts(new Stmt[0]), Stmt.statementSet((RepositoryResult<Statement>)this.conn.getStatements(null, hasFather, null, false, new Resource[0])));
        TutorialTests.assertSetsEqual("People with fathers, inference ON", Stmt.stmts(new Stmt((Resource)roberta, hasFather, (Value)robert), new Stmt((Resource)bobby, hasFather, (Value)bob)), Stmt.statementSet((RepositoryResult<Statement>)this.conn.getStatements(null, hasFather, null, true, new Resource[0])));
        this.conn.remove((Resource)hasFather, OWL.INVERSEOF, (Value)fatherOf, new Resource[0]);
        IRI parentOf = f.createIRI("http://example.org/ontology/parentOf");
        this.conn.add((Resource)fatherOf, RDFS.SUBPROPERTYOF, (Value)parentOf, new Resource[0]);
        TutorialTests.assertSetsEqual("People with parents, inference OFF", Stmt.stmts(new Stmt[0]), Stmt.statementSet((RepositoryResult<Statement>)this.conn.getStatements(null, parentOf, null, false, new Resource[0])));
        TutorialTests.assertSetsEqual("People with parents, inference ON", Stmt.stmts(new Stmt((Resource)robert, parentOf, (Value)roberta), new Stmt((Resource)bob, parentOf, (Value)bobby)), Stmt.statementSet((RepositoryResult<Statement>)this.conn.getStatements(null, parentOf, null, true, new Resource[0])));
        this.conn.remove((Resource)fatherOf, RDFS.SUBPROPERTYOF, (Value)parentOf, new Resource[0]);
        IRI parent = f.createIRI("http://example.org/ontology/Parent");
        IRI child = f.createIRI("http://exmaple.org/ontology/Child");
        this.conn.add((Resource)fatherOf, RDFS.DOMAIN, (Value)parent, new Resource[0]);
        this.conn.add((Resource)fatherOf, RDFS.RANGE, (Value)child, new Resource[0]);
        TutorialTests.assertSetsEqual("Who are the parents?  Inference ON.", Stmt.stmts(new Stmt((Resource)robert, RDF.TYPE, (Value)parent), new Stmt((Resource)bob, RDF.TYPE, (Value)parent)), Stmt.statementSet((RepositoryResult<Statement>)this.conn.getStatements(null, RDF.TYPE, (Value)parent, true, new Resource[0])));
        TutorialTests.assertSetsEqual("Who are the children?  Inference ON.", Stmt.stmts(new Stmt((Resource)roberta, RDF.TYPE, (Value)child), new Stmt((Resource)bobby, RDF.TYPE, (Value)child)), Stmt.statementSet((RepositoryResult<Statement>)this.conn.getStatements(null, RDF.TYPE, (Value)child, true, new Resource[0])));
    }

    @Test
    public void example20() throws Exception {
        AGValueFactory vf = this.conn.getValueFactory();
        this.conn.clear(new Resource[0]);
        String exns = "http://example.org/people/";
        this.conn.setNamespace("ex", exns);
        IRI alice = vf.createIRI(exns, "alice");
        IRI bob = vf.createIRI(exns, "bob");
        IRI carol = vf.createIRI(exns, "carol");
        IRI cartSystem = this.conn.registerCartesianType(10.0f, 0.0f, 100.0f, 0.0f, 100.0f);
        IRI location = vf.createIRI(exns, "location");
        Literal alice_loc = vf.createLiteral("+30.0+30.0", cartSystem);
        Literal bob_loc = vf.createLiteral("+40.0+40.0", cartSystem);
        Literal carol_loc = vf.createLiteral("+50.0+50.0", cartSystem);
        this.conn.add((Resource)alice, location, (Value)alice_loc, new Resource[0]);
        this.conn.add((Resource)bob, location, (Value)bob_loc, new Resource[0]);
        this.conn.add((Resource)carol, location, (Value)carol_loc, new Resource[0]);
        TutorialTests.assertSetsEqual("Find people located within box1.", Stmt.stmts(new Stmt((Resource)alice, location, null), new Stmt((Resource)bob, location, null)), Stmt.stmtsSP(Stmt.statementSet((RepositoryResult<Statement>)this.conn.getStatementsInBox(cartSystem, location, 20.0f, 40.0f, 20.0f, 40.0f, 0, false))));
        TutorialTests.assertSetsEqual("Find people located within circle1.", Stmt.stmts(new Stmt((Resource)alice, location, null), new Stmt((Resource)bob, location, null)), Stmt.stmtsSP(Stmt.statementSet((RepositoryResult<Statement>)this.conn.getStatementsInCircle(cartSystem, location, 35.0f, 35.0f, 10.0f, 0, false))));
        IRI polygon1 = vf.createIRI("http://example.org/polygon1");
        ArrayList<Literal> polygon1_points = new ArrayList<Literal>(4);
        polygon1_points.add(vf.createLiteral("+10.0+40.0", cartSystem));
        polygon1_points.add(vf.createLiteral("+50.0+10.0", cartSystem));
        polygon1_points.add(vf.createLiteral("+35.0+40.0", cartSystem));
        polygon1_points.add(vf.createLiteral("+50.0+70.0", cartSystem));
        this.conn.registerPolygon(polygon1, polygon1_points);
        TutorialTests.assertSetsEqual("Find people located within ploygon1.", Stmt.stmts(new Stmt((Resource)alice, location, null)), Stmt.stmtsSP(Stmt.statementSet((RepositoryResult<Statement>)this.conn.getStatementsInPolygon(cartSystem, location, polygon1, 0, false))));
        IRI sphericalSystemDegree = this.conn.registerSphericalType(5.0f, "degree");
        IRI amsterdam = vf.createIRI(exns, "amsterdam");
        IRI london = vf.createIRI(exns, "london");
        IRI sanfrancisco = vf.createIRI(exns, "sanfrancisco");
        IRI salvador = vf.createIRI(exns, "salvador");
        location = vf.createIRI(exns, "geolocation");
        this.conn.add((Resource)amsterdam, location, (Value)vf.createLiteral("+52.366665+004.883333", sphericalSystemDegree), new Resource[0]);
        this.conn.add((Resource)london, location, (Value)vf.createLiteral("+51.533333-000.08333333", sphericalSystemDegree), new Resource[0]);
        this.conn.add((Resource)sanfrancisco, location, (Value)vf.createLiteral("+37.783333-122.433334", sphericalSystemDegree), new Resource[0]);
        this.conn.add((Resource)salvador, location, (Value)vf.createLiteral("+13.783333-088.45", sphericalSystemDegree), new Resource[0]);
        TutorialTests.assertSetsEqual("Locate entities within box2.", Stmt.stmts(new Stmt((Resource)sanfrancisco, location, null)), Stmt.stmtsSP(Stmt.statementSet((RepositoryResult<Statement>)this.conn.getStatementsInBox(sphericalSystemDegree, location, -130.0f, -70.0f, 25.0f, 50.0f, 0, false))));
        TutorialTests.assertSetsEqual("Locate entities within haversine circle.", Stmt.stmts(new Stmt((Resource)salvador, location, null)), Stmt.stmtsSP(Stmt.statementSet((RepositoryResult<Statement>)this.conn.getGeoHaversine(sphericalSystemDegree, location, 19.3994f, -99.08f, 2000.0f, "km", 0, false))));
        IRI polygon2 = vf.createIRI("http://example.org/polygon2");
        ArrayList<Literal> polygon2_points = new ArrayList<Literal>(3);
        polygon2_points.add(vf.createLiteral("+51.0+002.0", sphericalSystemDegree));
        polygon2_points.add(vf.createLiteral("+60.0-005.0", sphericalSystemDegree));
        polygon2_points.add(vf.createLiteral("+48.0-012.5", sphericalSystemDegree));
        this.conn.registerPolygon(polygon2, polygon2_points);
        TutorialTests.assertSetsEqual("Locate entities within polygon2.", Stmt.stmts(new Stmt((Resource)london, location, null)), Stmt.stmtsSP(Stmt.statementSet((RepositoryResult<Statement>)this.conn.getStatementsInPolygon(sphericalSystemDegree, location, polygon2, 0, false))));
    }

    void assert21(String msg, Collection expected, String prolog, String ... bindings) throws Exception {
        TutorialTests.assertSetsEqual(msg, expected, Stmt.statementSet(this.conn.prepareTupleQuery((QueryLanguage)AGQueryLanguage.PROLOG, prolog).evaluate(), bindings));
    }

    @Category(value={TestSuites.Broken.class})
    @Test
    public void example21() throws Exception {
        AGValueFactory vf = this.repo.getValueFactory();
        Util.add((RepositoryConnection)this.conn, "/tutorial/lesmis.rdf", null, RDFFormat.RDFXML, new Resource[0]);
        Assert.assertEquals((String)"Loaded lesmis.rdf triples.", (long)916L, (long)this.conn.size(new Resource[0]));
        String lmns = "http://www.franz.com/lesmis#";
        this.conn.setNamespace("lm", lmns);
        String dc = "http://purl.org/dc/elements/1.1/";
        this.conn.setNamespace("dc", dc);
        IRI knows = vf.createIRI(lmns, "knows");
        IRI barelyKnows = vf.createIRI(lmns, "barely_knows");
        IRI knowsWell = vf.createIRI(lmns, "knows_well");
        IRI valjean = vf.createIRI(lmns, "character11");
        ArrayList intimates = new ArrayList(1);
        Collections.addAll(intimates, knowsWell);
        this.conn.registerSNAGenerator("intimates", null, null, intimates, null);
        ArrayList associates = new ArrayList(2);
        Collections.addAll(associates, knowsWell, knows);
        this.conn.registerSNAGenerator("associates", null, null, associates, null);
        ArrayList everyone = new ArrayList(3);
        Collections.addAll(everyone, knowsWell, knows, barelyKnows);
        this.conn.registerSNAGenerator("everyone", null, null, everyone, null);
        ArrayList<IRI> startNodes = new ArrayList<IRI>(1);
        startNodes.add(valjean);
        this.conn.registerSNANeighborMatrix("matrix1", "intimates", startNodes, 2);
        this.conn.registerSNANeighborMatrix("matrix2", "associates", startNodes, 5);
        this.conn.registerSNANeighborMatrix("matrix3", "everyone", startNodes, 2);
        Set<Stmt> valjeansEgoGroup = Stmt.stmts(new Stmt((Resource)vf.createIRI(lmns, "character11"), null, (Value)vf.createLiteral("Valjean")), new Stmt((Resource)vf.createIRI(lmns, "character23"), null, (Value)vf.createLiteral("Fantine")), new Stmt((Resource)vf.createIRI(lmns, "character24"), null, (Value)vf.createLiteral("MmeThenardier")), new Stmt((Resource)vf.createIRI(lmns, "character25"), null, (Value)vf.createLiteral("Thenardier")), new Stmt((Resource)vf.createIRI(lmns, "character26"), null, (Value)vf.createLiteral("Cosette")), new Stmt((Resource)vf.createIRI(lmns, "character27"), null, (Value)vf.createLiteral("Javert")), new Stmt((Resource)vf.createIRI(lmns, "character28"), null, (Value)vf.createLiteral("Fauchelevent")), new Stmt((Resource)vf.createIRI(lmns, "character55"), null, (Value)vf.createLiteral("Marius")));
        this.assert21("Valjean's ego group members (using associates).", valjeansEgoGroup, "(select (?member ?name)(ego-group-member !lm:character11 1 associates ?member)(q ?member !dc:title ?name))", "member", null, "name");
        this.assert21("Valjean's ego group (using associates matrix).", valjeansEgoGroup, "(select (?member ?name)(ego-group-member !lm:character11 1 matrix2 ?member)(q ?member !dc:title ?name))", "member", null, "name");
        this.assert21("Valjean's ego group in one list depth 1 (using associates).", null, "(select (?group)(ego-group !lm:character11 1 associates ?group))", "group");
        this.assert21("Valjean's ego group in one list depth 2 (using associates).", null, "(select (?group)(ego-group !lm:character11 2 associates ?group))", "group");
        this.assert21("Valjean's ego group in one list depth 3 (using associates).", null, "(select (?group)(ego-group !lm:character11 3 associates ?group))", "group");
        this.assert21("Shortest breadth-first path connecting Valjean to Bossuet using intimates. (Should be no path.)", null, "(select (?path)(breadth-first-search-paths !lm:character11 !lm:character64 intimates 10 ?path))", "path");
        this.assert21("Shortest breadth-first path connecting Valjean to Bossuet using associates.", null, "(select (?path)(breadth-first-search-paths !lm:character11 !lm:character64 associates 10 ?path))", "path");
        this.assert21("Shortest breadth-first path connecting Valjean to Bossuet using everyone.", null, "(select (?path)(breadth-first-search-paths !lm:character11 !lm:character64 everyone 10 ?path))", "path");
        this.assert21("Shortest breadth-first path connecting Valjean to Bossuet using associates (should be two).", null, "(select (?path)(breadth-first-search-paths !lm:character11 !lm:character64 associates ?path))", "path");
        this.assert21("Return depth-first path connecting Valjean to Bossuet using associates (should be one).", null, "(select (?path)(depth-first-search-path !lm:character11 !lm:character64 associates 10 ?path))", "path");
        this.assert21("Shortest bidirectional path connecting Valjean to Bossuet using associates (should be two).", null, "(select (?path)(bidirectional-search-paths !lm:character11 !lm:character64 associates ?path))", "path");
        this.assert21("Nodal degree of Valjean (should be seven).", null, "(select (?degree)(nodal-degree !lm:character11 associates ?degree))", "degree");
        this.assert21("How many neighbors are around Valjean? (should be 36).", null, "(select (?neighbors)(nodal-degree !lm:character11 everyone ?neighbors))", "neighbors");
        this.assert21("Who are Valjean's neighbors? (using everyone).", null, "(select (?name)(nodal-neighbors !lm:character11 everyone ?member)(q ?member !dc:title ?name))", "name");
        this.assert21("Graph density of Valjean's ego group? (using associates).", null, "(select (?density)(ego-group !lm:character11 1 associates ?group)(graph-density ?group associates ?density))", "density");
        this.assert21("Valjean's cliques? Should be two (using associates).", null, "(select (?clique)(clique !lm:character11 associates ?clique))", "clique");
        this.assert21("Valjean's actor-degree-centrality to his ego group at depth 1 (using associates).", null, "(select (?centrality)(ego-group !lm:character11 1 associates ?group)(actor-degree-centrality !lm:character11 ?group associates ?centrality))", "centrality");
        this.assert21("Valjean's actor-degree-centrality to his ego group at depth 2 (using associates).", null, "(select (?centrality)(ego-group !lm:character11 2 associates ?group)(actor-degree-centrality !lm:character11 ?group associates ?centrality))", "centrality");
        this.assert21("Valjean's actor-closeness-centrality to his ego group at depth 1 (using associates).", null, "(select (?centrality)(ego-group !lm:character11 1 associates ?group)(actor-closeness-centrality !lm:character11 ?group associates ?centrality))", "centrality");
        this.assert21("Valjean's actor-closeness-centrality to his ego group at depth 2 (using associates).", null, "(select (?centrality)(ego-group !lm:character11 2 associates ?group)(actor-closeness-centrality !lm:character11 ?group associates ?centrality))", "centrality");
        this.assert21("\nValjean's actor-betweenness-centrality to his ego group at depth 2 (using associates).", null, "(select (?centrality)(ego-group !lm:character11 2 associates ?group)(actor-betweenness-centrality !lm:character11 ?group associates ?centrality))", "centrality");
        this.assert21("Group-degree-centrality of Valjean's ego group at depth 1 (using associates).", null, "(select (?centrality)(ego-group !lm:character11 1 associates ?group)(group-degree-centrality ?group associates ?centrality))", "centrality");
        this.assert21("Group-degree-centrality of Valjean's ego group at depth 2 (using associatese).", null, "(select (?centrality)(ego-group !lm:character11 2 associates ?group)(group-degree-centrality ?group associates ?centrality))", "centrality");
        this.assert21("Group-closeness-centrality of Valjean's ego group at depth 1 (using associates).", null, "(select (?centrality)(ego-group !lm:character11 1 associates ?group)(group-closeness-centrality ?group associates ?centrality))", "centrality");
        this.assert21("Group-closeness-centrality of Valjean's ego group at depth 2 (using associates).", null, "(select (?centrality)(ego-group !lm:character11 2 associates ?group)(group-closeness-centrality ?group associates ?centrality))", "centrality");
        this.assert21("Group-betweenness-centrality of Valjean's ego group at depth 1 (using associates).", null, "(select (?centrality)(ego-group !lm:character11 1 associates ?group)(group-betweenness-centrality ?group associates ?centrality))", "centrality");
        this.assert21("Group-betweenness-centrality of Valjean's ego group at depth 1 (using associates).", null, "(select (?centrality)(ego-group !lm:character11 2 associates ?group)(group-betweenness-centrality ?group associates ?centrality))", "centrality");
    }

    private void assert22(String msg, Stmt expected, AGRepositoryConnection conn, Value obj) throws Exception {
        TutorialTests.assertSetsEqual(msg, Stmt.stmts(expected), Stmt.statementSet((RepositoryResult<Statement>)conn.getStatements(null, null, obj, false, new Resource[0])));
    }

    private void assert22k(String msg, Stmt expected, AGRepositoryConnection conn, IRI pred, Value obj) throws Exception {
        TutorialTests.assertSetsSome(msg, Stmt.stmts(expected), Stmt.dropSubjects(Stmt.statementSet((RepositoryResult<Statement>)conn.getStatements(null, pred, obj, false, new Resource[0]))));
    }

    @Test
    public void example22() throws Exception {
        AGValueFactory vf = this.repo.getValueFactory();
        try (AGRepositoryConnection conLesmis = this.getConnection();
             AGRepositoryConnection conKennedy = this.getConnection();){
            conLesmis.clear(new Resource[0]);
            conKennedy.setAutoCommit(false);
            String baseURI = "http://example.org/example/local";
            Util.add((RepositoryConnection)conLesmis, "/tutorial/lesmis.rdf", baseURI, RDFFormat.RDFXML, new Resource[0]);
            Assert.assertEquals((String)"Loaded lesmis.rdf triples via conn1.", (long)916L, (long)conLesmis.size(new Resource[0]));
            Util.add((RepositoryConnection)conKennedy, "/tutorial/java-kennedy.ntriples", baseURI, RDFFormat.NTRIPLES, new Resource[0]);
            Assert.assertEquals((String)"Loaded java-kennedy.ntriples via conn2.", (long)1214L, (long)conKennedy.size(new Resource[0]));
            Literal valjean = vf.createLiteral("Valjean");
            Literal kennedy = vf.createLiteral("Kennedy");
            String lmns = "http://www.franz.com/lesmis#";
            IRI char11 = vf.createIRI(lmns, "character11");
            IRI title = vf.createIRI("http://purl.org/dc/elements/1.1/title");
            IRI lastname = vf.createIRI("http://www.franz.com/simple#last-name");
            this.assert22("Using getStatements() on conn1; should find Valjean:", new Stmt((Resource)char11, title, (Value)valjean), conLesmis, (Value)valjean);
            this.assert22("Using getStatements() on conn1; should not find Kennedys:", null, conLesmis, (Value)kennedy);
            this.assert22("Using getStatements() on conn2; should not find Valjean (until a rollback or commit occurs on conn2):", null, conKennedy, (Value)valjean);
            this.assert22k("Using getStatements() on conn2; should find Kennedys:", new Stmt(null, lastname, (Value)kennedy), conKennedy, lastname, (Value)kennedy);
            conKennedy.rollback();
            conKennedy.setAutoCommit(false);
            Assert.assertEquals((String)"There are now triples visible via conn2.", (long)916L, (long)conKennedy.size(new Resource[0]));
            this.assert22("Using getStatements() on conn1; should find Valjean:", new Stmt((Resource)char11, title, (Value)valjean), conLesmis, (Value)valjean);
            this.assert22("Using getStatements() on conn1; should not find Kennedys:", null, conLesmis, (Value)kennedy);
            this.assert22("Using getStatements() on conn2; should not find Kennedys:", null, conKennedy, (Value)kennedy);
            this.assert22("Using getStatements() on conn2; should find Valjean:", new Stmt((Resource)char11, title, (Value)valjean), conKennedy, (Value)valjean);
            Util.add((RepositoryConnection)conKennedy, "/tutorial/java-kennedy.ntriples", baseURI, RDFFormat.NTRIPLES, new Resource[0]);
            Assert.assertEquals((String)"There are now triples visible on conn1.", (long)916L, (long)conLesmis.size(new Resource[0]));
            Assert.assertEquals((String)"There are now triples visible on conn2.", (long)2130L, (long)conKennedy.size(new Resource[0]));
            conKennedy.commit();
            Assert.assertEquals((String)"There are now triples visible on conn1.", (long)2130L, (long)conLesmis.size(new Resource[0]));
            Assert.assertEquals((String)"There are now triples visible on conn2.", (long)2130L, (long)conKennedy.size(new Resource[0]));
            this.assert22("Using getStatements() on conn1; should find Valjean:", new Stmt((Resource)char11, title, (Value)valjean), conLesmis, (Value)valjean);
            this.assert22k("Using getStatements() on conn1; should find Kennedys:", new Stmt(null, lastname, (Value)kennedy), conLesmis, lastname, (Value)kennedy);
            this.assert22k("Using getStatements() on conn2; should find Kennedys:", new Stmt(null, lastname, (Value)kennedy), conKennedy, lastname, (Value)kennedy);
            this.assert22("Using getStatements() on conn2; should find Valjean:", new Stmt((Resource)char11, title, (Value)valjean), conKennedy, (Value)valjean);
        }
    }
}

