/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.repository.AGTupleQuery;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import test.AGAbstractTest;

@RunWith(value=Parameterized.class)
public class UnicodeTQRFormatTest
extends AGAbstractTest {
    private final TupleQueryResultFormat format;
    private TupleQueryResultFormat oldFormat;

    public UnicodeTQRFormatTest(TupleQueryResultFormat format) {
        this.format = format;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({TupleQueryResultFormat.TSV}, {TupleQueryResultFormat.SPARQL}, {TupleQueryResultFormat.JSON});
    }

    @Before
    public void setUpFormat() {
        this.oldFormat = this.conn.prepareHttpRepoClient().getPreferredTQRFormat();
        this.conn.prepareHttpRepoClient().setPreferredTQRFormat(this.format);
    }

    @After
    public void tearDownFormat() {
        this.conn.prepareHttpRepoClient().setPreferredTQRFormat(this.oldFormat);
    }

    @Test
    public void testUnicodeSelect() throws RepositoryException, QueryEvaluationException {
        IRI s = this.vf.createIRI("http://franz.com/s");
        IRI p = this.vf.createIRI("http://franz.com/p");
        Literal o = this.vf.createLiteral("\u091c\u0941\u092a");
        this.conn.add((Resource)s, p, (Value)o, new Resource[0]);
        AGTupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, "SELECT ?o WHERE { ?s ?p ?o }");
        List result = Iterations.asList((Iteration)query.evaluate());
        Assert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((BindingSet)result.get(0)).getValue("o").stringValue(), (Matcher)CoreMatchers.is((Object)"\u091c\u0941\u092a"));
    }
}

