/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.http.handler.AGJSONHandler;
import com.franz.agraph.http.handler.AGStringHandler;
import com.franz.agraph.repository.AGGraphQuery;
import com.franz.agraph.repository.AGTupleQuery;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.io.input.ReaderInputStream;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.json.JSONException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import test.AGAbstractTest;

public class UnicodeTest
extends AGAbstractTest {
    private RDFFormat oldRDFFormat;
    private TupleQueryResultFormat oldTQRFormat;

    @Before
    public void setUpFormat() {
        this.oldRDFFormat = this.conn.prepareHttpRepoClient().getPreferredRDFFormat();
        this.oldTQRFormat = this.conn.prepareHttpRepoClient().getPreferredTQRFormat();
    }

    @After
    public void tearDownFormat() {
        this.conn.prepareHttpRepoClient().setPreferredRDFFormat(this.oldRDFFormat);
        this.conn.prepareHttpRepoClient().setPreferredTQRFormat(this.oldTQRFormat);
    }

    @Test
    public void testEvalInServer() throws RepositoryException {
        Assert.assertThat((Object)this.conn.evalInServer("\"\u091c\u0941\u092a\""), (Matcher)CoreMatchers.is((Object)"\u091c\u0941\u092a"));
    }

    @Test
    public void testStringHandler() throws IOException, AGHttpException {
        AGStringHandler handler = new AGStringHandler();
        handler.handleResponse(this.mockResponse("\u091c\u0941\u092a", "text/plain", "UTF-8"));
        Assert.assertThat((Object)handler.getResult(), (Matcher)CoreMatchers.is((Object)"\u091c\u0941\u092a"));
    }

    @Test
    public void testJSONHandler() throws IOException, AGHttpException, JSONException {
        AGJSONHandler handler = new AGJSONHandler();
        handler.handleResponse(this.mockResponse("{\"value\":\"\u091c\u0941\u092a\"}", "application/json", "UTF-8"));
        Assert.assertThat((Object)handler.getResult().get("value"), (Matcher)CoreMatchers.is((Object)"\u091c\u0941\u092a"));
    }

    public void testAddUnicodeLiteral(RDFFormat format) throws RepositoryException {
        this.conn.prepareHttpRepoClient().setPreferredRDFFormat(format);
        IRI s = this.vf.createIRI("http://franz.com/s");
        IRI p = this.vf.createIRI("http://franz.com/p");
        Literal o = this.vf.createLiteral("\u091c\u0941\u092a");
        this.conn.add((Resource)s, p, (Value)o, new Resource[0]);
        List result = Iterations.asList((Iteration)this.conn.getStatements((Resource)s, p, null, false, new Resource[0]));
        Assert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((Statement)result.get(0)).getObject().stringValue(), (Matcher)CoreMatchers.is((Object)"\u091c\u0941\u092a"));
    }

    @Test
    public void testAddUnicodeLiteralNQuads() throws Exception {
        this.testAddUnicodeLiteral(RDFFormat.NQUADS);
    }

    @Test
    public void testAddUnicodeLiteralTrix() throws Exception {
        this.testAddUnicodeLiteral(RDFFormat.TRIX);
    }

    public void testAddUnicodeSubject(RDFFormat format) throws RepositoryException {
        this.conn.prepareHttpRepoClient().setPreferredRDFFormat(format);
        IRI s = this.vf.createIRI("http://franz.com/\u091c\u0941\u092a");
        IRI p = this.vf.createIRI("http://franz.com/p");
        Literal o = this.vf.createLiteral("o");
        this.conn.add((Resource)s, p, (Value)o, new Resource[0]);
        List result = Iterations.asList((Iteration)this.conn.getStatements((Resource)s, p, null, false, new Resource[0]));
        Assert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((Statement)result.get(0)).getSubject().stringValue(), (Matcher)CoreMatchers.is((Object)"http://franz.com/\u091c\u0941\u092a"));
    }

    @Test
    public void testAddUnicodeSubjectNQuads() throws Exception {
        this.testAddUnicodeSubject(RDFFormat.NQUADS);
    }

    @Test
    public void testAddUnicodeSubjectTrix() throws Exception {
        this.testAddUnicodeSubject(RDFFormat.TRIX);
    }

    public void testUnicodeCreate(RDFFormat format) throws RepositoryException, QueryEvaluationException {
        this.conn.prepareHttpRepoClient().setPreferredRDFFormat(format);
        AGGraphQuery query = this.conn.prepareGraphQuery(QueryLanguage.SPARQL, "CONSTRUCT { <s> <p> \"\u091c\u0941\u092a\"} WHERE {}");
        List result = Iterations.asList((Iteration)query.evaluate());
        Assert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((Statement)result.get(0)).getObject().stringValue(), (Matcher)CoreMatchers.is((Object)"\u091c\u0941\u092a"));
    }

    @Test
    public void testUnicodeCreateNQuads() throws Exception {
        this.testUnicodeCreate(RDFFormat.NQUADS);
    }

    @Test
    public void testUnicodeCreateTrix() throws Exception {
        this.testUnicodeCreate(RDFFormat.TRIX);
    }

    public void testUnicodeSelect(TupleQueryResultFormat format) throws RepositoryException, QueryEvaluationException {
        this.conn.prepareHttpRepoClient().setPreferredTQRFormat(format);
        IRI s = this.vf.createIRI("http://franz.com/s");
        IRI p = this.vf.createIRI("http://franz.com/p");
        Literal o = this.vf.createLiteral("\u091c\u0941\u092a");
        this.conn.add((Resource)s, p, (Value)o, new Resource[0]);
        AGTupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, "SELECT ?o WHERE { ?s ?p ?o }");
        List result = Iterations.asList((Iteration)query.evaluate());
        Assert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((BindingSet)result.get(0)).getValue("o").stringValue(), (Matcher)CoreMatchers.is((Object)"\u091c\u0941\u092a"));
    }

    @Test
    public void testUnicodeSelectTSV() throws Exception {
        this.testUnicodeSelect(TupleQueryResultFormat.TSV);
    }

    @Test
    public void testUnicodeSelectJSON() throws Exception {
        this.testUnicodeSelect(TupleQueryResultFormat.JSON);
    }

    @Test
    public void testUnicodeSelectSPARQL() throws Exception {
        this.testUnicodeSelect(TupleQueryResultFormat.SPARQL);
    }

    private HttpMethod mockResponse(final String text, final String mimeType, final String encoding) {
        return new HttpMethodBase(){
            {
                this.setResponseStream((InputStream)new ReaderInputStream((Reader)new StringReader(text), encoding));
            }

            public String getName() {
                return "GET";
            }

            public String getResponseCharSet() {
                return encoding;
            }

            public Header[] getResponseHeaders(String headerName) {
                if (headerName.equalsIgnoreCase("content-type")) {
                    return new Header[]{new Header("Content-Type", mimeType + ";charset=" + encoding)};
                }
                return super.getResponseHeaders(headerName);
            }
        };
    }
}

