/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.jena.AGGraph;
import com.franz.agraph.jena.AGGraphMaker;
import com.franz.agraph.jena.AGModel;
import com.franz.agraph.jena.AGQuery;
import com.franz.agraph.jena.AGQueryExecution;
import com.franz.agraph.jena.AGQueryExecutionFactory;
import com.franz.agraph.jena.AGQueryFactory;
import junit.framework.Assert;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDFS;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import test.AGAbstractTest;
import test.TestSuites;

public class UntypedLiteralMatchingTest
extends AGAbstractTest {
    @Test
    @Category(value={TestSuites.Broken.class})
    public void testARQUntypedLiteralMatching() {
        AGGraphMaker maker = this.closeLater(new AGGraphMaker(this.conn));
        AGGraph graph = this.closeLater(maker.createGraph("http://aldi.com.au"));
        AGModel model = this.closeLater(new AGModel(graph));
        String str = "MatchThis";
        model.begin();
        Resource subject = OWL.Thing;
        Property predicate = RDFS.label;
        Literal typedObject = ResourceFactory.createTypedLiteral((Object)str);
        model.add(subject, predicate, (RDFNode)typedObject);
        model.commit();
        Query query = QueryFactory.create((String)("ASK WHERE { <" + subject + "> <" + predicate + "> ?x }"));
        QuerySolutionMap initialBinding = new QuerySolutionMap();
        initialBinding.add("x", (RDFNode)typedObject);
        QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)model, (QuerySolution)initialBinding);
        Assert.assertTrue((boolean)qexec.execAsk());
        initialBinding = new QuerySolutionMap();
        initialBinding.add("x", (RDFNode)ResourceFactory.createPlainLiteral((String)str));
        qexec = QueryExecutionFactory.create((Query)query, (Model)model, (QuerySolution)initialBinding);
        Assert.assertTrue((boolean)qexec.execAsk());
        model.begin();
        model.removeAll();
        model.commit();
        model.abort();
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testAGUntypedLiteralMatching() {
        AGGraphMaker maker = this.closeLater(new AGGraphMaker(this.conn));
        AGGraph graph = this.closeLater(maker.createGraph("http://aldi.com.au"));
        AGModel model = this.closeLater(new AGModel(graph));
        String str = "MatchThis";
        model.begin();
        Resource subject = OWL.Thing;
        Property predicate = RDFS.label;
        Literal typedObject = ResourceFactory.createTypedLiteral((Object)str);
        model.add(subject, predicate, (RDFNode)typedObject);
        model.commit();
        AGQuery query = AGQueryFactory.create((String)("ASK WHERE { <" + subject + "> <" + predicate + "> ?x }"));
        QuerySolutionMap initialBinding = new QuerySolutionMap();
        initialBinding.add("x", (RDFNode)typedObject);
        AGQueryExecution qexec = AGQueryExecutionFactory.create((AGQuery)query, (AGModel)model, (QuerySolution)initialBinding);
        Assert.assertTrue((boolean)qexec.execAsk());
        initialBinding = new QuerySolutionMap();
        initialBinding.add("x", (RDFNode)ResourceFactory.createPlainLiteral((String)str));
        qexec = AGQueryExecutionFactory.create((AGQuery)query, (AGModel)model, (QuerySolution)initialBinding);
        Assert.assertTrue((boolean)qexec.execAsk());
        model.begin();
        model.removeAll();
        model.commit();
        model.abort();
    }
}

